/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.aws.v1.Subnet;
import io.fabric8.openshift.api.model.installer.aws.v1.SubnetRole;
import io.fabric8.openshift.api.model.installer.aws.v1.SubnetRoleBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.SubnetRoleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SubnetFluent<A extends SubnetFluent<A>>
extends BaseFluent<A> {
    private String id;
    private ArrayList<SubnetRoleBuilder> roles = new ArrayList();
    private Map<String, Object> additionalProperties;

    public SubnetFluent() {
    }

    public SubnetFluent(Subnet instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Subnet instance) {
        Subnet subnet = instance = instance != null ? instance : new Subnet();
        if (instance != null) {
            this.withId(instance.getId());
            this.withRoles(instance.getRoles());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public A addToRoles(int index, SubnetRole item) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
        if (index < 0 || index >= this.roles.size()) {
            this._visitables.get("roles").add(builder);
            this.roles.add(builder);
        } else {
            this._visitables.get("roles").add(builder);
            this.roles.add(index, builder);
        }
        return (A)this;
    }

    public A setToRoles(int index, SubnetRole item) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
        if (index < 0 || index >= this.roles.size()) {
            this._visitables.get("roles").add(builder);
            this.roles.add(builder);
        } else {
            this._visitables.get("roles").add(builder);
            this.roles.set(index, builder);
        }
        return (A)this;
    }

    public A addToRoles(SubnetRole ... items) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        for (SubnetRole item : items) {
            SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
            this._visitables.get("roles").add(builder);
            this.roles.add(builder);
        }
        return (A)this;
    }

    public A addAllToRoles(Collection<SubnetRole> items) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        for (SubnetRole item : items) {
            SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
            this._visitables.get("roles").add(builder);
            this.roles.add(builder);
        }
        return (A)this;
    }

    public A removeFromRoles(SubnetRole ... items) {
        if (this.roles == null) {
            return (A)this;
        }
        for (SubnetRole item : items) {
            SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
            this._visitables.get("roles").remove(builder);
            this.roles.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRoles(Collection<SubnetRole> items) {
        if (this.roles == null) {
            return (A)this;
        }
        for (SubnetRole item : items) {
            SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
            this._visitables.get("roles").remove(builder);
            this.roles.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRoles(Predicate<SubnetRoleBuilder> predicate) {
        if (this.roles == null) {
            return (A)this;
        }
        Iterator<SubnetRoleBuilder> each = this.roles.iterator();
        Object visitables = this._visitables.get("roles");
        while (each.hasNext()) {
            SubnetRoleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SubnetRole> buildRoles() {
        return this.roles != null ? SubnetFluent.build(this.roles) : null;
    }

    public SubnetRole buildRole(int index) {
        return this.roles.get(index).build();
    }

    public SubnetRole buildFirstRole() {
        return this.roles.get(0).build();
    }

    public SubnetRole buildLastRole() {
        return this.roles.get(this.roles.size() - 1).build();
    }

    public SubnetRole buildMatchingRole(Predicate<SubnetRoleBuilder> predicate) {
        for (SubnetRoleBuilder item : this.roles) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRole(Predicate<SubnetRoleBuilder> predicate) {
        for (SubnetRoleBuilder item : this.roles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRoles(List<SubnetRole> roles) {
        if (this.roles != null) {
            this._visitables.get("roles").clear();
        }
        if (roles != null) {
            this.roles = new ArrayList();
            for (SubnetRole item : roles) {
                this.addToRoles(item);
            }
        } else {
            this.roles = null;
        }
        return (A)this;
    }

    public A withRoles(SubnetRole ... roles) {
        if (this.roles != null) {
            this.roles.clear();
            this._visitables.remove("roles");
        }
        if (roles != null) {
            for (SubnetRole item : roles) {
                this.addToRoles(item);
            }
        }
        return (A)this;
    }

    public boolean hasRoles() {
        return this.roles != null && !this.roles.isEmpty();
    }

    public A addNewRole(String type) {
        return this.addToRoles(new SubnetRole(type));
    }

    public RolesNested<A> addNewRole() {
        return new RolesNested(-1, null);
    }

    public RolesNested<A> addNewRoleLike(SubnetRole item) {
        return new RolesNested(-1, item);
    }

    public RolesNested<A> setNewRoleLike(int index, SubnetRole item) {
        return new RolesNested(index, item);
    }

    public RolesNested<A> editRole(int index) {
        if (this.roles.size() <= index) {
            throw new RuntimeException("Can't edit roles. Index exceeds size.");
        }
        return this.setNewRoleLike(index, this.buildRole(index));
    }

    public RolesNested<A> editFirstRole() {
        if (this.roles.size() == 0) {
            throw new RuntimeException("Can't edit first roles. The list is empty.");
        }
        return this.setNewRoleLike(0, this.buildRole(0));
    }

    public RolesNested<A> editLastRole() {
        int index = this.roles.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last roles. The list is empty.");
        }
        return this.setNewRoleLike(index, this.buildRole(index));
    }

    public RolesNested<A> editMatchingRole(Predicate<SubnetRoleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.roles.size(); ++i) {
            if (!predicate.test(this.roles.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching roles. No match found.");
        }
        return this.setNewRoleLike(index, this.buildRole(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubnetFluent that = (SubnetFluent)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.roles, that.roles)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.roles, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            sb.append("roles:");
            sb.append(String.valueOf(this.roles) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RolesNested<N>
    extends SubnetRoleFluent<RolesNested<N>>
    implements Nested<N> {
        SubnetRoleBuilder builder;
        int index;

        RolesNested(int index, SubnetRole item) {
            this.index = index;
            this.builder = new SubnetRoleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubnetFluent.this.setToRoles(this.index, this.builder.build());
        }

        public N endRole() {
            return this.and();
        }
    }
}

