/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.config.v1.IdentityProvider;
import io.fabric8.openshift.api.model.config.v1.OAuthSpecBuilder;
import io.fabric8.openshift.api.model.config.v1.OAuthTemplates;
import io.fabric8.openshift.api.model.config.v1.TokenConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"identityProviders", "templates", "tokenConfig"})
public class OAuthSpec
implements Editable<OAuthSpecBuilder>,
KubernetesResource {
    @JsonProperty(value="identityProviders")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<IdentityProvider> identityProviders = new ArrayList<IdentityProvider>();
    @JsonProperty(value="templates")
    private OAuthTemplates templates;
    @JsonProperty(value="tokenConfig")
    private TokenConfig tokenConfig;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public OAuthSpec() {
    }

    public OAuthSpec(List<IdentityProvider> identityProviders, OAuthTemplates templates, TokenConfig tokenConfig) {
        this.identityProviders = identityProviders;
        this.templates = templates;
        this.tokenConfig = tokenConfig;
    }

    @JsonProperty(value="identityProviders")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<IdentityProvider> getIdentityProviders() {
        return this.identityProviders;
    }

    @JsonProperty(value="identityProviders")
    public void setIdentityProviders(List<IdentityProvider> identityProviders) {
        this.identityProviders = identityProviders;
    }

    @JsonProperty(value="templates")
    public OAuthTemplates getTemplates() {
        return this.templates;
    }

    @JsonProperty(value="templates")
    public void setTemplates(OAuthTemplates templates) {
        this.templates = templates;
    }

    @JsonProperty(value="tokenConfig")
    public TokenConfig getTokenConfig() {
        return this.tokenConfig;
    }

    @JsonProperty(value="tokenConfig")
    public void setTokenConfig(TokenConfig tokenConfig) {
        this.tokenConfig = tokenConfig;
    }

    @Override
    @JsonIgnore
    public OAuthSpecBuilder edit() {
        return new OAuthSpecBuilder(this);
    }

    @JsonIgnore
    public OAuthSpecBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    @JsonIgnore
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Generated
    public String toString() {
        return "OAuthSpec(identityProviders=" + String.valueOf(this.getIdentityProviders()) + ", templates=" + String.valueOf(this.getTemplates()) + ", tokenConfig=" + String.valueOf(this.getTokenConfig()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthSpec)) {
            return false;
        }
        OAuthSpec other = (OAuthSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<IdentityProvider> this$identityProviders = this.getIdentityProviders();
        List<IdentityProvider> other$identityProviders = other.getIdentityProviders();
        if (this$identityProviders == null ? other$identityProviders != null : !((Object)this$identityProviders).equals(other$identityProviders)) {
            return false;
        }
        OAuthTemplates this$templates = this.getTemplates();
        OAuthTemplates other$templates = other.getTemplates();
        if (this$templates == null ? other$templates != null : !((Object)this$templates).equals(other$templates)) {
            return false;
        }
        TokenConfig this$tokenConfig = this.getTokenConfig();
        TokenConfig other$tokenConfig = other.getTokenConfig();
        if (this$tokenConfig == null ? other$tokenConfig != null : !((Object)this$tokenConfig).equals(other$tokenConfig)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuthSpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<IdentityProvider> $identityProviders = this.getIdentityProviders();
        result = result * 59 + ($identityProviders == null ? 43 : ((Object)$identityProviders).hashCode());
        OAuthTemplates $templates = this.getTemplates();
        result = result * 59 + ($templates == null ? 43 : ((Object)$templates).hashCode());
        TokenConfig $tokenConfig = this.getTokenConfig();
        result = result * 59 + ($tokenConfig == null ? 43 : ((Object)$tokenConfig).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

