/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayClassStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SupportedFeature;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SupportedFeatureBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SupportedFeatureFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GatewayClassStatusFluent<A extends GatewayClassStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private ArrayList<SupportedFeatureBuilder> supportedFeatures = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GatewayClassStatusFluent() {
    }

    public GatewayClassStatusFluent(GatewayClassStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GatewayClassStatus instance) {
        GatewayClassStatus gatewayClassStatus = instance = instance != null ? instance : new GatewayClassStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withSupportedFeatures(instance.getSupportedFeatures());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addToSupportedFeatures(int index, SupportedFeature item) {
        if (this.supportedFeatures == null) {
            this.supportedFeatures = new ArrayList();
        }
        SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);
        if (index < 0 || index >= this.supportedFeatures.size()) {
            this._visitables.get("supportedFeatures").add(builder);
            this.supportedFeatures.add(builder);
        } else {
            this._visitables.get("supportedFeatures").add(builder);
            this.supportedFeatures.add(index, builder);
        }
        return (A)this;
    }

    public A setToSupportedFeatures(int index, SupportedFeature item) {
        if (this.supportedFeatures == null) {
            this.supportedFeatures = new ArrayList();
        }
        SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);
        if (index < 0 || index >= this.supportedFeatures.size()) {
            this._visitables.get("supportedFeatures").add(builder);
            this.supportedFeatures.add(builder);
        } else {
            this._visitables.get("supportedFeatures").add(builder);
            this.supportedFeatures.set(index, builder);
        }
        return (A)this;
    }

    public A addToSupportedFeatures(SupportedFeature ... items) {
        if (this.supportedFeatures == null) {
            this.supportedFeatures = new ArrayList();
        }
        for (SupportedFeature item : items) {
            SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);
            this._visitables.get("supportedFeatures").add(builder);
            this.supportedFeatures.add(builder);
        }
        return (A)this;
    }

    public A addAllToSupportedFeatures(Collection<SupportedFeature> items) {
        if (this.supportedFeatures == null) {
            this.supportedFeatures = new ArrayList();
        }
        for (SupportedFeature item : items) {
            SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);
            this._visitables.get("supportedFeatures").add(builder);
            this.supportedFeatures.add(builder);
        }
        return (A)this;
    }

    public A removeFromSupportedFeatures(SupportedFeature ... items) {
        if (this.supportedFeatures == null) {
            return (A)this;
        }
        for (SupportedFeature item : items) {
            SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);
            this._visitables.get("supportedFeatures").remove(builder);
            this.supportedFeatures.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSupportedFeatures(Collection<SupportedFeature> items) {
        if (this.supportedFeatures == null) {
            return (A)this;
        }
        for (SupportedFeature item : items) {
            SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);
            this._visitables.get("supportedFeatures").remove(builder);
            this.supportedFeatures.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSupportedFeatures(Predicate<SupportedFeatureBuilder> predicate) {
        if (this.supportedFeatures == null) {
            return (A)this;
        }
        Iterator<SupportedFeatureBuilder> each = this.supportedFeatures.iterator();
        Object visitables = this._visitables.get("supportedFeatures");
        while (each.hasNext()) {
            SupportedFeatureBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SupportedFeature> buildSupportedFeatures() {
        return this.supportedFeatures != null ? GatewayClassStatusFluent.build(this.supportedFeatures) : null;
    }

    public SupportedFeature buildSupportedFeature(int index) {
        return this.supportedFeatures.get(index).build();
    }

    public SupportedFeature buildFirstSupportedFeature() {
        return this.supportedFeatures.get(0).build();
    }

    public SupportedFeature buildLastSupportedFeature() {
        return this.supportedFeatures.get(this.supportedFeatures.size() - 1).build();
    }

    public SupportedFeature buildMatchingSupportedFeature(Predicate<SupportedFeatureBuilder> predicate) {
        for (SupportedFeatureBuilder item : this.supportedFeatures) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSupportedFeature(Predicate<SupportedFeatureBuilder> predicate) {
        for (SupportedFeatureBuilder item : this.supportedFeatures) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSupportedFeatures(List<SupportedFeature> supportedFeatures) {
        if (this.supportedFeatures != null) {
            this._visitables.get("supportedFeatures").clear();
        }
        if (supportedFeatures != null) {
            this.supportedFeatures = new ArrayList();
            for (SupportedFeature item : supportedFeatures) {
                this.addToSupportedFeatures(item);
            }
        } else {
            this.supportedFeatures = null;
        }
        return (A)this;
    }

    public A withSupportedFeatures(SupportedFeature ... supportedFeatures) {
        if (this.supportedFeatures != null) {
            this.supportedFeatures.clear();
            this._visitables.remove("supportedFeatures");
        }
        if (supportedFeatures != null) {
            for (SupportedFeature item : supportedFeatures) {
                this.addToSupportedFeatures(item);
            }
        }
        return (A)this;
    }

    public boolean hasSupportedFeatures() {
        return this.supportedFeatures != null && !this.supportedFeatures.isEmpty();
    }

    public A addNewSupportedFeature(String name) {
        return this.addToSupportedFeatures(new SupportedFeature(name));
    }

    public SupportedFeaturesNested<A> addNewSupportedFeature() {
        return new SupportedFeaturesNested(-1, null);
    }

    public SupportedFeaturesNested<A> addNewSupportedFeatureLike(SupportedFeature item) {
        return new SupportedFeaturesNested(-1, item);
    }

    public SupportedFeaturesNested<A> setNewSupportedFeatureLike(int index, SupportedFeature item) {
        return new SupportedFeaturesNested(index, item);
    }

    public SupportedFeaturesNested<A> editSupportedFeature(int index) {
        if (this.supportedFeatures.size() <= index) {
            throw new RuntimeException("Can't edit supportedFeatures. Index exceeds size.");
        }
        return this.setNewSupportedFeatureLike(index, this.buildSupportedFeature(index));
    }

    public SupportedFeaturesNested<A> editFirstSupportedFeature() {
        if (this.supportedFeatures.size() == 0) {
            throw new RuntimeException("Can't edit first supportedFeatures. The list is empty.");
        }
        return this.setNewSupportedFeatureLike(0, this.buildSupportedFeature(0));
    }

    public SupportedFeaturesNested<A> editLastSupportedFeature() {
        int index = this.supportedFeatures.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last supportedFeatures. The list is empty.");
        }
        return this.setNewSupportedFeatureLike(index, this.buildSupportedFeature(index));
    }

    public SupportedFeaturesNested<A> editMatchingSupportedFeature(Predicate<SupportedFeatureBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.supportedFeatures.size(); ++i) {
            if (!predicate.test(this.supportedFeatures.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching supportedFeatures. No match found.");
        }
        return this.setNewSupportedFeatureLike(index, this.buildSupportedFeature(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewayClassStatusFluent that = (GatewayClassStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.supportedFeatures, that.supportedFeatures)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.supportedFeatures, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.supportedFeatures != null && !this.supportedFeatures.isEmpty()) {
            sb.append("supportedFeatures:");
            sb.append(String.valueOf(this.supportedFeatures) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SupportedFeaturesNested<N>
    extends SupportedFeatureFluent<SupportedFeaturesNested<N>>
    implements Nested<N> {
        SupportedFeatureBuilder builder;
        int index;

        SupportedFeaturesNested(int index, SupportedFeature item) {
            this.index = index;
            this.builder = new SupportedFeatureBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GatewayClassStatusFluent.this.setToSupportedFeatures(this.index, this.builder.build());
        }

        public N endSupportedFeature() {
            return this.and();
        }
    }
}

