/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.packages.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.GroupVersionKind;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.AppLink;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.AppLinkBuilder;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.AppLinkFluent;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.CSVDescription;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.Icon;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.IconBuilder;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.IconFluent;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.Maintainer;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.MaintainerBuilder;
import io.fabric8.openshift.api.model.operatorhub.packages.v1.MaintainerFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.APIServiceDefinitions;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.APIServiceDefinitionsBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.APIServiceDefinitionsFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CustomResourceDefinitions;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CustomResourceDefinitionsBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CustomResourceDefinitionsFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallMode;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallModeBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallModeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CSVDescriptionFluent<A extends CSVDescriptionFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private APIServiceDefinitionsBuilder apiservicedefinitions;
    private CustomResourceDefinitionsBuilder customresourcedefinitions;
    private String description;
    private String displayName;
    private ArrayList<IconBuilder> icon = new ArrayList();
    private ArrayList<InstallModeBuilder> installModes = new ArrayList();
    private List<String> keywords = new ArrayList<String>();
    private ArrayList<AppLinkBuilder> links = new ArrayList();
    private ArrayList<MaintainerBuilder> maintainers = new ArrayList();
    private String maturity;
    private String minKubeVersion;
    private List<GroupVersionKind> nativeApis = new ArrayList<GroupVersionKind>();
    private AppLinkBuilder provider;
    private List<String> relatedImages = new ArrayList<String>();
    private String version;
    private Map<String, Object> additionalProperties;

    public CSVDescriptionFluent() {
    }

    public CSVDescriptionFluent(CSVDescription instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CSVDescription instance) {
        CSVDescription cSVDescription = instance = instance != null ? instance : new CSVDescription();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withApiservicedefinitions(instance.getApiservicedefinitions());
            this.withCustomresourcedefinitions(instance.getCustomresourcedefinitions());
            this.withDescription(instance.getDescription());
            this.withDisplayName(instance.getDisplayName());
            this.withIcon(instance.getIcon());
            this.withInstallModes(instance.getInstallModes());
            this.withKeywords(instance.getKeywords());
            this.withLinks(instance.getLinks());
            this.withMaintainers(instance.getMaintainers());
            this.withMaturity(instance.getMaturity());
            this.withMinKubeVersion(instance.getMinKubeVersion());
            this.withNativeApis(instance.getNativeApis());
            this.withProvider(instance.getProvider());
            this.withRelatedImages(instance.getRelatedImages());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public APIServiceDefinitions buildApiservicedefinitions() {
        return this.apiservicedefinitions != null ? this.apiservicedefinitions.build() : null;
    }

    public A withApiservicedefinitions(APIServiceDefinitions apiservicedefinitions) {
        this._visitables.remove("apiservicedefinitions");
        if (apiservicedefinitions != null) {
            this.apiservicedefinitions = new APIServiceDefinitionsBuilder(apiservicedefinitions);
            this._visitables.get("apiservicedefinitions").add(this.apiservicedefinitions);
        } else {
            this.apiservicedefinitions = null;
            this._visitables.get("apiservicedefinitions").remove(this.apiservicedefinitions);
        }
        return (A)this;
    }

    public boolean hasApiservicedefinitions() {
        return this.apiservicedefinitions != null;
    }

    public ApiservicedefinitionsNested<A> withNewApiservicedefinitions() {
        return new ApiservicedefinitionsNested(null);
    }

    public ApiservicedefinitionsNested<A> withNewApiservicedefinitionsLike(APIServiceDefinitions item) {
        return new ApiservicedefinitionsNested(item);
    }

    public ApiservicedefinitionsNested<A> editApiservicedefinitions() {
        return this.withNewApiservicedefinitionsLike(Optional.ofNullable(this.buildApiservicedefinitions()).orElse(null));
    }

    public ApiservicedefinitionsNested<A> editOrNewApiservicedefinitions() {
        return this.withNewApiservicedefinitionsLike(Optional.ofNullable(this.buildApiservicedefinitions()).orElse(new APIServiceDefinitionsBuilder().build()));
    }

    public ApiservicedefinitionsNested<A> editOrNewApiservicedefinitionsLike(APIServiceDefinitions item) {
        return this.withNewApiservicedefinitionsLike(Optional.ofNullable(this.buildApiservicedefinitions()).orElse(item));
    }

    public CustomResourceDefinitions buildCustomresourcedefinitions() {
        return this.customresourcedefinitions != null ? this.customresourcedefinitions.build() : null;
    }

    public A withCustomresourcedefinitions(CustomResourceDefinitions customresourcedefinitions) {
        this._visitables.remove("customresourcedefinitions");
        if (customresourcedefinitions != null) {
            this.customresourcedefinitions = new CustomResourceDefinitionsBuilder(customresourcedefinitions);
            this._visitables.get("customresourcedefinitions").add(this.customresourcedefinitions);
        } else {
            this.customresourcedefinitions = null;
            this._visitables.get("customresourcedefinitions").remove(this.customresourcedefinitions);
        }
        return (A)this;
    }

    public boolean hasCustomresourcedefinitions() {
        return this.customresourcedefinitions != null;
    }

    public CustomresourcedefinitionsNested<A> withNewCustomresourcedefinitions() {
        return new CustomresourcedefinitionsNested(null);
    }

    public CustomresourcedefinitionsNested<A> withNewCustomresourcedefinitionsLike(CustomResourceDefinitions item) {
        return new CustomresourcedefinitionsNested(item);
    }

    public CustomresourcedefinitionsNested<A> editCustomresourcedefinitions() {
        return this.withNewCustomresourcedefinitionsLike(Optional.ofNullable(this.buildCustomresourcedefinitions()).orElse(null));
    }

    public CustomresourcedefinitionsNested<A> editOrNewCustomresourcedefinitions() {
        return this.withNewCustomresourcedefinitionsLike(Optional.ofNullable(this.buildCustomresourcedefinitions()).orElse(new CustomResourceDefinitionsBuilder().build()));
    }

    public CustomresourcedefinitionsNested<A> editOrNewCustomresourcedefinitionsLike(CustomResourceDefinitions item) {
        return this.withNewCustomresourcedefinitionsLike(Optional.ofNullable(this.buildCustomresourcedefinitions()).orElse(item));
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)this;
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public A addToIcon(int index, Icon item) {
        if (this.icon == null) {
            this.icon = new ArrayList();
        }
        IconBuilder builder = new IconBuilder(item);
        if (index < 0 || index >= this.icon.size()) {
            this._visitables.get("icon").add(builder);
            this.icon.add(builder);
        } else {
            this._visitables.get("icon").add(builder);
            this.icon.add(index, builder);
        }
        return (A)this;
    }

    public A setToIcon(int index, Icon item) {
        if (this.icon == null) {
            this.icon = new ArrayList();
        }
        IconBuilder builder = new IconBuilder(item);
        if (index < 0 || index >= this.icon.size()) {
            this._visitables.get("icon").add(builder);
            this.icon.add(builder);
        } else {
            this._visitables.get("icon").add(builder);
            this.icon.set(index, builder);
        }
        return (A)this;
    }

    public A addToIcon(Icon ... items) {
        if (this.icon == null) {
            this.icon = new ArrayList();
        }
        for (Icon item : items) {
            IconBuilder builder = new IconBuilder(item);
            this._visitables.get("icon").add(builder);
            this.icon.add(builder);
        }
        return (A)this;
    }

    public A addAllToIcon(Collection<Icon> items) {
        if (this.icon == null) {
            this.icon = new ArrayList();
        }
        for (Icon item : items) {
            IconBuilder builder = new IconBuilder(item);
            this._visitables.get("icon").add(builder);
            this.icon.add(builder);
        }
        return (A)this;
    }

    public A removeFromIcon(Icon ... items) {
        if (this.icon == null) {
            return (A)this;
        }
        for (Icon item : items) {
            IconBuilder builder = new IconBuilder(item);
            this._visitables.get("icon").remove(builder);
            this.icon.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromIcon(Collection<Icon> items) {
        if (this.icon == null) {
            return (A)this;
        }
        for (Icon item : items) {
            IconBuilder builder = new IconBuilder(item);
            this._visitables.get("icon").remove(builder);
            this.icon.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromIcon(Predicate<IconBuilder> predicate) {
        if (this.icon == null) {
            return (A)this;
        }
        Iterator<IconBuilder> each = this.icon.iterator();
        Object visitables = this._visitables.get("icon");
        while (each.hasNext()) {
            IconBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Icon> buildIcon() {
        return this.icon != null ? CSVDescriptionFluent.build(this.icon) : null;
    }

    public Icon buildIcon(int index) {
        return this.icon.get(index).build();
    }

    public Icon buildFirstIcon() {
        return this.icon.get(0).build();
    }

    public Icon buildLastIcon() {
        return this.icon.get(this.icon.size() - 1).build();
    }

    public Icon buildMatchingIcon(Predicate<IconBuilder> predicate) {
        for (IconBuilder item : this.icon) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIcon(Predicate<IconBuilder> predicate) {
        for (IconBuilder item : this.icon) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIcon(List<Icon> icon) {
        if (this.icon != null) {
            this._visitables.get("icon").clear();
        }
        if (icon != null) {
            this.icon = new ArrayList();
            for (Icon item : icon) {
                this.addToIcon(item);
            }
        } else {
            this.icon = null;
        }
        return (A)this;
    }

    public A withIcon(Icon ... icon) {
        if (this.icon != null) {
            this.icon.clear();
            this._visitables.remove("icon");
        }
        if (icon != null) {
            for (Icon item : icon) {
                this.addToIcon(item);
            }
        }
        return (A)this;
    }

    public boolean hasIcon() {
        return this.icon != null && !this.icon.isEmpty();
    }

    public A addNewIcon(String base64data, String mediatype) {
        return this.addToIcon(new Icon(base64data, mediatype));
    }

    public IconNested<A> addNewIcon() {
        return new IconNested(-1, null);
    }

    public IconNested<A> addNewIconLike(Icon item) {
        return new IconNested(-1, item);
    }

    public IconNested<A> setNewIconLike(int index, Icon item) {
        return new IconNested(index, item);
    }

    public IconNested<A> editIcon(int index) {
        if (this.icon.size() <= index) {
            throw new RuntimeException("Can't edit icon. Index exceeds size.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    public IconNested<A> editFirstIcon() {
        if (this.icon.size() == 0) {
            throw new RuntimeException("Can't edit first icon. The list is empty.");
        }
        return this.setNewIconLike(0, this.buildIcon(0));
    }

    public IconNested<A> editLastIcon() {
        int index = this.icon.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last icon. The list is empty.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    public IconNested<A> editMatchingIcon(Predicate<IconBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.icon.size(); ++i) {
            if (!predicate.test(this.icon.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching icon. No match found.");
        }
        return this.setNewIconLike(index, this.buildIcon(index));
    }

    public A addToInstallModes(int index, InstallMode item) {
        if (this.installModes == null) {
            this.installModes = new ArrayList();
        }
        InstallModeBuilder builder = new InstallModeBuilder(item);
        if (index < 0 || index >= this.installModes.size()) {
            this._visitables.get("installModes").add(builder);
            this.installModes.add(builder);
        } else {
            this._visitables.get("installModes").add(builder);
            this.installModes.add(index, builder);
        }
        return (A)this;
    }

    public A setToInstallModes(int index, InstallMode item) {
        if (this.installModes == null) {
            this.installModes = new ArrayList();
        }
        InstallModeBuilder builder = new InstallModeBuilder(item);
        if (index < 0 || index >= this.installModes.size()) {
            this._visitables.get("installModes").add(builder);
            this.installModes.add(builder);
        } else {
            this._visitables.get("installModes").add(builder);
            this.installModes.set(index, builder);
        }
        return (A)this;
    }

    public A addToInstallModes(InstallMode ... items) {
        if (this.installModes == null) {
            this.installModes = new ArrayList();
        }
        for (InstallMode item : items) {
            InstallModeBuilder builder = new InstallModeBuilder(item);
            this._visitables.get("installModes").add(builder);
            this.installModes.add(builder);
        }
        return (A)this;
    }

    public A addAllToInstallModes(Collection<InstallMode> items) {
        if (this.installModes == null) {
            this.installModes = new ArrayList();
        }
        for (InstallMode item : items) {
            InstallModeBuilder builder = new InstallModeBuilder(item);
            this._visitables.get("installModes").add(builder);
            this.installModes.add(builder);
        }
        return (A)this;
    }

    public A removeFromInstallModes(InstallMode ... items) {
        if (this.installModes == null) {
            return (A)this;
        }
        for (InstallMode item : items) {
            InstallModeBuilder builder = new InstallModeBuilder(item);
            this._visitables.get("installModes").remove(builder);
            this.installModes.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromInstallModes(Collection<InstallMode> items) {
        if (this.installModes == null) {
            return (A)this;
        }
        for (InstallMode item : items) {
            InstallModeBuilder builder = new InstallModeBuilder(item);
            this._visitables.get("installModes").remove(builder);
            this.installModes.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromInstallModes(Predicate<InstallModeBuilder> predicate) {
        if (this.installModes == null) {
            return (A)this;
        }
        Iterator<InstallModeBuilder> each = this.installModes.iterator();
        Object visitables = this._visitables.get("installModes");
        while (each.hasNext()) {
            InstallModeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<InstallMode> buildInstallModes() {
        return this.installModes != null ? CSVDescriptionFluent.build(this.installModes) : null;
    }

    public InstallMode buildInstallMode(int index) {
        return this.installModes.get(index).build();
    }

    public InstallMode buildFirstInstallMode() {
        return this.installModes.get(0).build();
    }

    public InstallMode buildLastInstallMode() {
        return this.installModes.get(this.installModes.size() - 1).build();
    }

    public InstallMode buildMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
        for (InstallModeBuilder item : this.installModes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
        for (InstallModeBuilder item : this.installModes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInstallModes(List<InstallMode> installModes) {
        if (this.installModes != null) {
            this._visitables.get("installModes").clear();
        }
        if (installModes != null) {
            this.installModes = new ArrayList();
            for (InstallMode item : installModes) {
                this.addToInstallModes(item);
            }
        } else {
            this.installModes = null;
        }
        return (A)this;
    }

    public A withInstallModes(InstallMode ... installModes) {
        if (this.installModes != null) {
            this.installModes.clear();
            this._visitables.remove("installModes");
        }
        if (installModes != null) {
            for (InstallMode item : installModes) {
                this.addToInstallModes(item);
            }
        }
        return (A)this;
    }

    public boolean hasInstallModes() {
        return this.installModes != null && !this.installModes.isEmpty();
    }

    public A addNewInstallMode(Boolean supported, String type) {
        return this.addToInstallModes(new InstallMode(supported, type));
    }

    public InstallModesNested<A> addNewInstallMode() {
        return new InstallModesNested(-1, null);
    }

    public InstallModesNested<A> addNewInstallModeLike(InstallMode item) {
        return new InstallModesNested(-1, item);
    }

    public InstallModesNested<A> setNewInstallModeLike(int index, InstallMode item) {
        return new InstallModesNested(index, item);
    }

    public InstallModesNested<A> editInstallMode(int index) {
        if (this.installModes.size() <= index) {
            throw new RuntimeException("Can't edit installModes. Index exceeds size.");
        }
        return this.setNewInstallModeLike(index, this.buildInstallMode(index));
    }

    public InstallModesNested<A> editFirstInstallMode() {
        if (this.installModes.size() == 0) {
            throw new RuntimeException("Can't edit first installModes. The list is empty.");
        }
        return this.setNewInstallModeLike(0, this.buildInstallMode(0));
    }

    public InstallModesNested<A> editLastInstallMode() {
        int index = this.installModes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last installModes. The list is empty.");
        }
        return this.setNewInstallModeLike(index, this.buildInstallMode(index));
    }

    public InstallModesNested<A> editMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.installModes.size(); ++i) {
            if (!predicate.test(this.installModes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching installModes. No match found.");
        }
        return this.setNewInstallModeLike(index, this.buildInstallMode(index));
    }

    public A addToKeywords(int index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(index, item);
        return (A)this;
    }

    public A setToKeywords(int index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.set(index, item);
        return (A)this;
    }

    public A addToKeywords(String ... items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)this;
    }

    public A addAllToKeywords(Collection<String> items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)this;
    }

    public A removeFromKeywords(String ... items) {
        if (this.keywords == null) {
            return (A)this;
        }
        for (String item : items) {
            this.keywords.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromKeywords(Collection<String> items) {
        if (this.keywords == null) {
            return (A)this;
        }
        for (String item : items) {
            this.keywords.remove(item);
        }
        return (A)this;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public String getKeyword(int index) {
        return this.keywords.get(index);
    }

    public String getFirstKeyword() {
        return this.keywords.get(0);
    }

    public String getLastKeyword() {
        return this.keywords.get(this.keywords.size() - 1);
    }

    public String getMatchingKeyword(Predicate<String> predicate) {
        for (String item : this.keywords) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingKeyword(Predicate<String> predicate) {
        for (String item : this.keywords) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withKeywords(List<String> keywords) {
        if (keywords != null) {
            this.keywords = new ArrayList<String>();
            for (String item : keywords) {
                this.addToKeywords(item);
            }
        } else {
            this.keywords = null;
        }
        return (A)this;
    }

    public A withKeywords(String ... keywords) {
        if (this.keywords != null) {
            this.keywords.clear();
            this._visitables.remove("keywords");
        }
        if (keywords != null) {
            for (String item : keywords) {
                this.addToKeywords(item);
            }
        }
        return (A)this;
    }

    public boolean hasKeywords() {
        return this.keywords != null && !this.keywords.isEmpty();
    }

    public A addToLinks(int index, AppLink item) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        AppLinkBuilder builder = new AppLinkBuilder(item);
        if (index < 0 || index >= this.links.size()) {
            this._visitables.get("links").add(builder);
            this.links.add(builder);
        } else {
            this._visitables.get("links").add(builder);
            this.links.add(index, builder);
        }
        return (A)this;
    }

    public A setToLinks(int index, AppLink item) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        AppLinkBuilder builder = new AppLinkBuilder(item);
        if (index < 0 || index >= this.links.size()) {
            this._visitables.get("links").add(builder);
            this.links.add(builder);
        } else {
            this._visitables.get("links").add(builder);
            this.links.set(index, builder);
        }
        return (A)this;
    }

    public A addToLinks(AppLink ... items) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        for (AppLink item : items) {
            AppLinkBuilder builder = new AppLinkBuilder(item);
            this._visitables.get("links").add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    public A addAllToLinks(Collection<AppLink> items) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        for (AppLink item : items) {
            AppLinkBuilder builder = new AppLinkBuilder(item);
            this._visitables.get("links").add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    public A removeFromLinks(AppLink ... items) {
        if (this.links == null) {
            return (A)this;
        }
        for (AppLink item : items) {
            AppLinkBuilder builder = new AppLinkBuilder(item);
            this._visitables.get("links").remove(builder);
            this.links.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromLinks(Collection<AppLink> items) {
        if (this.links == null) {
            return (A)this;
        }
        for (AppLink item : items) {
            AppLinkBuilder builder = new AppLinkBuilder(item);
            this._visitables.get("links").remove(builder);
            this.links.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromLinks(Predicate<AppLinkBuilder> predicate) {
        if (this.links == null) {
            return (A)this;
        }
        Iterator<AppLinkBuilder> each = this.links.iterator();
        Object visitables = this._visitables.get("links");
        while (each.hasNext()) {
            AppLinkBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AppLink> buildLinks() {
        return this.links != null ? CSVDescriptionFluent.build(this.links) : null;
    }

    public AppLink buildLink(int index) {
        return this.links.get(index).build();
    }

    public AppLink buildFirstLink() {
        return this.links.get(0).build();
    }

    public AppLink buildLastLink() {
        return this.links.get(this.links.size() - 1).build();
    }

    public AppLink buildMatchingLink(Predicate<AppLinkBuilder> predicate) {
        for (AppLinkBuilder item : this.links) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingLink(Predicate<AppLinkBuilder> predicate) {
        for (AppLinkBuilder item : this.links) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLinks(List<AppLink> links) {
        if (this.links != null) {
            this._visitables.get("links").clear();
        }
        if (links != null) {
            this.links = new ArrayList();
            for (AppLink item : links) {
                this.addToLinks(item);
            }
        } else {
            this.links = null;
        }
        return (A)this;
    }

    public A withLinks(AppLink ... links) {
        if (this.links != null) {
            this.links.clear();
            this._visitables.remove("links");
        }
        if (links != null) {
            for (AppLink item : links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    public boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    public A addNewLink(String name, String url) {
        return this.addToLinks(new AppLink(name, url));
    }

    public LinksNested<A> addNewLink() {
        return new LinksNested(-1, null);
    }

    public LinksNested<A> addNewLinkLike(AppLink item) {
        return new LinksNested(-1, item);
    }

    public LinksNested<A> setNewLinkLike(int index, AppLink item) {
        return new LinksNested(index, item);
    }

    public LinksNested<A> editLink(int index) {
        if (this.links.size() <= index) {
            throw new RuntimeException("Can't edit links. Index exceeds size.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public LinksNested<A> editFirstLink() {
        if (this.links.size() == 0) {
            throw new RuntimeException("Can't edit first links. The list is empty.");
        }
        return this.setNewLinkLike(0, this.buildLink(0));
    }

    public LinksNested<A> editLastLink() {
        int index = this.links.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last links. The list is empty.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public LinksNested<A> editMatchingLink(Predicate<AppLinkBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.links.size(); ++i) {
            if (!predicate.test(this.links.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching links. No match found.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public A addToMaintainers(int index, Maintainer item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        MaintainerBuilder builder = new MaintainerBuilder(item);
        if (index < 0 || index >= this.maintainers.size()) {
            this._visitables.get("maintainers").add(builder);
            this.maintainers.add(builder);
        } else {
            this._visitables.get("maintainers").add(builder);
            this.maintainers.add(index, builder);
        }
        return (A)this;
    }

    public A setToMaintainers(int index, Maintainer item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        MaintainerBuilder builder = new MaintainerBuilder(item);
        if (index < 0 || index >= this.maintainers.size()) {
            this._visitables.get("maintainers").add(builder);
            this.maintainers.add(builder);
        } else {
            this._visitables.get("maintainers").add(builder);
            this.maintainers.set(index, builder);
        }
        return (A)this;
    }

    public A addToMaintainers(Maintainer ... items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get("maintainers").add(builder);
            this.maintainers.add(builder);
        }
        return (A)this;
    }

    public A addAllToMaintainers(Collection<Maintainer> items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get("maintainers").add(builder);
            this.maintainers.add(builder);
        }
        return (A)this;
    }

    public A removeFromMaintainers(Maintainer ... items) {
        if (this.maintainers == null) {
            return (A)this;
        }
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get("maintainers").remove(builder);
            this.maintainers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMaintainers(Collection<Maintainer> items) {
        if (this.maintainers == null) {
            return (A)this;
        }
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get("maintainers").remove(builder);
            this.maintainers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMaintainers(Predicate<MaintainerBuilder> predicate) {
        if (this.maintainers == null) {
            return (A)this;
        }
        Iterator<MaintainerBuilder> each = this.maintainers.iterator();
        Object visitables = this._visitables.get("maintainers");
        while (each.hasNext()) {
            MaintainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Maintainer> buildMaintainers() {
        return this.maintainers != null ? CSVDescriptionFluent.build(this.maintainers) : null;
    }

    public Maintainer buildMaintainer(int index) {
        return this.maintainers.get(index).build();
    }

    public Maintainer buildFirstMaintainer() {
        return this.maintainers.get(0).build();
    }

    public Maintainer buildLastMaintainer() {
        return this.maintainers.get(this.maintainers.size() - 1).build();
    }

    public Maintainer buildMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        for (MaintainerBuilder item : this.maintainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        for (MaintainerBuilder item : this.maintainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMaintainers(List<Maintainer> maintainers) {
        if (this.maintainers != null) {
            this._visitables.get("maintainers").clear();
        }
        if (maintainers != null) {
            this.maintainers = new ArrayList();
            for (Maintainer item : maintainers) {
                this.addToMaintainers(item);
            }
        } else {
            this.maintainers = null;
        }
        return (A)this;
    }

    public A withMaintainers(Maintainer ... maintainers) {
        if (this.maintainers != null) {
            this.maintainers.clear();
            this._visitables.remove("maintainers");
        }
        if (maintainers != null) {
            for (Maintainer item : maintainers) {
                this.addToMaintainers(item);
            }
        }
        return (A)this;
    }

    public boolean hasMaintainers() {
        return this.maintainers != null && !this.maintainers.isEmpty();
    }

    public A addNewMaintainer(String email, String name) {
        return this.addToMaintainers(new Maintainer(email, name));
    }

    public MaintainersNested<A> addNewMaintainer() {
        return new MaintainersNested(-1, null);
    }

    public MaintainersNested<A> addNewMaintainerLike(Maintainer item) {
        return new MaintainersNested(-1, item);
    }

    public MaintainersNested<A> setNewMaintainerLike(int index, Maintainer item) {
        return new MaintainersNested(index, item);
    }

    public MaintainersNested<A> editMaintainer(int index) {
        if (this.maintainers.size() <= index) {
            throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    public MaintainersNested<A> editFirstMaintainer() {
        if (this.maintainers.size() == 0) {
            throw new RuntimeException("Can't edit first maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(0, this.buildMaintainer(0));
    }

    public MaintainersNested<A> editLastMaintainer() {
        int index = this.maintainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    public MaintainersNested<A> editMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.maintainers.size(); ++i) {
            if (!predicate.test(this.maintainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching maintainers. No match found.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    public String getMaturity() {
        return this.maturity;
    }

    public A withMaturity(String maturity) {
        this.maturity = maturity;
        return (A)this;
    }

    public boolean hasMaturity() {
        return this.maturity != null;
    }

    public String getMinKubeVersion() {
        return this.minKubeVersion;
    }

    public A withMinKubeVersion(String minKubeVersion) {
        this.minKubeVersion = minKubeVersion;
        return (A)this;
    }

    public boolean hasMinKubeVersion() {
        return this.minKubeVersion != null;
    }

    public A addToNativeApis(int index, GroupVersionKind item) {
        if (this.nativeApis == null) {
            this.nativeApis = new ArrayList<GroupVersionKind>();
        }
        this.nativeApis.add(index, item);
        return (A)this;
    }

    public A setToNativeApis(int index, GroupVersionKind item) {
        if (this.nativeApis == null) {
            this.nativeApis = new ArrayList<GroupVersionKind>();
        }
        this.nativeApis.set(index, item);
        return (A)this;
    }

    public A addToNativeApis(GroupVersionKind ... items) {
        if (this.nativeApis == null) {
            this.nativeApis = new ArrayList<GroupVersionKind>();
        }
        for (GroupVersionKind item : items) {
            this.nativeApis.add(item);
        }
        return (A)this;
    }

    public A addAllToNativeApis(Collection<GroupVersionKind> items) {
        if (this.nativeApis == null) {
            this.nativeApis = new ArrayList<GroupVersionKind>();
        }
        for (GroupVersionKind item : items) {
            this.nativeApis.add(item);
        }
        return (A)this;
    }

    public A removeFromNativeApis(GroupVersionKind ... items) {
        if (this.nativeApis == null) {
            return (A)this;
        }
        for (GroupVersionKind item : items) {
            this.nativeApis.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNativeApis(Collection<GroupVersionKind> items) {
        if (this.nativeApis == null) {
            return (A)this;
        }
        for (GroupVersionKind item : items) {
            this.nativeApis.remove(item);
        }
        return (A)this;
    }

    public List<GroupVersionKind> getNativeApis() {
        return this.nativeApis;
    }

    public GroupVersionKind getNativeApi(int index) {
        return this.nativeApis.get(index);
    }

    public GroupVersionKind getFirstNativeApi() {
        return this.nativeApis.get(0);
    }

    public GroupVersionKind getLastNativeApi() {
        return this.nativeApis.get(this.nativeApis.size() - 1);
    }

    public GroupVersionKind getMatchingNativeApi(Predicate<GroupVersionKind> predicate) {
        for (GroupVersionKind item : this.nativeApis) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNativeApi(Predicate<GroupVersionKind> predicate) {
        for (GroupVersionKind item : this.nativeApis) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNativeApis(List<GroupVersionKind> nativeApis) {
        if (nativeApis != null) {
            this.nativeApis = new ArrayList<GroupVersionKind>();
            for (GroupVersionKind item : nativeApis) {
                this.addToNativeApis(item);
            }
        } else {
            this.nativeApis = null;
        }
        return (A)this;
    }

    public A withNativeApis(GroupVersionKind ... nativeApis) {
        if (this.nativeApis != null) {
            this.nativeApis.clear();
            this._visitables.remove("nativeApis");
        }
        if (nativeApis != null) {
            for (GroupVersionKind item : nativeApis) {
                this.addToNativeApis(item);
            }
        }
        return (A)this;
    }

    public boolean hasNativeApis() {
        return this.nativeApis != null && !this.nativeApis.isEmpty();
    }

    public A addNewNativeApi(String group, String kind, String version) {
        return this.addToNativeApis(new GroupVersionKind(group, kind, version));
    }

    public AppLink buildProvider() {
        return this.provider != null ? this.provider.build() : null;
    }

    public A withProvider(AppLink provider) {
        this._visitables.remove("provider");
        if (provider != null) {
            this.provider = new AppLinkBuilder(provider);
            this._visitables.get("provider").add(this.provider);
        } else {
            this.provider = null;
            this._visitables.get("provider").remove(this.provider);
        }
        return (A)this;
    }

    public boolean hasProvider() {
        return this.provider != null;
    }

    public A withNewProvider(String name, String url) {
        return this.withProvider(new AppLink(name, url));
    }

    public ProviderNested<A> withNewProvider() {
        return new ProviderNested(null);
    }

    public ProviderNested<A> withNewProviderLike(AppLink item) {
        return new ProviderNested(item);
    }

    public ProviderNested<A> editProvider() {
        return this.withNewProviderLike(Optional.ofNullable(this.buildProvider()).orElse(null));
    }

    public ProviderNested<A> editOrNewProvider() {
        return this.withNewProviderLike(Optional.ofNullable(this.buildProvider()).orElse(new AppLinkBuilder().build()));
    }

    public ProviderNested<A> editOrNewProviderLike(AppLink item) {
        return this.withNewProviderLike(Optional.ofNullable(this.buildProvider()).orElse(item));
    }

    public A addToRelatedImages(int index, String item) {
        if (this.relatedImages == null) {
            this.relatedImages = new ArrayList<String>();
        }
        this.relatedImages.add(index, item);
        return (A)this;
    }

    public A setToRelatedImages(int index, String item) {
        if (this.relatedImages == null) {
            this.relatedImages = new ArrayList<String>();
        }
        this.relatedImages.set(index, item);
        return (A)this;
    }

    public A addToRelatedImages(String ... items) {
        if (this.relatedImages == null) {
            this.relatedImages = new ArrayList<String>();
        }
        for (String item : items) {
            this.relatedImages.add(item);
        }
        return (A)this;
    }

    public A addAllToRelatedImages(Collection<String> items) {
        if (this.relatedImages == null) {
            this.relatedImages = new ArrayList<String>();
        }
        for (String item : items) {
            this.relatedImages.add(item);
        }
        return (A)this;
    }

    public A removeFromRelatedImages(String ... items) {
        if (this.relatedImages == null) {
            return (A)this;
        }
        for (String item : items) {
            this.relatedImages.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRelatedImages(Collection<String> items) {
        if (this.relatedImages == null) {
            return (A)this;
        }
        for (String item : items) {
            this.relatedImages.remove(item);
        }
        return (A)this;
    }

    public List<String> getRelatedImages() {
        return this.relatedImages;
    }

    public String getRelatedImage(int index) {
        return this.relatedImages.get(index);
    }

    public String getFirstRelatedImage() {
        return this.relatedImages.get(0);
    }

    public String getLastRelatedImage() {
        return this.relatedImages.get(this.relatedImages.size() - 1);
    }

    public String getMatchingRelatedImage(Predicate<String> predicate) {
        for (String item : this.relatedImages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRelatedImage(Predicate<String> predicate) {
        for (String item : this.relatedImages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRelatedImages(List<String> relatedImages) {
        if (relatedImages != null) {
            this.relatedImages = new ArrayList<String>();
            for (String item : relatedImages) {
                this.addToRelatedImages(item);
            }
        } else {
            this.relatedImages = null;
        }
        return (A)this;
    }

    public A withRelatedImages(String ... relatedImages) {
        if (this.relatedImages != null) {
            this.relatedImages.clear();
            this._visitables.remove("relatedImages");
        }
        if (relatedImages != null) {
            for (String item : relatedImages) {
                this.addToRelatedImages(item);
            }
        }
        return (A)this;
    }

    public boolean hasRelatedImages() {
        return this.relatedImages != null && !this.relatedImages.isEmpty();
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSVDescriptionFluent that = (CSVDescriptionFluent)o;
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.apiservicedefinitions, that.apiservicedefinitions)) {
            return false;
        }
        if (!Objects.equals(this.customresourcedefinitions, that.customresourcedefinitions)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.displayName, that.displayName)) {
            return false;
        }
        if (!Objects.equals(this.icon, that.icon)) {
            return false;
        }
        if (!Objects.equals(this.installModes, that.installModes)) {
            return false;
        }
        if (!Objects.equals(this.keywords, that.keywords)) {
            return false;
        }
        if (!Objects.equals(this.links, that.links)) {
            return false;
        }
        if (!Objects.equals(this.maintainers, that.maintainers)) {
            return false;
        }
        if (!Objects.equals(this.maturity, that.maturity)) {
            return false;
        }
        if (!Objects.equals(this.minKubeVersion, that.minKubeVersion)) {
            return false;
        }
        if (!Objects.equals(this.nativeApis, that.nativeApis)) {
            return false;
        }
        if (!Objects.equals(this.provider, that.provider)) {
            return false;
        }
        if (!Objects.equals(this.relatedImages, that.relatedImages)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.annotations, this.apiservicedefinitions, this.customresourcedefinitions, this.description, this.displayName, this.icon, this.installModes, this.keywords, this.links, this.maintainers, this.maturity, this.minKubeVersion, this.nativeApis, this.provider, this.relatedImages, this.version, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(String.valueOf(this.annotations) + ",");
        }
        if (this.apiservicedefinitions != null) {
            sb.append("apiservicedefinitions:");
            sb.append(String.valueOf(this.apiservicedefinitions) + ",");
        }
        if (this.customresourcedefinitions != null) {
            sb.append("customresourcedefinitions:");
            sb.append(String.valueOf(this.customresourcedefinitions) + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.displayName != null) {
            sb.append("displayName:");
            sb.append(this.displayName + ",");
        }
        if (this.icon != null && !this.icon.isEmpty()) {
            sb.append("icon:");
            sb.append(String.valueOf(this.icon) + ",");
        }
        if (this.installModes != null && !this.installModes.isEmpty()) {
            sb.append("installModes:");
            sb.append(String.valueOf(this.installModes) + ",");
        }
        if (this.keywords != null && !this.keywords.isEmpty()) {
            sb.append("keywords:");
            sb.append(String.valueOf(this.keywords) + ",");
        }
        if (this.links != null && !this.links.isEmpty()) {
            sb.append("links:");
            sb.append(String.valueOf(this.links) + ",");
        }
        if (this.maintainers != null && !this.maintainers.isEmpty()) {
            sb.append("maintainers:");
            sb.append(String.valueOf(this.maintainers) + ",");
        }
        if (this.maturity != null) {
            sb.append("maturity:");
            sb.append(this.maturity + ",");
        }
        if (this.minKubeVersion != null) {
            sb.append("minKubeVersion:");
            sb.append(this.minKubeVersion + ",");
        }
        if (this.nativeApis != null && !this.nativeApis.isEmpty()) {
            sb.append("nativeApis:");
            sb.append(String.valueOf(this.nativeApis) + ",");
        }
        if (this.provider != null) {
            sb.append("provider:");
            sb.append(String.valueOf(this.provider) + ",");
        }
        if (this.relatedImages != null && !this.relatedImages.isEmpty()) {
            sb.append("relatedImages:");
            sb.append(String.valueOf(this.relatedImages) + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ProviderNested<N>
    extends AppLinkFluent<ProviderNested<N>>
    implements Nested<N> {
        AppLinkBuilder builder;

        ProviderNested(AppLink item) {
            this.builder = new AppLinkBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSVDescriptionFluent.this.withProvider(this.builder.build());
        }

        public N endProvider() {
            return this.and();
        }
    }

    public class MaintainersNested<N>
    extends MaintainerFluent<MaintainersNested<N>>
    implements Nested<N> {
        MaintainerBuilder builder;
        int index;

        MaintainersNested(int index, Maintainer item) {
            this.index = index;
            this.builder = new MaintainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSVDescriptionFluent.this.setToMaintainers(this.index, this.builder.build());
        }

        public N endMaintainer() {
            return this.and();
        }
    }

    public class LinksNested<N>
    extends AppLinkFluent<LinksNested<N>>
    implements Nested<N> {
        AppLinkBuilder builder;
        int index;

        LinksNested(int index, AppLink item) {
            this.index = index;
            this.builder = new AppLinkBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSVDescriptionFluent.this.setToLinks(this.index, this.builder.build());
        }

        public N endLink() {
            return this.and();
        }
    }

    public class InstallModesNested<N>
    extends InstallModeFluent<InstallModesNested<N>>
    implements Nested<N> {
        InstallModeBuilder builder;
        int index;

        InstallModesNested(int index, InstallMode item) {
            this.index = index;
            this.builder = new InstallModeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSVDescriptionFluent.this.setToInstallModes(this.index, this.builder.build());
        }

        public N endInstallMode() {
            return this.and();
        }
    }

    public class IconNested<N>
    extends IconFluent<IconNested<N>>
    implements Nested<N> {
        IconBuilder builder;
        int index;

        IconNested(int index, Icon item) {
            this.index = index;
            this.builder = new IconBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSVDescriptionFluent.this.setToIcon(this.index, this.builder.build());
        }

        public N endIcon() {
            return this.and();
        }
    }

    public class CustomresourcedefinitionsNested<N>
    extends CustomResourceDefinitionsFluent<CustomresourcedefinitionsNested<N>>
    implements Nested<N> {
        CustomResourceDefinitionsBuilder builder;

        CustomresourcedefinitionsNested(CustomResourceDefinitions item) {
            this.builder = new CustomResourceDefinitionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSVDescriptionFluent.this.withCustomresourcedefinitions(this.builder.build());
        }

        public N endCustomresourcedefinitions() {
            return this.and();
        }
    }

    public class ApiservicedefinitionsNested<N>
    extends APIServiceDefinitionsFluent<ApiservicedefinitionsNested<N>>
    implements Nested<N> {
        APIServiceDefinitionsBuilder builder;

        ApiservicedefinitionsNested(APIServiceDefinitions item) {
            this.builder = new APIServiceDefinitionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSVDescriptionFluent.this.withApiservicedefinitions(this.builder.build());
        }

        public N endApiservicedefinitions() {
            return this.and();
        }
    }
}

