/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1alpha1.LoggingConfig;
import io.fabric8.openshift.api.model.operator.v1alpha1.LoggingConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.LoggingConfigFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.OperatorSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OperatorSpecFluent<A extends OperatorSpecFluent<A>>
extends BaseFluent<A> {
    private String imagePullPolicy;
    private String imagePullSpec;
    private LoggingConfigBuilder logging;
    private String managementState;
    private String version;
    private Map<String, Object> additionalProperties;

    public OperatorSpecFluent() {
    }

    public OperatorSpecFluent(OperatorSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OperatorSpec instance) {
        OperatorSpec operatorSpec = instance = instance != null ? instance : new OperatorSpec();
        if (instance != null) {
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withImagePullSpec(instance.getImagePullSpec());
            this.withLogging(instance.getLogging());
            this.withManagementState(instance.getManagementState());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)this;
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public String getImagePullSpec() {
        return this.imagePullSpec;
    }

    public A withImagePullSpec(String imagePullSpec) {
        this.imagePullSpec = imagePullSpec;
        return (A)this;
    }

    public boolean hasImagePullSpec() {
        return this.imagePullSpec != null;
    }

    public LoggingConfig buildLogging() {
        return this.logging != null ? this.logging.build() : null;
    }

    public A withLogging(LoggingConfig logging) {
        this._visitables.remove("logging");
        if (logging != null) {
            this.logging = new LoggingConfigBuilder(logging);
            this._visitables.get("logging").add(this.logging);
        } else {
            this.logging = null;
            this._visitables.get("logging").remove(this.logging);
        }
        return (A)this;
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public A withNewLogging(Long level, String vmodule) {
        return this.withLogging(new LoggingConfig(level, vmodule));
    }

    public LoggingNested<A> withNewLogging() {
        return new LoggingNested(null);
    }

    public LoggingNested<A> withNewLoggingLike(LoggingConfig item) {
        return new LoggingNested(item);
    }

    public LoggingNested<A> editLogging() {
        return this.withNewLoggingLike(Optional.ofNullable(this.buildLogging()).orElse(null));
    }

    public LoggingNested<A> editOrNewLogging() {
        return this.withNewLoggingLike(Optional.ofNullable(this.buildLogging()).orElse(new LoggingConfigBuilder().build()));
    }

    public LoggingNested<A> editOrNewLoggingLike(LoggingConfig item) {
        return this.withNewLoggingLike(Optional.ofNullable(this.buildLogging()).orElse(item));
    }

    public String getManagementState() {
        return this.managementState;
    }

    public A withManagementState(String managementState) {
        this.managementState = managementState;
        return (A)this;
    }

    public boolean hasManagementState() {
        return this.managementState != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OperatorSpecFluent that = (OperatorSpecFluent)o;
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSpec, that.imagePullSpec)) {
            return false;
        }
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        if (!Objects.equals(this.managementState, that.managementState)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.imagePullPolicy, this.imagePullSpec, this.logging, this.managementState, this.version, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.imagePullSpec != null) {
            sb.append("imagePullSpec:");
            sb.append(this.imagePullSpec + ",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(String.valueOf(this.logging) + ",");
        }
        if (this.managementState != null) {
            sb.append("managementState:");
            sb.append(this.managementState + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LoggingNested<N>
    extends LoggingConfigFluent<LoggingNested<N>>
    implements Nested<N> {
        LoggingConfigBuilder builder;

        LoggingNested(LoggingConfig item) {
            this.builder = new LoggingConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OperatorSpecFluent.this.withLogging(this.builder.build());
        }

        public N endLogging() {
            return this.and();
        }
    }
}

