/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition;
import io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder;
import io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionFluent;
import io.fabric8.openshift.api.model.operator.v1.AdditionalRoutingCapabilities;
import io.fabric8.openshift.api.model.operator.v1.AdditionalRoutingCapabilitiesBuilder;
import io.fabric8.openshift.api.model.operator.v1.AdditionalRoutingCapabilitiesFluent;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluent;
import io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition;
import io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder;
import io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionFluent;
import io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlows;
import io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsBuilder;
import io.fabric8.openshift.api.model.operator.v1.ExportNetworkFlowsFluent;
import io.fabric8.openshift.api.model.operator.v1.NetworkMigration;
import io.fabric8.openshift.api.model.operator.v1.NetworkMigrationBuilder;
import io.fabric8.openshift.api.model.operator.v1.NetworkMigrationFluent;
import io.fabric8.openshift.api.model.operator.v1.NetworkSpec;
import io.fabric8.openshift.api.model.operator.v1.ProxyConfig;
import io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.ProxyConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NetworkSpecFluent<A extends NetworkSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<AdditionalNetworkDefinitionBuilder> additionalNetworks = new ArrayList();
    private AdditionalRoutingCapabilitiesBuilder additionalRoutingCapabilities;
    private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList();
    private DefaultNetworkDefinitionBuilder defaultNetwork;
    private Boolean deployKubeProxy;
    private Boolean disableMultiNetwork;
    private Boolean disableNetworkDiagnostics;
    private ExportNetworkFlowsBuilder exportNetworkFlows;
    private ProxyConfigBuilder kubeProxyConfig;
    private String logLevel;
    private String managementState;
    private NetworkMigrationBuilder migration;
    private Object observedConfig;
    private String operatorLogLevel;
    private List<String> serviceNetwork = new ArrayList<String>();
    private Object unsupportedConfigOverrides;
    private Boolean useMultiNetworkPolicy;
    private Map<String, Object> additionalProperties;

    public NetworkSpecFluent() {
    }

    public NetworkSpecFluent(NetworkSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkSpec instance) {
        NetworkSpec networkSpec = instance = instance != null ? instance : new NetworkSpec();
        if (instance != null) {
            this.withAdditionalNetworks(instance.getAdditionalNetworks());
            this.withAdditionalRoutingCapabilities(instance.getAdditionalRoutingCapabilities());
            this.withClusterNetwork(instance.getClusterNetwork());
            this.withDefaultNetwork(instance.getDefaultNetwork());
            this.withDeployKubeProxy(instance.getDeployKubeProxy());
            this.withDisableMultiNetwork(instance.getDisableMultiNetwork());
            this.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics());
            this.withExportNetworkFlows(instance.getExportNetworkFlows());
            this.withKubeProxyConfig(instance.getKubeProxyConfig());
            this.withLogLevel(instance.getLogLevel());
            this.withManagementState(instance.getManagementState());
            this.withMigration(instance.getMigration());
            this.withObservedConfig(instance.getObservedConfig());
            this.withOperatorLogLevel(instance.getOperatorLogLevel());
            this.withServiceNetwork(instance.getServiceNetwork());
            this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
            this.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdditionalNetworks(int index, AdditionalNetworkDefinition item) {
        if (this.additionalNetworks == null) {
            this.additionalNetworks = new ArrayList();
        }
        AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
        if (index < 0 || index >= this.additionalNetworks.size()) {
            this._visitables.get("additionalNetworks").add(builder);
            this.additionalNetworks.add(builder);
        } else {
            this._visitables.get("additionalNetworks").add(builder);
            this.additionalNetworks.add(index, builder);
        }
        return (A)this;
    }

    public A setToAdditionalNetworks(int index, AdditionalNetworkDefinition item) {
        if (this.additionalNetworks == null) {
            this.additionalNetworks = new ArrayList();
        }
        AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
        if (index < 0 || index >= this.additionalNetworks.size()) {
            this._visitables.get("additionalNetworks").add(builder);
            this.additionalNetworks.add(builder);
        } else {
            this._visitables.get("additionalNetworks").add(builder);
            this.additionalNetworks.set(index, builder);
        }
        return (A)this;
    }

    public A addToAdditionalNetworks(AdditionalNetworkDefinition ... items) {
        if (this.additionalNetworks == null) {
            this.additionalNetworks = new ArrayList();
        }
        for (AdditionalNetworkDefinition item : items) {
            AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
            this._visitables.get("additionalNetworks").add(builder);
            this.additionalNetworks.add(builder);
        }
        return (A)this;
    }

    public A addAllToAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
        if (this.additionalNetworks == null) {
            this.additionalNetworks = new ArrayList();
        }
        for (AdditionalNetworkDefinition item : items) {
            AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
            this._visitables.get("additionalNetworks").add(builder);
            this.additionalNetworks.add(builder);
        }
        return (A)this;
    }

    public A removeFromAdditionalNetworks(AdditionalNetworkDefinition ... items) {
        if (this.additionalNetworks == null) {
            return (A)this;
        }
        for (AdditionalNetworkDefinition item : items) {
            AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
            this._visitables.get("additionalNetworks").remove(builder);
            this.additionalNetworks.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
        if (this.additionalNetworks == null) {
            return (A)this;
        }
        for (AdditionalNetworkDefinition item : items) {
            AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
            this._visitables.get("additionalNetworks").remove(builder);
            this.additionalNetworks.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAdditionalNetworks(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        if (this.additionalNetworks == null) {
            return (A)this;
        }
        Iterator<AdditionalNetworkDefinitionBuilder> each = this.additionalNetworks.iterator();
        Object visitables = this._visitables.get("additionalNetworks");
        while (each.hasNext()) {
            AdditionalNetworkDefinitionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AdditionalNetworkDefinition> buildAdditionalNetworks() {
        return this.additionalNetworks != null ? NetworkSpecFluent.build(this.additionalNetworks) : null;
    }

    public AdditionalNetworkDefinition buildAdditionalNetwork(int index) {
        return this.additionalNetworks.get(index).build();
    }

    public AdditionalNetworkDefinition buildFirstAdditionalNetwork() {
        return this.additionalNetworks.get(0).build();
    }

    public AdditionalNetworkDefinition buildLastAdditionalNetwork() {
        return this.additionalNetworks.get(this.additionalNetworks.size() - 1).build();
    }

    public AdditionalNetworkDefinition buildMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        for (AdditionalNetworkDefinitionBuilder item : this.additionalNetworks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        for (AdditionalNetworkDefinitionBuilder item : this.additionalNetworks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalNetworks(List<AdditionalNetworkDefinition> additionalNetworks) {
        if (this.additionalNetworks != null) {
            this._visitables.get("additionalNetworks").clear();
        }
        if (additionalNetworks != null) {
            this.additionalNetworks = new ArrayList();
            for (AdditionalNetworkDefinition item : additionalNetworks) {
                this.addToAdditionalNetworks(item);
            }
        } else {
            this.additionalNetworks = null;
        }
        return (A)this;
    }

    public A withAdditionalNetworks(AdditionalNetworkDefinition ... additionalNetworks) {
        if (this.additionalNetworks != null) {
            this.additionalNetworks.clear();
            this._visitables.remove("additionalNetworks");
        }
        if (additionalNetworks != null) {
            for (AdditionalNetworkDefinition item : additionalNetworks) {
                this.addToAdditionalNetworks(item);
            }
        }
        return (A)this;
    }

    public boolean hasAdditionalNetworks() {
        return this.additionalNetworks != null && !this.additionalNetworks.isEmpty();
    }

    public AdditionalNetworksNested<A> addNewAdditionalNetwork() {
        return new AdditionalNetworksNested(-1, null);
    }

    public AdditionalNetworksNested<A> addNewAdditionalNetworkLike(AdditionalNetworkDefinition item) {
        return new AdditionalNetworksNested(-1, item);
    }

    public AdditionalNetworksNested<A> setNewAdditionalNetworkLike(int index, AdditionalNetworkDefinition item) {
        return new AdditionalNetworksNested(index, item);
    }

    public AdditionalNetworksNested<A> editAdditionalNetwork(int index) {
        if (this.additionalNetworks.size() <= index) {
            throw new RuntimeException("Can't edit additionalNetworks. Index exceeds size.");
        }
        return this.setNewAdditionalNetworkLike(index, this.buildAdditionalNetwork(index));
    }

    public AdditionalNetworksNested<A> editFirstAdditionalNetwork() {
        if (this.additionalNetworks.size() == 0) {
            throw new RuntimeException("Can't edit first additionalNetworks. The list is empty.");
        }
        return this.setNewAdditionalNetworkLike(0, this.buildAdditionalNetwork(0));
    }

    public AdditionalNetworksNested<A> editLastAdditionalNetwork() {
        int index = this.additionalNetworks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last additionalNetworks. The list is empty.");
        }
        return this.setNewAdditionalNetworkLike(index, this.buildAdditionalNetwork(index));
    }

    public AdditionalNetworksNested<A> editMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.additionalNetworks.size(); ++i) {
            if (!predicate.test(this.additionalNetworks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching additionalNetworks. No match found.");
        }
        return this.setNewAdditionalNetworkLike(index, this.buildAdditionalNetwork(index));
    }

    public AdditionalRoutingCapabilities buildAdditionalRoutingCapabilities() {
        return this.additionalRoutingCapabilities != null ? this.additionalRoutingCapabilities.build() : null;
    }

    public A withAdditionalRoutingCapabilities(AdditionalRoutingCapabilities additionalRoutingCapabilities) {
        this._visitables.remove("additionalRoutingCapabilities");
        if (additionalRoutingCapabilities != null) {
            this.additionalRoutingCapabilities = new AdditionalRoutingCapabilitiesBuilder(additionalRoutingCapabilities);
            this._visitables.get("additionalRoutingCapabilities").add(this.additionalRoutingCapabilities);
        } else {
            this.additionalRoutingCapabilities = null;
            this._visitables.get("additionalRoutingCapabilities").remove(this.additionalRoutingCapabilities);
        }
        return (A)this;
    }

    public boolean hasAdditionalRoutingCapabilities() {
        return this.additionalRoutingCapabilities != null;
    }

    public AdditionalRoutingCapabilitiesNested<A> withNewAdditionalRoutingCapabilities() {
        return new AdditionalRoutingCapabilitiesNested(null);
    }

    public AdditionalRoutingCapabilitiesNested<A> withNewAdditionalRoutingCapabilitiesLike(AdditionalRoutingCapabilities item) {
        return new AdditionalRoutingCapabilitiesNested(item);
    }

    public AdditionalRoutingCapabilitiesNested<A> editAdditionalRoutingCapabilities() {
        return this.withNewAdditionalRoutingCapabilitiesLike(Optional.ofNullable(this.buildAdditionalRoutingCapabilities()).orElse(null));
    }

    public AdditionalRoutingCapabilitiesNested<A> editOrNewAdditionalRoutingCapabilities() {
        return this.withNewAdditionalRoutingCapabilitiesLike(Optional.ofNullable(this.buildAdditionalRoutingCapabilities()).orElse(new AdditionalRoutingCapabilitiesBuilder().build()));
    }

    public AdditionalRoutingCapabilitiesNested<A> editOrNewAdditionalRoutingCapabilitiesLike(AdditionalRoutingCapabilities item) {
        return this.withNewAdditionalRoutingCapabilitiesLike(Optional.ofNullable(this.buildAdditionalRoutingCapabilities()).orElse(item));
    }

    public A addToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        } else {
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(index, builder);
        }
        return (A)this;
    }

    public A setToClusterNetwork(int index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        } else {
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.set(index, builder);
        }
        return (A)this;
    }

    public A addToClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    public A removeFromClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").remove(builder);
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetwork").remove(builder);
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.clusterNetwork.iterator();
        Object visitables = this._visitables.get("clusterNetwork");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ClusterNetworkEntry> buildClusterNetwork() {
        return this.clusterNetwork != null ? NetworkSpecFluent.build(this.clusterNetwork) : null;
    }

    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetwork.get(index).build();
    }

    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetwork.get(0).build();
    }

    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetwork.get(this.clusterNetwork.size() - 1).build();
    }

    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
        if (this.clusterNetwork != null) {
            this._visitables.get("clusterNetwork").clear();
        }
        if (clusterNetwork != null) {
            this.clusterNetwork = new ArrayList();
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        } else {
            this.clusterNetwork = null;
        }
        return (A)this;
    }

    public A withClusterNetwork(ClusterNetworkEntry ... clusterNetwork) {
        if (this.clusterNetwork != null) {
            this.clusterNetwork.clear();
            this._visitables.remove("clusterNetwork");
        }
        if (clusterNetwork != null) {
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        }
        return (A)this;
    }

    public boolean hasClusterNetwork() {
        return this.clusterNetwork != null && !this.clusterNetwork.isEmpty();
    }

    public A addNewClusterNetwork(String cidr, Long hostPrefix) {
        return this.addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
    }

    public ClusterNetworkNested<A> addNewClusterNetwork() {
        return new ClusterNetworkNested(-1, null);
    }

    public ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworkNested(-1, item);
    }

    public ClusterNetworkNested<A> setNewClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new ClusterNetworkNested(index, item);
    }

    public ClusterNetworkNested<A> editClusterNetwork(int index) {
        if (this.clusterNetwork.size() <= index) {
            throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public ClusterNetworkNested<A> editFirstClusterNetwork() {
        if (this.clusterNetwork.size() == 0) {
            throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(0, this.buildClusterNetwork(0));
    }

    public ClusterNetworkNested<A> editLastClusterNetwork() {
        int index = this.clusterNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterNetwork.size(); ++i) {
            if (!predicate.test(this.clusterNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    public DefaultNetworkDefinition buildDefaultNetwork() {
        return this.defaultNetwork != null ? this.defaultNetwork.build() : null;
    }

    public A withDefaultNetwork(DefaultNetworkDefinition defaultNetwork) {
        this._visitables.remove("defaultNetwork");
        if (defaultNetwork != null) {
            this.defaultNetwork = new DefaultNetworkDefinitionBuilder(defaultNetwork);
            this._visitables.get("defaultNetwork").add(this.defaultNetwork);
        } else {
            this.defaultNetwork = null;
            this._visitables.get("defaultNetwork").remove(this.defaultNetwork);
        }
        return (A)this;
    }

    public boolean hasDefaultNetwork() {
        return this.defaultNetwork != null;
    }

    public DefaultNetworkNested<A> withNewDefaultNetwork() {
        return new DefaultNetworkNested(null);
    }

    public DefaultNetworkNested<A> withNewDefaultNetworkLike(DefaultNetworkDefinition item) {
        return new DefaultNetworkNested(item);
    }

    public DefaultNetworkNested<A> editDefaultNetwork() {
        return this.withNewDefaultNetworkLike(Optional.ofNullable(this.buildDefaultNetwork()).orElse(null));
    }

    public DefaultNetworkNested<A> editOrNewDefaultNetwork() {
        return this.withNewDefaultNetworkLike(Optional.ofNullable(this.buildDefaultNetwork()).orElse(new DefaultNetworkDefinitionBuilder().build()));
    }

    public DefaultNetworkNested<A> editOrNewDefaultNetworkLike(DefaultNetworkDefinition item) {
        return this.withNewDefaultNetworkLike(Optional.ofNullable(this.buildDefaultNetwork()).orElse(item));
    }

    public Boolean getDeployKubeProxy() {
        return this.deployKubeProxy;
    }

    public A withDeployKubeProxy(Boolean deployKubeProxy) {
        this.deployKubeProxy = deployKubeProxy;
        return (A)this;
    }

    public boolean hasDeployKubeProxy() {
        return this.deployKubeProxy != null;
    }

    public Boolean getDisableMultiNetwork() {
        return this.disableMultiNetwork;
    }

    public A withDisableMultiNetwork(Boolean disableMultiNetwork) {
        this.disableMultiNetwork = disableMultiNetwork;
        return (A)this;
    }

    public boolean hasDisableMultiNetwork() {
        return this.disableMultiNetwork != null;
    }

    public Boolean getDisableNetworkDiagnostics() {
        return this.disableNetworkDiagnostics;
    }

    public A withDisableNetworkDiagnostics(Boolean disableNetworkDiagnostics) {
        this.disableNetworkDiagnostics = disableNetworkDiagnostics;
        return (A)this;
    }

    public boolean hasDisableNetworkDiagnostics() {
        return this.disableNetworkDiagnostics != null;
    }

    public ExportNetworkFlows buildExportNetworkFlows() {
        return this.exportNetworkFlows != null ? this.exportNetworkFlows.build() : null;
    }

    public A withExportNetworkFlows(ExportNetworkFlows exportNetworkFlows) {
        this._visitables.remove("exportNetworkFlows");
        if (exportNetworkFlows != null) {
            this.exportNetworkFlows = new ExportNetworkFlowsBuilder(exportNetworkFlows);
            this._visitables.get("exportNetworkFlows").add(this.exportNetworkFlows);
        } else {
            this.exportNetworkFlows = null;
            this._visitables.get("exportNetworkFlows").remove(this.exportNetworkFlows);
        }
        return (A)this;
    }

    public boolean hasExportNetworkFlows() {
        return this.exportNetworkFlows != null;
    }

    public ExportNetworkFlowsNested<A> withNewExportNetworkFlows() {
        return new ExportNetworkFlowsNested(null);
    }

    public ExportNetworkFlowsNested<A> withNewExportNetworkFlowsLike(ExportNetworkFlows item) {
        return new ExportNetworkFlowsNested(item);
    }

    public ExportNetworkFlowsNested<A> editExportNetworkFlows() {
        return this.withNewExportNetworkFlowsLike(Optional.ofNullable(this.buildExportNetworkFlows()).orElse(null));
    }

    public ExportNetworkFlowsNested<A> editOrNewExportNetworkFlows() {
        return this.withNewExportNetworkFlowsLike(Optional.ofNullable(this.buildExportNetworkFlows()).orElse(new ExportNetworkFlowsBuilder().build()));
    }

    public ExportNetworkFlowsNested<A> editOrNewExportNetworkFlowsLike(ExportNetworkFlows item) {
        return this.withNewExportNetworkFlowsLike(Optional.ofNullable(this.buildExportNetworkFlows()).orElse(item));
    }

    public ProxyConfig buildKubeProxyConfig() {
        return this.kubeProxyConfig != null ? this.kubeProxyConfig.build() : null;
    }

    public A withKubeProxyConfig(ProxyConfig kubeProxyConfig) {
        this._visitables.remove("kubeProxyConfig");
        if (kubeProxyConfig != null) {
            this.kubeProxyConfig = new ProxyConfigBuilder(kubeProxyConfig);
            this._visitables.get("kubeProxyConfig").add(this.kubeProxyConfig);
        } else {
            this.kubeProxyConfig = null;
            this._visitables.get("kubeProxyConfig").remove(this.kubeProxyConfig);
        }
        return (A)this;
    }

    public boolean hasKubeProxyConfig() {
        return this.kubeProxyConfig != null;
    }

    public KubeProxyConfigNested<A> withNewKubeProxyConfig() {
        return new KubeProxyConfigNested(null);
    }

    public KubeProxyConfigNested<A> withNewKubeProxyConfigLike(ProxyConfig item) {
        return new KubeProxyConfigNested(item);
    }

    public KubeProxyConfigNested<A> editKubeProxyConfig() {
        return this.withNewKubeProxyConfigLike(Optional.ofNullable(this.buildKubeProxyConfig()).orElse(null));
    }

    public KubeProxyConfigNested<A> editOrNewKubeProxyConfig() {
        return this.withNewKubeProxyConfigLike(Optional.ofNullable(this.buildKubeProxyConfig()).orElse(new ProxyConfigBuilder().build()));
    }

    public KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(ProxyConfig item) {
        return this.withNewKubeProxyConfigLike(Optional.ofNullable(this.buildKubeProxyConfig()).orElse(item));
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public String getManagementState() {
        return this.managementState;
    }

    public A withManagementState(String managementState) {
        this.managementState = managementState;
        return (A)this;
    }

    public boolean hasManagementState() {
        return this.managementState != null;
    }

    public NetworkMigration buildMigration() {
        return this.migration != null ? this.migration.build() : null;
    }

    public A withMigration(NetworkMigration migration) {
        this._visitables.remove("migration");
        if (migration != null) {
            this.migration = new NetworkMigrationBuilder(migration);
            this._visitables.get("migration").add(this.migration);
        } else {
            this.migration = null;
            this._visitables.get("migration").remove(this.migration);
        }
        return (A)this;
    }

    public boolean hasMigration() {
        return this.migration != null;
    }

    public MigrationNested<A> withNewMigration() {
        return new MigrationNested(null);
    }

    public MigrationNested<A> withNewMigrationLike(NetworkMigration item) {
        return new MigrationNested(item);
    }

    public MigrationNested<A> editMigration() {
        return this.withNewMigrationLike(Optional.ofNullable(this.buildMigration()).orElse(null));
    }

    public MigrationNested<A> editOrNewMigration() {
        return this.withNewMigrationLike(Optional.ofNullable(this.buildMigration()).orElse(new NetworkMigrationBuilder().build()));
    }

    public MigrationNested<A> editOrNewMigrationLike(NetworkMigration item) {
        return this.withNewMigrationLike(Optional.ofNullable(this.buildMigration()).orElse(item));
    }

    public Object getObservedConfig() {
        return this.observedConfig;
    }

    public A withObservedConfig(Object observedConfig) {
        this.observedConfig = observedConfig;
        return (A)this;
    }

    public boolean hasObservedConfig() {
        return this.observedConfig != null;
    }

    public String getOperatorLogLevel() {
        return this.operatorLogLevel;
    }

    public A withOperatorLogLevel(String operatorLogLevel) {
        this.operatorLogLevel = operatorLogLevel;
        return (A)this;
    }

    public boolean hasOperatorLogLevel() {
        return this.operatorLogLevel != null;
    }

    public A addToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.add(index, item);
        return (A)this;
    }

    public A setToServiceNetwork(int index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.set(index, item);
        return (A)this;
    }

    public A addToServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    public A addAllToServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    public A removeFromServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            return (A)this;
        }
        for (String item : items) {
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            return (A)this;
        }
        for (String item : items) {
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    public List<String> getServiceNetwork() {
        return this.serviceNetwork;
    }

    public String getServiceNetwork(int index) {
        return this.serviceNetwork.get(index);
    }

    public String getFirstServiceNetwork() {
        return this.serviceNetwork.get(0);
    }

    public String getLastServiceNetwork() {
        return this.serviceNetwork.get(this.serviceNetwork.size() - 1);
    }

    public String getMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceNetwork(List<String> serviceNetwork) {
        if (serviceNetwork != null) {
            this.serviceNetwork = new ArrayList<String>();
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        } else {
            this.serviceNetwork = null;
        }
        return (A)this;
    }

    public A withServiceNetwork(String ... serviceNetwork) {
        if (this.serviceNetwork != null) {
            this.serviceNetwork.clear();
            this._visitables.remove("serviceNetwork");
        }
        if (serviceNetwork != null) {
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceNetwork() {
        return this.serviceNetwork != null && !this.serviceNetwork.isEmpty();
    }

    public Object getUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides;
    }

    public A withUnsupportedConfigOverrides(Object unsupportedConfigOverrides) {
        this.unsupportedConfigOverrides = unsupportedConfigOverrides;
        return (A)this;
    }

    public boolean hasUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides != null;
    }

    public Boolean getUseMultiNetworkPolicy() {
        return this.useMultiNetworkPolicy;
    }

    public A withUseMultiNetworkPolicy(Boolean useMultiNetworkPolicy) {
        this.useMultiNetworkPolicy = useMultiNetworkPolicy;
        return (A)this;
    }

    public boolean hasUseMultiNetworkPolicy() {
        return this.useMultiNetworkPolicy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSpecFluent that = (NetworkSpecFluent)o;
        if (!Objects.equals(this.additionalNetworks, that.additionalNetworks)) {
            return false;
        }
        if (!Objects.equals(this.additionalRoutingCapabilities, that.additionalRoutingCapabilities)) {
            return false;
        }
        if (!Objects.equals(this.clusterNetwork, that.clusterNetwork)) {
            return false;
        }
        if (!Objects.equals(this.defaultNetwork, that.defaultNetwork)) {
            return false;
        }
        if (!Objects.equals(this.deployKubeProxy, that.deployKubeProxy)) {
            return false;
        }
        if (!Objects.equals(this.disableMultiNetwork, that.disableMultiNetwork)) {
            return false;
        }
        if (!Objects.equals(this.disableNetworkDiagnostics, that.disableNetworkDiagnostics)) {
            return false;
        }
        if (!Objects.equals(this.exportNetworkFlows, that.exportNetworkFlows)) {
            return false;
        }
        if (!Objects.equals(this.kubeProxyConfig, that.kubeProxyConfig)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.managementState, that.managementState)) {
            return false;
        }
        if (!Objects.equals(this.migration, that.migration)) {
            return false;
        }
        if (!Objects.equals(this.observedConfig, that.observedConfig)) {
            return false;
        }
        if (!Objects.equals(this.operatorLogLevel, that.operatorLogLevel)) {
            return false;
        }
        if (!Objects.equals(this.serviceNetwork, that.serviceNetwork)) {
            return false;
        }
        if (!Objects.equals(this.unsupportedConfigOverrides, that.unsupportedConfigOverrides)) {
            return false;
        }
        if (!Objects.equals(this.useMultiNetworkPolicy, that.useMultiNetworkPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalNetworks, this.additionalRoutingCapabilities, this.clusterNetwork, this.defaultNetwork, this.deployKubeProxy, this.disableMultiNetwork, this.disableNetworkDiagnostics, this.exportNetworkFlows, this.kubeProxyConfig, this.logLevel, this.managementState, this.migration, this.observedConfig, this.operatorLogLevel, this.serviceNetwork, this.unsupportedConfigOverrides, this.useMultiNetworkPolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalNetworks != null && !this.additionalNetworks.isEmpty()) {
            sb.append("additionalNetworks:");
            sb.append(String.valueOf(this.additionalNetworks) + ",");
        }
        if (this.additionalRoutingCapabilities != null) {
            sb.append("additionalRoutingCapabilities:");
            sb.append(String.valueOf(this.additionalRoutingCapabilities) + ",");
        }
        if (this.clusterNetwork != null && !this.clusterNetwork.isEmpty()) {
            sb.append("clusterNetwork:");
            sb.append(String.valueOf(this.clusterNetwork) + ",");
        }
        if (this.defaultNetwork != null) {
            sb.append("defaultNetwork:");
            sb.append(String.valueOf(this.defaultNetwork) + ",");
        }
        if (this.deployKubeProxy != null) {
            sb.append("deployKubeProxy:");
            sb.append(this.deployKubeProxy + ",");
        }
        if (this.disableMultiNetwork != null) {
            sb.append("disableMultiNetwork:");
            sb.append(this.disableMultiNetwork + ",");
        }
        if (this.disableNetworkDiagnostics != null) {
            sb.append("disableNetworkDiagnostics:");
            sb.append(this.disableNetworkDiagnostics + ",");
        }
        if (this.exportNetworkFlows != null) {
            sb.append("exportNetworkFlows:");
            sb.append(String.valueOf(this.exportNetworkFlows) + ",");
        }
        if (this.kubeProxyConfig != null) {
            sb.append("kubeProxyConfig:");
            sb.append(String.valueOf(this.kubeProxyConfig) + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.managementState != null) {
            sb.append("managementState:");
            sb.append(this.managementState + ",");
        }
        if (this.migration != null) {
            sb.append("migration:");
            sb.append(String.valueOf(this.migration) + ",");
        }
        if (this.observedConfig != null) {
            sb.append("observedConfig:");
            sb.append(String.valueOf(this.observedConfig) + ",");
        }
        if (this.operatorLogLevel != null) {
            sb.append("operatorLogLevel:");
            sb.append(this.operatorLogLevel + ",");
        }
        if (this.serviceNetwork != null && !this.serviceNetwork.isEmpty()) {
            sb.append("serviceNetwork:");
            sb.append(String.valueOf(this.serviceNetwork) + ",");
        }
        if (this.unsupportedConfigOverrides != null) {
            sb.append("unsupportedConfigOverrides:");
            sb.append(String.valueOf(this.unsupportedConfigOverrides) + ",");
        }
        if (this.useMultiNetworkPolicy != null) {
            sb.append("useMultiNetworkPolicy:");
            sb.append(this.useMultiNetworkPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDeployKubeProxy() {
        return this.withDeployKubeProxy(true);
    }

    public A withDisableMultiNetwork() {
        return this.withDisableMultiNetwork(true);
    }

    public A withDisableNetworkDiagnostics() {
        return this.withDisableNetworkDiagnostics(true);
    }

    public A withUseMultiNetworkPolicy() {
        return this.withUseMultiNetworkPolicy(true);
    }

    public class MigrationNested<N>
    extends NetworkMigrationFluent<MigrationNested<N>>
    implements Nested<N> {
        NetworkMigrationBuilder builder;

        MigrationNested(NetworkMigration item) {
            this.builder = new NetworkMigrationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.withMigration(this.builder.build());
        }

        public N endMigration() {
            return this.and();
        }
    }

    public class KubeProxyConfigNested<N>
    extends ProxyConfigFluent<KubeProxyConfigNested<N>>
    implements Nested<N> {
        ProxyConfigBuilder builder;

        KubeProxyConfigNested(ProxyConfig item) {
            this.builder = new ProxyConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.withKubeProxyConfig(this.builder.build());
        }

        public N endKubeProxyConfig() {
            return this.and();
        }
    }

    public class ExportNetworkFlowsNested<N>
    extends ExportNetworkFlowsFluent<ExportNetworkFlowsNested<N>>
    implements Nested<N> {
        ExportNetworkFlowsBuilder builder;

        ExportNetworkFlowsNested(ExportNetworkFlows item) {
            this.builder = new ExportNetworkFlowsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.withExportNetworkFlows(this.builder.build());
        }

        public N endExportNetworkFlows() {
            return this.and();
        }
    }

    public class DefaultNetworkNested<N>
    extends DefaultNetworkDefinitionFluent<DefaultNetworkNested<N>>
    implements Nested<N> {
        DefaultNetworkDefinitionBuilder builder;

        DefaultNetworkNested(DefaultNetworkDefinition item) {
            this.builder = new DefaultNetworkDefinitionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.withDefaultNetwork(this.builder.build());
        }

        public N endDefaultNetwork() {
            return this.and();
        }
    }

    public class ClusterNetworkNested<N>
    extends ClusterNetworkEntryFluent<ClusterNetworkNested<N>>
    implements Nested<N> {
        ClusterNetworkEntryBuilder builder;
        int index;

        ClusterNetworkNested(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.setToClusterNetwork(this.index, this.builder.build());
        }

        public N endClusterNetwork() {
            return this.and();
        }
    }

    public class AdditionalRoutingCapabilitiesNested<N>
    extends AdditionalRoutingCapabilitiesFluent<AdditionalRoutingCapabilitiesNested<N>>
    implements Nested<N> {
        AdditionalRoutingCapabilitiesBuilder builder;

        AdditionalRoutingCapabilitiesNested(AdditionalRoutingCapabilities item) {
            this.builder = new AdditionalRoutingCapabilitiesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.withAdditionalRoutingCapabilities(this.builder.build());
        }

        public N endAdditionalRoutingCapabilities() {
            return this.and();
        }
    }

    public class AdditionalNetworksNested<N>
    extends AdditionalNetworkDefinitionFluent<AdditionalNetworksNested<N>>
    implements Nested<N> {
        AdditionalNetworkDefinitionBuilder builder;
        int index;

        AdditionalNetworksNested(int index, AdditionalNetworkDefinition item) {
            this.index = index;
            this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.setToAdditionalNetworks(this.index, this.builder.build());
        }

        public N endAdditionalNetwork() {
            return this.and();
        }
    }
}

