/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.PushoverConfig;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelectorBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.SecretKeySelectorFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PushoverConfigFluent<A extends PushoverConfigFluent<A>>
extends BaseFluent<A> {
    private String device;
    private String expire;
    private Boolean html;
    private HTTPConfigBuilder httpConfig;
    private String message;
    private String priority;
    private String retry;
    private Boolean sendResolved;
    private String sound;
    private String title;
    private SecretKeySelectorBuilder token;
    private String tokenFile;
    private String ttl;
    private String url;
    private String urlTitle;
    private SecretKeySelectorBuilder userKey;
    private String userKeyFile;
    private Map<String, Object> additionalProperties;

    public PushoverConfigFluent() {
    }

    public PushoverConfigFluent(PushoverConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PushoverConfig instance) {
        PushoverConfig pushoverConfig = instance = instance != null ? instance : new PushoverConfig();
        if (instance != null) {
            this.withDevice(instance.getDevice());
            this.withExpire(instance.getExpire());
            this.withHtml(instance.getHtml());
            this.withHttpConfig(instance.getHttpConfig());
            this.withMessage(instance.getMessage());
            this.withPriority(instance.getPriority());
            this.withRetry(instance.getRetry());
            this.withSendResolved(instance.getSendResolved());
            this.withSound(instance.getSound());
            this.withTitle(instance.getTitle());
            this.withToken(instance.getToken());
            this.withTokenFile(instance.getTokenFile());
            this.withTtl(instance.getTtl());
            this.withUrl(instance.getUrl());
            this.withUrlTitle(instance.getUrlTitle());
            this.withUserKey(instance.getUserKey());
            this.withUserKeyFile(instance.getUserKeyFile());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDevice() {
        return this.device;
    }

    public A withDevice(String device) {
        this.device = device;
        return (A)this;
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public String getExpire() {
        return this.expire;
    }

    public A withExpire(String expire) {
        this.expire = expire;
        return (A)this;
    }

    public boolean hasExpire() {
        return this.expire != null;
    }

    public Boolean getHtml() {
        return this.html;
    }

    public A withHtml(Boolean html) {
        this.html = html;
        return (A)this;
    }

    public boolean hasHtml() {
        return this.html != null;
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove("httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get("httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get("httpConfig").remove(this.httpConfig);
        }
        return (A)this;
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getPriority() {
        return this.priority;
    }

    public A withPriority(String priority) {
        this.priority = priority;
        return (A)this;
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public String getRetry() {
        return this.retry;
    }

    public A withRetry(String retry) {
        this.retry = retry;
        return (A)this;
    }

    public boolean hasRetry() {
        return this.retry != null;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)this;
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public String getSound() {
        return this.sound;
    }

    public A withSound(String sound) {
        this.sound = sound;
        return (A)this;
    }

    public boolean hasSound() {
        return this.sound != null;
    }

    public String getTitle() {
        return this.title;
    }

    public A withTitle(String title) {
        this.title = title;
        return (A)this;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public SecretKeySelector buildToken() {
        return this.token != null ? this.token.build() : null;
    }

    public A withToken(SecretKeySelector token) {
        this._visitables.remove("token");
        if (token != null) {
            this.token = new SecretKeySelectorBuilder(token);
            this._visitables.get("token").add(this.token);
        } else {
            this.token = null;
            this._visitables.get("token").remove(this.token);
        }
        return (A)this;
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public A withNewToken(String key, String name) {
        return this.withToken(new SecretKeySelector(key, name));
    }

    public TokenNested<A> withNewToken() {
        return new TokenNested(null);
    }

    public TokenNested<A> withNewTokenLike(SecretKeySelector item) {
        return new TokenNested(item);
    }

    public TokenNested<A> editToken() {
        return this.withNewTokenLike(Optional.ofNullable(this.buildToken()).orElse(null));
    }

    public TokenNested<A> editOrNewToken() {
        return this.withNewTokenLike(Optional.ofNullable(this.buildToken()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public TokenNested<A> editOrNewTokenLike(SecretKeySelector item) {
        return this.withNewTokenLike(Optional.ofNullable(this.buildToken()).orElse(item));
    }

    public String getTokenFile() {
        return this.tokenFile;
    }

    public A withTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
        return (A)this;
    }

    public boolean hasTokenFile() {
        return this.tokenFile != null;
    }

    public String getTtl() {
        return this.ttl;
    }

    public A withTtl(String ttl) {
        this.ttl = ttl;
        return (A)this;
    }

    public boolean hasTtl() {
        return this.ttl != null;
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public String getUrlTitle() {
        return this.urlTitle;
    }

    public A withUrlTitle(String urlTitle) {
        this.urlTitle = urlTitle;
        return (A)this;
    }

    public boolean hasUrlTitle() {
        return this.urlTitle != null;
    }

    public SecretKeySelector buildUserKey() {
        return this.userKey != null ? this.userKey.build() : null;
    }

    public A withUserKey(SecretKeySelector userKey) {
        this._visitables.remove("userKey");
        if (userKey != null) {
            this.userKey = new SecretKeySelectorBuilder(userKey);
            this._visitables.get("userKey").add(this.userKey);
        } else {
            this.userKey = null;
            this._visitables.get("userKey").remove(this.userKey);
        }
        return (A)this;
    }

    public boolean hasUserKey() {
        return this.userKey != null;
    }

    public A withNewUserKey(String key, String name) {
        return this.withUserKey(new SecretKeySelector(key, name));
    }

    public UserKeyNested<A> withNewUserKey() {
        return new UserKeyNested(null);
    }

    public UserKeyNested<A> withNewUserKeyLike(SecretKeySelector item) {
        return new UserKeyNested(item);
    }

    public UserKeyNested<A> editUserKey() {
        return this.withNewUserKeyLike(Optional.ofNullable(this.buildUserKey()).orElse(null));
    }

    public UserKeyNested<A> editOrNewUserKey() {
        return this.withNewUserKeyLike(Optional.ofNullable(this.buildUserKey()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public UserKeyNested<A> editOrNewUserKeyLike(SecretKeySelector item) {
        return this.withNewUserKeyLike(Optional.ofNullable(this.buildUserKey()).orElse(item));
    }

    public String getUserKeyFile() {
        return this.userKeyFile;
    }

    public A withUserKeyFile(String userKeyFile) {
        this.userKeyFile = userKeyFile;
        return (A)this;
    }

    public boolean hasUserKeyFile() {
        return this.userKeyFile != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PushoverConfigFluent that = (PushoverConfigFluent)o;
        if (!Objects.equals(this.device, that.device)) {
            return false;
        }
        if (!Objects.equals(this.expire, that.expire)) {
            return false;
        }
        if (!Objects.equals(this.html, that.html)) {
            return false;
        }
        if (!Objects.equals(this.httpConfig, that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.retry, that.retry)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.sound, that.sound)) {
            return false;
        }
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        if (!Objects.equals(this.token, that.token)) {
            return false;
        }
        if (!Objects.equals(this.tokenFile, that.tokenFile)) {
            return false;
        }
        if (!Objects.equals(this.ttl, that.ttl)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.urlTitle, that.urlTitle)) {
            return false;
        }
        if (!Objects.equals(this.userKey, that.userKey)) {
            return false;
        }
        if (!Objects.equals(this.userKeyFile, that.userKeyFile)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.device, this.expire, this.html, this.httpConfig, this.message, this.priority, this.retry, this.sendResolved, this.sound, this.title, this.token, this.tokenFile, this.ttl, this.url, this.urlTitle, this.userKey, this.userKeyFile, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.device != null) {
            sb.append("device:");
            sb.append(this.device + ",");
        }
        if (this.expire != null) {
            sb.append("expire:");
            sb.append(this.expire + ",");
        }
        if (this.html != null) {
            sb.append("html:");
            sb.append(this.html + ",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(String.valueOf(this.httpConfig) + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.retry != null) {
            sb.append("retry:");
            sb.append(this.retry + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.sound != null) {
            sb.append("sound:");
            sb.append(this.sound + ",");
        }
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title + ",");
        }
        if (this.token != null) {
            sb.append("token:");
            sb.append(String.valueOf(this.token) + ",");
        }
        if (this.tokenFile != null) {
            sb.append("tokenFile:");
            sb.append(this.tokenFile + ",");
        }
        if (this.ttl != null) {
            sb.append("ttl:");
            sb.append(this.ttl + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.urlTitle != null) {
            sb.append("urlTitle:");
            sb.append(this.urlTitle + ",");
        }
        if (this.userKey != null) {
            sb.append("userKey:");
            sb.append(String.valueOf(this.userKey) + ",");
        }
        if (this.userKeyFile != null) {
            sb.append("userKeyFile:");
            sb.append(this.userKeyFile + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withHtml() {
        return this.withHtml(true);
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public class UserKeyNested<N>
    extends SecretKeySelectorFluent<UserKeyNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        UserKeyNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PushoverConfigFluent.this.withUserKey(this.builder.build());
        }

        public N endUserKey() {
            return this.and();
        }
    }

    public class TokenNested<N>
    extends SecretKeySelectorFluent<TokenNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        TokenNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PushoverConfigFluent.this.withToken(this.builder.build());
        }

        public N endToken() {
            return this.and();
        }
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PushoverConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }
}

