/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.IonosSDConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IonosSDConfigFluent<A extends IonosSDConfigFluent<A>>
extends BaseFluent<A> {
    private SafeAuthorizationBuilder authorization;
    private String datacenterID;
    private Boolean enableHTTP2;
    private Boolean followRedirects;
    private String noProxy;
    private Integer port;
    private Map<String, List<SecretKeySelector>> proxyConnectHeader;
    private Boolean proxyFromEnvironment;
    private String proxyUrl;
    private String refreshInterval;
    private SafeTLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public IonosSDConfigFluent() {
    }

    public IonosSDConfigFluent(IonosSDConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IonosSDConfig instance) {
        IonosSDConfig ionosSDConfig = instance = instance != null ? instance : new IonosSDConfig();
        if (instance != null) {
            this.withAuthorization(instance.getAuthorization());
            this.withDatacenterID(instance.getDatacenterID());
            this.withEnableHTTP2(instance.getEnableHTTP2());
            this.withFollowRedirects(instance.getFollowRedirects());
            this.withNoProxy(instance.getNoProxy());
            this.withPort(instance.getPort());
            this.withProxyConnectHeader(instance.getProxyConnectHeader());
            this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
            this.withProxyUrl(instance.getProxyUrl());
            this.withRefreshInterval(instance.getRefreshInterval());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SafeAuthorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(SafeAuthorization authorization) {
        this._visitables.remove("authorization");
        if (authorization != null) {
            this.authorization = new SafeAuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get("authorization").remove(this.authorization);
        }
        return (A)this;
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public String getDatacenterID() {
        return this.datacenterID;
    }

    public A withDatacenterID(String datacenterID) {
        this.datacenterID = datacenterID;
        return (A)this;
    }

    public boolean hasDatacenterID() {
        return this.datacenterID != null;
    }

    public Boolean getEnableHTTP2() {
        return this.enableHTTP2;
    }

    public A withEnableHTTP2(Boolean enableHTTP2) {
        this.enableHTTP2 = enableHTTP2;
        return (A)this;
    }

    public boolean hasEnableHTTP2() {
        return this.enableHTTP2 != null;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public A withFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return (A)this;
    }

    public boolean hasFollowRedirects() {
        return this.followRedirects != null;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)this;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A addToProxyConnectHeader(String key, List<SecretKeySelector> value) {
        if (this.proxyConnectHeader == null && key != null && value != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (key != null && value != null) {
            this.proxyConnectHeader.put(key, value);
        }
        return (A)this;
    }

    public A addToProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null && map != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (map != null) {
            this.proxyConnectHeader.putAll(map);
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(String key) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (key != null && this.proxyConnectHeader != null) {
            this.proxyConnectHeader.remove(key);
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyConnectHeader == null) continue;
                this.proxyConnectHeader.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, List<SecretKeySelector>> getProxyConnectHeader() {
        return this.proxyConnectHeader;
    }

    public <K, V> A withProxyConnectHeader(Map<String, List<SecretKeySelector>> proxyConnectHeader) {
        this.proxyConnectHeader = proxyConnectHeader == null ? null : new LinkedHashMap<String, List<SecretKeySelector>>(proxyConnectHeader);
        return (A)this;
    }

    public boolean hasProxyConnectHeader() {
        return this.proxyConnectHeader != null;
    }

    public Boolean getProxyFromEnvironment() {
        return this.proxyFromEnvironment;
    }

    public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
        this.proxyFromEnvironment = proxyFromEnvironment;
        return (A)this;
    }

    public boolean hasProxyFromEnvironment() {
        return this.proxyFromEnvironment != null;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)this;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public A withRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
        return (A)this;
    }

    public boolean hasRefreshInterval() {
        return this.refreshInterval != null;
    }

    public SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(SafeTLSConfig tlsConfig) {
        this._visitables.remove("tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IonosSDConfigFluent that = (IonosSDConfigFluent)o;
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals(this.datacenterID, that.datacenterID)) {
            return false;
        }
        if (!Objects.equals(this.enableHTTP2, that.enableHTTP2)) {
            return false;
        }
        if (!Objects.equals(this.followRedirects, that.followRedirects)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.proxyConnectHeader, that.proxyConnectHeader)) {
            return false;
        }
        if (!Objects.equals(this.proxyFromEnvironment, that.proxyFromEnvironment)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.refreshInterval, that.refreshInterval)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authorization, this.datacenterID, this.enableHTTP2, this.followRedirects, this.noProxy, this.port, this.proxyConnectHeader, this.proxyFromEnvironment, this.proxyUrl, this.refreshInterval, this.tlsConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(String.valueOf(this.authorization) + ",");
        }
        if (this.datacenterID != null) {
            sb.append("datacenterID:");
            sb.append(this.datacenterID + ",");
        }
        if (this.enableHTTP2 != null) {
            sb.append("enableHTTP2:");
            sb.append(this.enableHTTP2 + ",");
        }
        if (this.followRedirects != null) {
            sb.append("followRedirects:");
            sb.append(this.followRedirects + ",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.proxyConnectHeader != null && !this.proxyConnectHeader.isEmpty()) {
            sb.append("proxyConnectHeader:");
            sb.append(String.valueOf(this.proxyConnectHeader) + ",");
        }
        if (this.proxyFromEnvironment != null) {
            sb.append("proxyFromEnvironment:");
            sb.append(this.proxyFromEnvironment + ",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl + ",");
        }
        if (this.refreshInterval != null) {
            sb.append("refreshInterval:");
            sb.append(this.refreshInterval + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(String.valueOf(this.tlsConfig) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnableHTTP2() {
        return this.withEnableHTTP2(true);
    }

    public A withFollowRedirects() {
        return this.withFollowRedirects(true);
    }

    public A withProxyFromEnvironment() {
        return this.withProxyFromEnvironment(true);
    }

    public class TlsConfigNested<N>
    extends SafeTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        TlsConfigNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IonosSDConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends SafeAuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        SafeAuthorizationBuilder builder;

        AuthorizationNested(SafeAuthorization item) {
            this.builder = new SafeAuthorizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IonosSDConfigFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }
}

