/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeStatusPinnedImageSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachineConfigNodeStatusPinnedImageSetFluent<A extends MachineConfigNodeStatusPinnedImageSetFluent<A>>
extends BaseFluent<A> {
    private Integer currentGeneration;
    private Integer desiredGeneration;
    private Integer lastFailedGeneration;
    private List<String> lastFailedGenerationErrors = new ArrayList<String>();
    private String name;
    private Map<String, Object> additionalProperties;

    public MachineConfigNodeStatusPinnedImageSetFluent() {
    }

    public MachineConfigNodeStatusPinnedImageSetFluent(MachineConfigNodeStatusPinnedImageSet instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineConfigNodeStatusPinnedImageSet instance) {
        MachineConfigNodeStatusPinnedImageSet machineConfigNodeStatusPinnedImageSet = instance = instance != null ? instance : new MachineConfigNodeStatusPinnedImageSet();
        if (instance != null) {
            this.withCurrentGeneration(instance.getCurrentGeneration());
            this.withDesiredGeneration(instance.getDesiredGeneration());
            this.withLastFailedGeneration(instance.getLastFailedGeneration());
            this.withLastFailedGenerationErrors(instance.getLastFailedGenerationErrors());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getCurrentGeneration() {
        return this.currentGeneration;
    }

    public A withCurrentGeneration(Integer currentGeneration) {
        this.currentGeneration = currentGeneration;
        return (A)this;
    }

    public boolean hasCurrentGeneration() {
        return this.currentGeneration != null;
    }

    public Integer getDesiredGeneration() {
        return this.desiredGeneration;
    }

    public A withDesiredGeneration(Integer desiredGeneration) {
        this.desiredGeneration = desiredGeneration;
        return (A)this;
    }

    public boolean hasDesiredGeneration() {
        return this.desiredGeneration != null;
    }

    public Integer getLastFailedGeneration() {
        return this.lastFailedGeneration;
    }

    public A withLastFailedGeneration(Integer lastFailedGeneration) {
        this.lastFailedGeneration = lastFailedGeneration;
        return (A)this;
    }

    public boolean hasLastFailedGeneration() {
        return this.lastFailedGeneration != null;
    }

    public A addToLastFailedGenerationErrors(int index, String item) {
        if (this.lastFailedGenerationErrors == null) {
            this.lastFailedGenerationErrors = new ArrayList<String>();
        }
        this.lastFailedGenerationErrors.add(index, item);
        return (A)this;
    }

    public A setToLastFailedGenerationErrors(int index, String item) {
        if (this.lastFailedGenerationErrors == null) {
            this.lastFailedGenerationErrors = new ArrayList<String>();
        }
        this.lastFailedGenerationErrors.set(index, item);
        return (A)this;
    }

    public A addToLastFailedGenerationErrors(String ... items) {
        if (this.lastFailedGenerationErrors == null) {
            this.lastFailedGenerationErrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.lastFailedGenerationErrors.add(item);
        }
        return (A)this;
    }

    public A addAllToLastFailedGenerationErrors(Collection<String> items) {
        if (this.lastFailedGenerationErrors == null) {
            this.lastFailedGenerationErrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.lastFailedGenerationErrors.add(item);
        }
        return (A)this;
    }

    public A removeFromLastFailedGenerationErrors(String ... items) {
        if (this.lastFailedGenerationErrors == null) {
            return (A)this;
        }
        for (String item : items) {
            this.lastFailedGenerationErrors.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromLastFailedGenerationErrors(Collection<String> items) {
        if (this.lastFailedGenerationErrors == null) {
            return (A)this;
        }
        for (String item : items) {
            this.lastFailedGenerationErrors.remove(item);
        }
        return (A)this;
    }

    public List<String> getLastFailedGenerationErrors() {
        return this.lastFailedGenerationErrors;
    }

    public String getLastFailedGenerationError(int index) {
        return this.lastFailedGenerationErrors.get(index);
    }

    public String getFirstLastFailedGenerationError() {
        return this.lastFailedGenerationErrors.get(0);
    }

    public String getLastLastFailedGenerationError() {
        return this.lastFailedGenerationErrors.get(this.lastFailedGenerationErrors.size() - 1);
    }

    public String getMatchingLastFailedGenerationError(Predicate<String> predicate) {
        for (String item : this.lastFailedGenerationErrors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingLastFailedGenerationError(Predicate<String> predicate) {
        for (String item : this.lastFailedGenerationErrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLastFailedGenerationErrors(List<String> lastFailedGenerationErrors) {
        if (lastFailedGenerationErrors != null) {
            this.lastFailedGenerationErrors = new ArrayList<String>();
            for (String item : lastFailedGenerationErrors) {
                this.addToLastFailedGenerationErrors(item);
            }
        } else {
            this.lastFailedGenerationErrors = null;
        }
        return (A)this;
    }

    public A withLastFailedGenerationErrors(String ... lastFailedGenerationErrors) {
        if (this.lastFailedGenerationErrors != null) {
            this.lastFailedGenerationErrors.clear();
            this._visitables.remove("lastFailedGenerationErrors");
        }
        if (lastFailedGenerationErrors != null) {
            for (String item : lastFailedGenerationErrors) {
                this.addToLastFailedGenerationErrors(item);
            }
        }
        return (A)this;
    }

    public boolean hasLastFailedGenerationErrors() {
        return this.lastFailedGenerationErrors != null && !this.lastFailedGenerationErrors.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigNodeStatusPinnedImageSetFluent that = (MachineConfigNodeStatusPinnedImageSetFluent)o;
        if (!Objects.equals(this.currentGeneration, that.currentGeneration)) {
            return false;
        }
        if (!Objects.equals(this.desiredGeneration, that.desiredGeneration)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedGeneration, that.lastFailedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedGenerationErrors, that.lastFailedGenerationErrors)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.currentGeneration, this.desiredGeneration, this.lastFailedGeneration, this.lastFailedGenerationErrors, this.name, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentGeneration != null) {
            sb.append("currentGeneration:");
            sb.append(this.currentGeneration + ",");
        }
        if (this.desiredGeneration != null) {
            sb.append("desiredGeneration:");
            sb.append(this.desiredGeneration + ",");
        }
        if (this.lastFailedGeneration != null) {
            sb.append("lastFailedGeneration:");
            sb.append(this.lastFailedGeneration + ",");
        }
        if (this.lastFailedGenerationErrors != null && !this.lastFailedGenerationErrors.isEmpty()) {
            sb.append("lastFailedGenerationErrors:");
            sb.append(String.valueOf(this.lastFailedGenerationErrors) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

