/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.powervs.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpoint;
import io.fabric8.openshift.api.model.installer.powervs.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.powervs.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.powervs.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.installer.powervs.v1.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private String clusterOSImage;
    private MachinePoolBuilder defaultMachinePlatform;
    private String powervsResourceGroup;
    private String region;
    private List<PowerVSServiceEndpoint> serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
    private String serviceInstanceGUID;
    private String tgName;
    private String userID;
    private String vpcName;
    private String vpcRegion;
    private List<String> vpcSubnets = new ArrayList<String>();
    private String zone;
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withClusterOSImage(instance.getClusterOSImage());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withPowervsResourceGroup(instance.getPowervsResourceGroup());
            this.withRegion(instance.getRegion());
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withServiceInstanceGUID(instance.getServiceInstanceGUID());
            this.withTgName(instance.getTgName());
            this.withUserID(instance.getUserID());
            this.withVpcName(instance.getVpcName());
            this.withVpcRegion(instance.getVpcRegion());
            this.withVpcSubnets(instance.getVpcSubnets());
            this.withZone(instance.getZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getClusterOSImage() {
        return this.clusterOSImage;
    }

    public A withClusterOSImage(String clusterOSImage) {
        this.clusterOSImage = clusterOSImage;
        return (A)this;
    }

    public boolean hasClusterOSImage() {
        return this.clusterOSImage != null;
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove("defaultMachinePlatform");
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public String getPowervsResourceGroup() {
        return this.powervsResourceGroup;
    }

    public A withPowervsResourceGroup(String powervsResourceGroup) {
        this.powervsResourceGroup = powervsResourceGroup;
        return (A)this;
    }

    public boolean hasPowervsResourceGroup() {
        return this.powervsResourceGroup != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public A addToServiceEndpoints(int index, PowerVSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
        }
        this.serviceEndpoints.add(index, item);
        return (A)this;
    }

    public A setToServiceEndpoints(int index, PowerVSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
        }
        this.serviceEndpoints.set(index, item);
        return (A)this;
    }

    public A addToServiceEndpoints(PowerVSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
        }
        for (PowerVSServiceEndpoint item : items) {
            this.serviceEndpoints.add(item);
        }
        return (A)this;
    }

    public A addAllToServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
        }
        for (PowerVSServiceEndpoint item : items) {
            this.serviceEndpoints.add(item);
        }
        return (A)this;
    }

    public A removeFromServiceEndpoints(PowerVSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (PowerVSServiceEndpoint item : items) {
            this.serviceEndpoints.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (PowerVSServiceEndpoint item : items) {
            this.serviceEndpoints.remove(item);
        }
        return (A)this;
    }

    public List<PowerVSServiceEndpoint> getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    public PowerVSServiceEndpoint getServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index);
    }

    public PowerVSServiceEndpoint getFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0);
    }

    public PowerVSServiceEndpoint getLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1);
    }

    public PowerVSServiceEndpoint getMatchingServiceEndpoint(Predicate<PowerVSServiceEndpoint> predicate) {
        for (PowerVSServiceEndpoint item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingServiceEndpoint(Predicate<PowerVSServiceEndpoint> predicate) {
        for (PowerVSServiceEndpoint item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceEndpoints(List<PowerVSServiceEndpoint> serviceEndpoints) {
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
            for (PowerVSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)this;
    }

    public A withServiceEndpoints(PowerVSServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
            this._visitables.remove("serviceEndpoints");
        }
        if (serviceEndpoints != null) {
            for (PowerVSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new PowerVSServiceEndpoint(name, url));
    }

    public String getServiceInstanceGUID() {
        return this.serviceInstanceGUID;
    }

    public A withServiceInstanceGUID(String serviceInstanceGUID) {
        this.serviceInstanceGUID = serviceInstanceGUID;
        return (A)this;
    }

    public boolean hasServiceInstanceGUID() {
        return this.serviceInstanceGUID != null;
    }

    public String getTgName() {
        return this.tgName;
    }

    public A withTgName(String tgName) {
        this.tgName = tgName;
        return (A)this;
    }

    public boolean hasTgName() {
        return this.tgName != null;
    }

    public String getUserID() {
        return this.userID;
    }

    public A withUserID(String userID) {
        this.userID = userID;
        return (A)this;
    }

    public boolean hasUserID() {
        return this.userID != null;
    }

    public String getVpcName() {
        return this.vpcName;
    }

    public A withVpcName(String vpcName) {
        this.vpcName = vpcName;
        return (A)this;
    }

    public boolean hasVpcName() {
        return this.vpcName != null;
    }

    public String getVpcRegion() {
        return this.vpcRegion;
    }

    public A withVpcRegion(String vpcRegion) {
        this.vpcRegion = vpcRegion;
        return (A)this;
    }

    public boolean hasVpcRegion() {
        return this.vpcRegion != null;
    }

    public A addToVpcSubnets(int index, String item) {
        if (this.vpcSubnets == null) {
            this.vpcSubnets = new ArrayList<String>();
        }
        this.vpcSubnets.add(index, item);
        return (A)this;
    }

    public A setToVpcSubnets(int index, String item) {
        if (this.vpcSubnets == null) {
            this.vpcSubnets = new ArrayList<String>();
        }
        this.vpcSubnets.set(index, item);
        return (A)this;
    }

    public A addToVpcSubnets(String ... items) {
        if (this.vpcSubnets == null) {
            this.vpcSubnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.vpcSubnets.add(item);
        }
        return (A)this;
    }

    public A addAllToVpcSubnets(Collection<String> items) {
        if (this.vpcSubnets == null) {
            this.vpcSubnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.vpcSubnets.add(item);
        }
        return (A)this;
    }

    public A removeFromVpcSubnets(String ... items) {
        if (this.vpcSubnets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.vpcSubnets.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVpcSubnets(Collection<String> items) {
        if (this.vpcSubnets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.vpcSubnets.remove(item);
        }
        return (A)this;
    }

    public List<String> getVpcSubnets() {
        return this.vpcSubnets;
    }

    public String getVpcSubnet(int index) {
        return this.vpcSubnets.get(index);
    }

    public String getFirstVpcSubnet() {
        return this.vpcSubnets.get(0);
    }

    public String getLastVpcSubnet() {
        return this.vpcSubnets.get(this.vpcSubnets.size() - 1);
    }

    public String getMatchingVpcSubnet(Predicate<String> predicate) {
        for (String item : this.vpcSubnets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVpcSubnet(Predicate<String> predicate) {
        for (String item : this.vpcSubnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVpcSubnets(List<String> vpcSubnets) {
        if (vpcSubnets != null) {
            this.vpcSubnets = new ArrayList<String>();
            for (String item : vpcSubnets) {
                this.addToVpcSubnets(item);
            }
        } else {
            this.vpcSubnets = null;
        }
        return (A)this;
    }

    public A withVpcSubnets(String ... vpcSubnets) {
        if (this.vpcSubnets != null) {
            this.vpcSubnets.clear();
            this._visitables.remove("vpcSubnets");
        }
        if (vpcSubnets != null) {
            for (String item : vpcSubnets) {
                this.addToVpcSubnets(item);
            }
        }
        return (A)this;
    }

    public boolean hasVpcSubnets() {
        return this.vpcSubnets != null && !this.vpcSubnets.isEmpty();
    }

    public String getZone() {
        return this.zone;
    }

    public A withZone(String zone) {
        this.zone = zone;
        return (A)this;
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)o;
        if (!Objects.equals(this.clusterOSImage, that.clusterOSImage)) {
            return false;
        }
        if (!Objects.equals(this.defaultMachinePlatform, that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.powervsResourceGroup, that.powervsResourceGroup)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.serviceEndpoints, that.serviceEndpoints)) {
            return false;
        }
        if (!Objects.equals(this.serviceInstanceGUID, that.serviceInstanceGUID)) {
            return false;
        }
        if (!Objects.equals(this.tgName, that.tgName)) {
            return false;
        }
        if (!Objects.equals(this.userID, that.userID)) {
            return false;
        }
        if (!Objects.equals(this.vpcName, that.vpcName)) {
            return false;
        }
        if (!Objects.equals(this.vpcRegion, that.vpcRegion)) {
            return false;
        }
        if (!Objects.equals(this.vpcSubnets, that.vpcSubnets)) {
            return false;
        }
        if (!Objects.equals(this.zone, that.zone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterOSImage, this.defaultMachinePlatform, this.powervsResourceGroup, this.region, this.serviceEndpoints, this.serviceInstanceGUID, this.tgName, this.userID, this.vpcName, this.vpcRegion, this.vpcSubnets, this.zone, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterOSImage != null) {
            sb.append("clusterOSImage:");
            sb.append(this.clusterOSImage + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(String.valueOf(this.defaultMachinePlatform) + ",");
        }
        if (this.powervsResourceGroup != null) {
            sb.append("powervsResourceGroup:");
            sb.append(this.powervsResourceGroup + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(String.valueOf(this.serviceEndpoints) + ",");
        }
        if (this.serviceInstanceGUID != null) {
            sb.append("serviceInstanceGUID:");
            sb.append(this.serviceInstanceGUID + ",");
        }
        if (this.tgName != null) {
            sb.append("tgName:");
            sb.append(this.tgName + ",");
        }
        if (this.userID != null) {
            sb.append("userID:");
            sb.append(this.userID + ",");
        }
        if (this.vpcName != null) {
            sb.append("vpcName:");
            sb.append(this.vpcName + ",");
        }
        if (this.vpcRegion != null) {
            sb.append("vpcRegion:");
            sb.append(this.vpcRegion + ",");
        }
        if (this.vpcSubnets != null && !this.vpcSubnets.isEmpty()) {
            sb.append("vpcSubnets:");
            sb.append(String.valueOf(this.vpcSubnets) + ",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

