/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.installer.gcp.v1.QuotaUsage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class QuotaUsageFluent<A extends QuotaUsageFluent<A>>
extends BaseFluent<A> {
    private Long amount;
    private Map<String, String> dimensions;
    private String limit;
    private String service;
    private Map<String, Object> additionalProperties;

    public QuotaUsageFluent() {
    }

    public QuotaUsageFluent(QuotaUsage instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(QuotaUsage instance) {
        QuotaUsage quotaUsage = instance = instance != null ? instance : new QuotaUsage();
        if (instance != null) {
            this.withAmount(instance.getAmount());
            this.withDimensions(instance.getDimensions());
            this.withLimit(instance.getLimit());
            this.withService(instance.getService());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getAmount() {
        return this.amount;
    }

    public A withAmount(Long amount) {
        this.amount = amount;
        return (A)this;
    }

    public boolean hasAmount() {
        return this.amount != null;
    }

    public A addToDimensions(String key, String value) {
        if (this.dimensions == null && key != null && value != null) {
            this.dimensions = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.dimensions.put(key, value);
        }
        return (A)this;
    }

    public A addToDimensions(Map<String, String> map) {
        if (this.dimensions == null && map != null) {
            this.dimensions = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.dimensions.putAll(map);
        }
        return (A)this;
    }

    public A removeFromDimensions(String key) {
        if (this.dimensions == null) {
            return (A)this;
        }
        if (key != null && this.dimensions != null) {
            this.dimensions.remove(key);
        }
        return (A)this;
    }

    public A removeFromDimensions(Map<String, String> map) {
        if (this.dimensions == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.dimensions == null) continue;
                this.dimensions.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public <K, V> A withDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions == null ? null : new LinkedHashMap<String, String>(dimensions);
        return (A)this;
    }

    public boolean hasDimensions() {
        return this.dimensions != null;
    }

    public String getLimit() {
        return this.limit;
    }

    public A withLimit(String limit) {
        this.limit = limit;
        return (A)this;
    }

    public boolean hasLimit() {
        return this.limit != null;
    }

    public String getService() {
        return this.service;
    }

    public A withService(String service) {
        this.service = service;
        return (A)this;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuotaUsageFluent that = (QuotaUsageFluent)o;
        if (!Objects.equals(this.amount, that.amount)) {
            return false;
        }
        if (!Objects.equals(this.dimensions, that.dimensions)) {
            return false;
        }
        if (!Objects.equals(this.limit, that.limit)) {
            return false;
        }
        if (!Objects.equals(this.service, that.service)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.amount, this.dimensions, this.limit, this.service, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.amount != null) {
            sb.append("amount:");
            sb.append(this.amount + ",");
        }
        if (this.dimensions != null && !this.dimensions.isEmpty()) {
            sb.append("dimensions:");
            sb.append(String.valueOf(this.dimensions) + ",");
        }
        if (this.limit != null) {
            sb.append("limit:");
            sb.append(this.limit + ",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append(this.service + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

