/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.azure.v1.CustomerManagedKey;
import io.fabric8.openshift.api.model.installer.azure.v1.CustomerManagedKeyBuilder;
import io.fabric8.openshift.api.model.installer.azure.v1.CustomerManagedKeyFluent;
import io.fabric8.openshift.api.model.installer.azure.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.azure.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.azure.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.installer.azure.v1.Platform;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private String armEndpoint;
    private String baseDomainResourceGroupName;
    private String cloudName;
    private String clusterOSImage;
    private String computeSubnet;
    private String controlPlaneSubnet;
    private CustomerManagedKeyBuilder customerManagedKey;
    private MachinePoolBuilder defaultMachinePlatform;
    private String networkResourceGroupName;
    private String outboundType;
    private String region;
    private String resourceGroupName;
    private Map<String, String> userTags;
    private String virtualNetwork;
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withArmEndpoint(instance.getArmEndpoint());
            this.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName());
            this.withCloudName(instance.getCloudName());
            this.withClusterOSImage(instance.getClusterOSImage());
            this.withComputeSubnet(instance.getComputeSubnet());
            this.withControlPlaneSubnet(instance.getControlPlaneSubnet());
            this.withCustomerManagedKey(instance.getCustomerManagedKey());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
            this.withOutboundType(instance.getOutboundType());
            this.withRegion(instance.getRegion());
            this.withResourceGroupName(instance.getResourceGroupName());
            this.withUserTags(instance.getUserTags());
            this.withVirtualNetwork(instance.getVirtualNetwork());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getArmEndpoint() {
        return this.armEndpoint;
    }

    public A withArmEndpoint(String armEndpoint) {
        this.armEndpoint = armEndpoint;
        return (A)this;
    }

    public boolean hasArmEndpoint() {
        return this.armEndpoint != null;
    }

    public String getBaseDomainResourceGroupName() {
        return this.baseDomainResourceGroupName;
    }

    public A withBaseDomainResourceGroupName(String baseDomainResourceGroupName) {
        this.baseDomainResourceGroupName = baseDomainResourceGroupName;
        return (A)this;
    }

    public boolean hasBaseDomainResourceGroupName() {
        return this.baseDomainResourceGroupName != null;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public A withCloudName(String cloudName) {
        this.cloudName = cloudName;
        return (A)this;
    }

    public boolean hasCloudName() {
        return this.cloudName != null;
    }

    public String getClusterOSImage() {
        return this.clusterOSImage;
    }

    public A withClusterOSImage(String clusterOSImage) {
        this.clusterOSImage = clusterOSImage;
        return (A)this;
    }

    public boolean hasClusterOSImage() {
        return this.clusterOSImage != null;
    }

    public String getComputeSubnet() {
        return this.computeSubnet;
    }

    public A withComputeSubnet(String computeSubnet) {
        this.computeSubnet = computeSubnet;
        return (A)this;
    }

    public boolean hasComputeSubnet() {
        return this.computeSubnet != null;
    }

    public String getControlPlaneSubnet() {
        return this.controlPlaneSubnet;
    }

    public A withControlPlaneSubnet(String controlPlaneSubnet) {
        this.controlPlaneSubnet = controlPlaneSubnet;
        return (A)this;
    }

    public boolean hasControlPlaneSubnet() {
        return this.controlPlaneSubnet != null;
    }

    public CustomerManagedKey buildCustomerManagedKey() {
        return this.customerManagedKey != null ? this.customerManagedKey.build() : null;
    }

    public A withCustomerManagedKey(CustomerManagedKey customerManagedKey) {
        this._visitables.remove("customerManagedKey");
        if (customerManagedKey != null) {
            this.customerManagedKey = new CustomerManagedKeyBuilder(customerManagedKey);
            this._visitables.get("customerManagedKey").add(this.customerManagedKey);
        } else {
            this.customerManagedKey = null;
            this._visitables.get("customerManagedKey").remove(this.customerManagedKey);
        }
        return (A)this;
    }

    public boolean hasCustomerManagedKey() {
        return this.customerManagedKey != null;
    }

    public CustomerManagedKeyNested<A> withNewCustomerManagedKey() {
        return new CustomerManagedKeyNested(null);
    }

    public CustomerManagedKeyNested<A> withNewCustomerManagedKeyLike(CustomerManagedKey item) {
        return new CustomerManagedKeyNested(item);
    }

    public CustomerManagedKeyNested<A> editCustomerManagedKey() {
        return this.withNewCustomerManagedKeyLike(Optional.ofNullable(this.buildCustomerManagedKey()).orElse(null));
    }

    public CustomerManagedKeyNested<A> editOrNewCustomerManagedKey() {
        return this.withNewCustomerManagedKeyLike(Optional.ofNullable(this.buildCustomerManagedKey()).orElse(new CustomerManagedKeyBuilder().build()));
    }

    public CustomerManagedKeyNested<A> editOrNewCustomerManagedKeyLike(CustomerManagedKey item) {
        return this.withNewCustomerManagedKeyLike(Optional.ofNullable(this.buildCustomerManagedKey()).orElse(item));
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove("defaultMachinePlatform");
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public String getNetworkResourceGroupName() {
        return this.networkResourceGroupName;
    }

    public A withNetworkResourceGroupName(String networkResourceGroupName) {
        this.networkResourceGroupName = networkResourceGroupName;
        return (A)this;
    }

    public boolean hasNetworkResourceGroupName() {
        return this.networkResourceGroupName != null;
    }

    public String getOutboundType() {
        return this.outboundType;
    }

    public A withOutboundType(String outboundType) {
        this.outboundType = outboundType;
        return (A)this;
    }

    public boolean hasOutboundType() {
        return this.outboundType != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public A withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return (A)this;
    }

    public boolean hasResourceGroupName() {
        return this.resourceGroupName != null;
    }

    public A addToUserTags(String key, String value) {
        if (this.userTags == null && key != null && value != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.userTags.put(key, value);
        }
        return (A)this;
    }

    public A addToUserTags(Map<String, String> map) {
        if (this.userTags == null && map != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.userTags.putAll(map);
        }
        return (A)this;
    }

    public A removeFromUserTags(String key) {
        if (this.userTags == null) {
            return (A)this;
        }
        if (key != null && this.userTags != null) {
            this.userTags.remove(key);
        }
        return (A)this;
    }

    public A removeFromUserTags(Map<String, String> map) {
        if (this.userTags == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.userTags == null) continue;
                this.userTags.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getUserTags() {
        return this.userTags;
    }

    public <K, V> A withUserTags(Map<String, String> userTags) {
        this.userTags = userTags == null ? null : new LinkedHashMap<String, String>(userTags);
        return (A)this;
    }

    public boolean hasUserTags() {
        return this.userTags != null;
    }

    public String getVirtualNetwork() {
        return this.virtualNetwork;
    }

    public A withVirtualNetwork(String virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return (A)this;
    }

    public boolean hasVirtualNetwork() {
        return this.virtualNetwork != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)o;
        if (!Objects.equals(this.armEndpoint, that.armEndpoint)) {
            return false;
        }
        if (!Objects.equals(this.baseDomainResourceGroupName, that.baseDomainResourceGroupName)) {
            return false;
        }
        if (!Objects.equals(this.cloudName, that.cloudName)) {
            return false;
        }
        if (!Objects.equals(this.clusterOSImage, that.clusterOSImage)) {
            return false;
        }
        if (!Objects.equals(this.computeSubnet, that.computeSubnet)) {
            return false;
        }
        if (!Objects.equals(this.controlPlaneSubnet, that.controlPlaneSubnet)) {
            return false;
        }
        if (!Objects.equals(this.customerManagedKey, that.customerManagedKey)) {
            return false;
        }
        if (!Objects.equals(this.defaultMachinePlatform, that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.networkResourceGroupName, that.networkResourceGroupName)) {
            return false;
        }
        if (!Objects.equals(this.outboundType, that.outboundType)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.resourceGroupName, that.resourceGroupName)) {
            return false;
        }
        if (!Objects.equals(this.userTags, that.userTags)) {
            return false;
        }
        if (!Objects.equals(this.virtualNetwork, that.virtualNetwork)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.armEndpoint, this.baseDomainResourceGroupName, this.cloudName, this.clusterOSImage, this.computeSubnet, this.controlPlaneSubnet, this.customerManagedKey, this.defaultMachinePlatform, this.networkResourceGroupName, this.outboundType, this.region, this.resourceGroupName, this.userTags, this.virtualNetwork, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.armEndpoint != null) {
            sb.append("armEndpoint:");
            sb.append(this.armEndpoint + ",");
        }
        if (this.baseDomainResourceGroupName != null) {
            sb.append("baseDomainResourceGroupName:");
            sb.append(this.baseDomainResourceGroupName + ",");
        }
        if (this.cloudName != null) {
            sb.append("cloudName:");
            sb.append(this.cloudName + ",");
        }
        if (this.clusterOSImage != null) {
            sb.append("clusterOSImage:");
            sb.append(this.clusterOSImage + ",");
        }
        if (this.computeSubnet != null) {
            sb.append("computeSubnet:");
            sb.append(this.computeSubnet + ",");
        }
        if (this.controlPlaneSubnet != null) {
            sb.append("controlPlaneSubnet:");
            sb.append(this.controlPlaneSubnet + ",");
        }
        if (this.customerManagedKey != null) {
            sb.append("customerManagedKey:");
            sb.append(String.valueOf(this.customerManagedKey) + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(String.valueOf(this.defaultMachinePlatform) + ",");
        }
        if (this.networkResourceGroupName != null) {
            sb.append("networkResourceGroupName:");
            sb.append(this.networkResourceGroupName + ",");
        }
        if (this.outboundType != null) {
            sb.append("outboundType:");
            sb.append(this.outboundType + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.resourceGroupName != null) {
            sb.append("resourceGroupName:");
            sb.append(this.resourceGroupName + ",");
        }
        if (this.userTags != null && !this.userTags.isEmpty()) {
            sb.append("userTags:");
            sb.append(String.valueOf(this.userTags) + ",");
        }
        if (this.virtualNetwork != null) {
            sb.append("virtualNetwork:");
            sb.append(this.virtualNetwork + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }

    public class CustomerManagedKeyNested<N>
    extends CustomerManagedKeyFluent<CustomerManagedKeyNested<N>>
    implements Nested<N> {
        CustomerManagedKeyBuilder builder;

        CustomerManagedKeyNested(CustomerManagedKey item) {
            this.builder = new CustomerManagedKeyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withCustomerManagedKey(this.builder.build());
        }

        public N endCustomerManagedKey() {
            return this.and();
        }
    }
}

