/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.SyncCondition;
import io.fabric8.openshift.api.model.hive.v1.SyncConditionBuilder;
import io.fabric8.openshift.api.model.hive.v1.SyncConditionFluent;
import io.fabric8.openshift.api.model.hive.v1.SyncStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SyncStatusFluent<A extends SyncStatusFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<SyncConditionBuilder> conditions = new ArrayList();
    private String hash;
    private String kind;
    private String name;
    private String namespace;
    private String resource;
    private Map<String, Object> additionalProperties;

    public SyncStatusFluent() {
    }

    public SyncStatusFluent(SyncStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SyncStatus instance) {
        SyncStatus syncStatus = instance = instance != null ? instance : new SyncStatus();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withConditions(instance.getConditions());
            this.withHash(instance.getHash());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withResource(instance.getResource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToConditions(int index, SyncCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        SyncConditionBuilder builder = new SyncConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, SyncCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        SyncConditionBuilder builder = new SyncConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(SyncCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (SyncCondition item : items) {
            SyncConditionBuilder builder = new SyncConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<SyncCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (SyncCondition item : items) {
            SyncConditionBuilder builder = new SyncConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(SyncCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (SyncCondition item : items) {
            SyncConditionBuilder builder = new SyncConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<SyncCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (SyncCondition item : items) {
            SyncConditionBuilder builder = new SyncConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<SyncConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<SyncConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            SyncConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SyncCondition> buildConditions() {
        return this.conditions != null ? SyncStatusFluent.build(this.conditions) : null;
    }

    public SyncCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public SyncCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public SyncCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public SyncCondition buildMatchingCondition(Predicate<SyncConditionBuilder> predicate) {
        for (SyncConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<SyncConditionBuilder> predicate) {
        for (SyncConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<SyncCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (SyncCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(SyncCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (SyncCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(SyncCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, SyncCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<SyncConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getHash() {
        return this.hash;
    }

    public A withHash(String hash) {
        this.hash = hash;
        return (A)this;
    }

    public boolean hasHash() {
        return this.hash != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getResource() {
        return this.resource;
    }

    public A withResource(String resource) {
        this.resource = resource;
        return (A)this;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SyncStatusFluent that = (SyncStatusFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.hash, that.hash)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.conditions, this.hash, this.kind, this.name, this.namespace, this.resource, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.hash != null) {
            sb.append("hash:");
            sb.append(this.hash + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends SyncConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        SyncConditionBuilder builder;
        int index;

        ConditionsNested(int index, SyncCondition item) {
            this.index = index;
            this.builder = new SyncConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SyncStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

