/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.NetworkDiagnostics;
import io.fabric8.openshift.api.model.config.v1.NetworkDiagnosticsSourcePlacement;
import io.fabric8.openshift.api.model.config.v1.NetworkDiagnosticsSourcePlacementBuilder;
import io.fabric8.openshift.api.model.config.v1.NetworkDiagnosticsSourcePlacementFluent;
import io.fabric8.openshift.api.model.config.v1.NetworkDiagnosticsTargetPlacement;
import io.fabric8.openshift.api.model.config.v1.NetworkDiagnosticsTargetPlacementBuilder;
import io.fabric8.openshift.api.model.config.v1.NetworkDiagnosticsTargetPlacementFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkDiagnosticsFluent<A extends NetworkDiagnosticsFluent<A>>
extends BaseFluent<A> {
    private String mode;
    private NetworkDiagnosticsSourcePlacementBuilder sourcePlacement;
    private NetworkDiagnosticsTargetPlacementBuilder targetPlacement;
    private Map<String, Object> additionalProperties;

    public NetworkDiagnosticsFluent() {
    }

    public NetworkDiagnosticsFluent(NetworkDiagnostics instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkDiagnostics instance) {
        NetworkDiagnostics networkDiagnostics = instance = instance != null ? instance : new NetworkDiagnostics();
        if (instance != null) {
            this.withMode(instance.getMode());
            this.withSourcePlacement(instance.getSourcePlacement());
            this.withTargetPlacement(instance.getTargetPlacement());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)this;
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public NetworkDiagnosticsSourcePlacement buildSourcePlacement() {
        return this.sourcePlacement != null ? this.sourcePlacement.build() : null;
    }

    public A withSourcePlacement(NetworkDiagnosticsSourcePlacement sourcePlacement) {
        this._visitables.remove("sourcePlacement");
        if (sourcePlacement != null) {
            this.sourcePlacement = new NetworkDiagnosticsSourcePlacementBuilder(sourcePlacement);
            this._visitables.get("sourcePlacement").add(this.sourcePlacement);
        } else {
            this.sourcePlacement = null;
            this._visitables.get("sourcePlacement").remove(this.sourcePlacement);
        }
        return (A)this;
    }

    public boolean hasSourcePlacement() {
        return this.sourcePlacement != null;
    }

    public SourcePlacementNested<A> withNewSourcePlacement() {
        return new SourcePlacementNested(null);
    }

    public SourcePlacementNested<A> withNewSourcePlacementLike(NetworkDiagnosticsSourcePlacement item) {
        return new SourcePlacementNested(item);
    }

    public SourcePlacementNested<A> editSourcePlacement() {
        return this.withNewSourcePlacementLike(Optional.ofNullable(this.buildSourcePlacement()).orElse(null));
    }

    public SourcePlacementNested<A> editOrNewSourcePlacement() {
        return this.withNewSourcePlacementLike(Optional.ofNullable(this.buildSourcePlacement()).orElse(new NetworkDiagnosticsSourcePlacementBuilder().build()));
    }

    public SourcePlacementNested<A> editOrNewSourcePlacementLike(NetworkDiagnosticsSourcePlacement item) {
        return this.withNewSourcePlacementLike(Optional.ofNullable(this.buildSourcePlacement()).orElse(item));
    }

    public NetworkDiagnosticsTargetPlacement buildTargetPlacement() {
        return this.targetPlacement != null ? this.targetPlacement.build() : null;
    }

    public A withTargetPlacement(NetworkDiagnosticsTargetPlacement targetPlacement) {
        this._visitables.remove("targetPlacement");
        if (targetPlacement != null) {
            this.targetPlacement = new NetworkDiagnosticsTargetPlacementBuilder(targetPlacement);
            this._visitables.get("targetPlacement").add(this.targetPlacement);
        } else {
            this.targetPlacement = null;
            this._visitables.get("targetPlacement").remove(this.targetPlacement);
        }
        return (A)this;
    }

    public boolean hasTargetPlacement() {
        return this.targetPlacement != null;
    }

    public TargetPlacementNested<A> withNewTargetPlacement() {
        return new TargetPlacementNested(null);
    }

    public TargetPlacementNested<A> withNewTargetPlacementLike(NetworkDiagnosticsTargetPlacement item) {
        return new TargetPlacementNested(item);
    }

    public TargetPlacementNested<A> editTargetPlacement() {
        return this.withNewTargetPlacementLike(Optional.ofNullable(this.buildTargetPlacement()).orElse(null));
    }

    public TargetPlacementNested<A> editOrNewTargetPlacement() {
        return this.withNewTargetPlacementLike(Optional.ofNullable(this.buildTargetPlacement()).orElse(new NetworkDiagnosticsTargetPlacementBuilder().build()));
    }

    public TargetPlacementNested<A> editOrNewTargetPlacementLike(NetworkDiagnosticsTargetPlacement item) {
        return this.withNewTargetPlacementLike(Optional.ofNullable(this.buildTargetPlacement()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDiagnosticsFluent that = (NetworkDiagnosticsFluent)o;
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals(this.sourcePlacement, that.sourcePlacement)) {
            return false;
        }
        if (!Objects.equals(this.targetPlacement, that.targetPlacement)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mode, this.sourcePlacement, this.targetPlacement, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.sourcePlacement != null) {
            sb.append("sourcePlacement:");
            sb.append(String.valueOf(this.sourcePlacement) + ",");
        }
        if (this.targetPlacement != null) {
            sb.append("targetPlacement:");
            sb.append(String.valueOf(this.targetPlacement) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetPlacementNested<N>
    extends NetworkDiagnosticsTargetPlacementFluent<TargetPlacementNested<N>>
    implements Nested<N> {
        NetworkDiagnosticsTargetPlacementBuilder builder;

        TargetPlacementNested(NetworkDiagnosticsTargetPlacement item) {
            this.builder = new NetworkDiagnosticsTargetPlacementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkDiagnosticsFluent.this.withTargetPlacement(this.builder.build());
        }

        public N endTargetPlacement() {
            return this.and();
        }
    }

    public class SourcePlacementNested<N>
    extends NetworkDiagnosticsSourcePlacementFluent<SourcePlacementNested<N>>
    implements Nested<N> {
        NetworkDiagnosticsSourcePlacementBuilder builder;

        SourcePlacementNested(NetworkDiagnosticsSourcePlacement item) {
            this.builder = new NetworkDiagnosticsSourcePlacementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkDiagnosticsFluent.this.withSourcePlacement(this.builder.build());
        }

        public N endSourcePlacement() {
            return this.and();
        }
    }
}

