/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.ExternalIPPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ExternalIPPolicyFluent<A extends ExternalIPPolicyFluent<A>>
extends BaseFluent<A> {
    private List<String> allowedCIDRs = new ArrayList<String>();
    private List<String> rejectedCIDRs = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ExternalIPPolicyFluent() {
    }

    public ExternalIPPolicyFluent(ExternalIPPolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ExternalIPPolicy instance) {
        ExternalIPPolicy externalIPPolicy = instance = instance != null ? instance : new ExternalIPPolicy();
        if (instance != null) {
            this.withAllowedCIDRs(instance.getAllowedCIDRs());
            this.withRejectedCIDRs(instance.getRejectedCIDRs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAllowedCIDRs(int index, String item) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        this.allowedCIDRs.add(index, item);
        return (A)this;
    }

    public A setToAllowedCIDRs(int index, String item) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        this.allowedCIDRs.set(index, item);
        return (A)this;
    }

    public A addToAllowedCIDRs(String ... items) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCIDRs.add(item);
        }
        return (A)this;
    }

    public A addAllToAllowedCIDRs(Collection<String> items) {
        if (this.allowedCIDRs == null) {
            this.allowedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCIDRs.add(item);
        }
        return (A)this;
    }

    public A removeFromAllowedCIDRs(String ... items) {
        if (this.allowedCIDRs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.allowedCIDRs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAllowedCIDRs(Collection<String> items) {
        if (this.allowedCIDRs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.allowedCIDRs.remove(item);
        }
        return (A)this;
    }

    public List<String> getAllowedCIDRs() {
        return this.allowedCIDRs;
    }

    public String getAllowedCIDR(int index) {
        return this.allowedCIDRs.get(index);
    }

    public String getFirstAllowedCIDR() {
        return this.allowedCIDRs.get(0);
    }

    public String getLastAllowedCIDR() {
        return this.allowedCIDRs.get(this.allowedCIDRs.size() - 1);
    }

    public String getMatchingAllowedCIDR(Predicate<String> predicate) {
        for (String item : this.allowedCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedCIDR(Predicate<String> predicate) {
        for (String item : this.allowedCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedCIDRs(List<String> allowedCIDRs) {
        if (allowedCIDRs != null) {
            this.allowedCIDRs = new ArrayList<String>();
            for (String item : allowedCIDRs) {
                this.addToAllowedCIDRs(item);
            }
        } else {
            this.allowedCIDRs = null;
        }
        return (A)this;
    }

    public A withAllowedCIDRs(String ... allowedCIDRs) {
        if (this.allowedCIDRs != null) {
            this.allowedCIDRs.clear();
            this._visitables.remove("allowedCIDRs");
        }
        if (allowedCIDRs != null) {
            for (String item : allowedCIDRs) {
                this.addToAllowedCIDRs(item);
            }
        }
        return (A)this;
    }

    public boolean hasAllowedCIDRs() {
        return this.allowedCIDRs != null && !this.allowedCIDRs.isEmpty();
    }

    public A addToRejectedCIDRs(int index, String item) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        this.rejectedCIDRs.add(index, item);
        return (A)this;
    }

    public A setToRejectedCIDRs(int index, String item) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        this.rejectedCIDRs.set(index, item);
        return (A)this;
    }

    public A addToRejectedCIDRs(String ... items) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.rejectedCIDRs.add(item);
        }
        return (A)this;
    }

    public A addAllToRejectedCIDRs(Collection<String> items) {
        if (this.rejectedCIDRs == null) {
            this.rejectedCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.rejectedCIDRs.add(item);
        }
        return (A)this;
    }

    public A removeFromRejectedCIDRs(String ... items) {
        if (this.rejectedCIDRs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.rejectedCIDRs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRejectedCIDRs(Collection<String> items) {
        if (this.rejectedCIDRs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.rejectedCIDRs.remove(item);
        }
        return (A)this;
    }

    public List<String> getRejectedCIDRs() {
        return this.rejectedCIDRs;
    }

    public String getRejectedCIDR(int index) {
        return this.rejectedCIDRs.get(index);
    }

    public String getFirstRejectedCIDR() {
        return this.rejectedCIDRs.get(0);
    }

    public String getLastRejectedCIDR() {
        return this.rejectedCIDRs.get(this.rejectedCIDRs.size() - 1);
    }

    public String getMatchingRejectedCIDR(Predicate<String> predicate) {
        for (String item : this.rejectedCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRejectedCIDR(Predicate<String> predicate) {
        for (String item : this.rejectedCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRejectedCIDRs(List<String> rejectedCIDRs) {
        if (rejectedCIDRs != null) {
            this.rejectedCIDRs = new ArrayList<String>();
            for (String item : rejectedCIDRs) {
                this.addToRejectedCIDRs(item);
            }
        } else {
            this.rejectedCIDRs = null;
        }
        return (A)this;
    }

    public A withRejectedCIDRs(String ... rejectedCIDRs) {
        if (this.rejectedCIDRs != null) {
            this.rejectedCIDRs.clear();
            this._visitables.remove("rejectedCIDRs");
        }
        if (rejectedCIDRs != null) {
            for (String item : rejectedCIDRs) {
                this.addToRejectedCIDRs(item);
            }
        }
        return (A)this;
    }

    public boolean hasRejectedCIDRs() {
        return this.rejectedCIDRs != null && !this.rejectedCIDRs.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalIPPolicyFluent that = (ExternalIPPolicyFluent)o;
        if (!Objects.equals(this.allowedCIDRs, that.allowedCIDRs)) {
            return false;
        }
        if (!Objects.equals(this.rejectedCIDRs, that.rejectedCIDRs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowedCIDRs, this.rejectedCIDRs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedCIDRs != null && !this.allowedCIDRs.isEmpty()) {
            sb.append("allowedCIDRs:");
            sb.append(String.valueOf(this.allowedCIDRs) + ",");
        }
        if (this.rejectedCIDRs != null && !this.rejectedCIDRs.isEmpty()) {
            sb.append("rejectedCIDRs:");
            sb.append(String.valueOf(this.rejectedCIDRs) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

