/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ClusterCondition;
import io.fabric8.openshift.api.model.config.v1.ClusterConditionBuilder;
import io.fabric8.openshift.api.model.config.v1.ClusterConditionFluent;
import io.fabric8.openshift.api.model.config.v1.ConditionalUpdateRisk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConditionalUpdateRiskFluent<A extends ConditionalUpdateRiskFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ClusterConditionBuilder> matchingRules = new ArrayList();
    private String message;
    private String name;
    private String url;
    private Map<String, Object> additionalProperties;

    public ConditionalUpdateRiskFluent() {
    }

    public ConditionalUpdateRiskFluent(ConditionalUpdateRisk instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConditionalUpdateRisk instance) {
        ConditionalUpdateRisk conditionalUpdateRisk = instance = instance != null ? instance : new ConditionalUpdateRisk();
        if (instance != null) {
            this.withMatchingRules(instance.getMatchingRules());
            this.withMessage(instance.getMessage());
            this.withName(instance.getName());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToMatchingRules(int index, ClusterCondition item) {
        if (this.matchingRules == null) {
            this.matchingRules = new ArrayList();
        }
        ClusterConditionBuilder builder = new ClusterConditionBuilder(item);
        if (index < 0 || index >= this.matchingRules.size()) {
            this._visitables.get("matchingRules").add(builder);
            this.matchingRules.add(builder);
        } else {
            this._visitables.get("matchingRules").add(builder);
            this.matchingRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatchingRules(int index, ClusterCondition item) {
        if (this.matchingRules == null) {
            this.matchingRules = new ArrayList();
        }
        ClusterConditionBuilder builder = new ClusterConditionBuilder(item);
        if (index < 0 || index >= this.matchingRules.size()) {
            this._visitables.get("matchingRules").add(builder);
            this.matchingRules.add(builder);
        } else {
            this._visitables.get("matchingRules").add(builder);
            this.matchingRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatchingRules(ClusterCondition ... items) {
        if (this.matchingRules == null) {
            this.matchingRules = new ArrayList();
        }
        for (ClusterCondition item : items) {
            ClusterConditionBuilder builder = new ClusterConditionBuilder(item);
            this._visitables.get("matchingRules").add(builder);
            this.matchingRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatchingRules(Collection<ClusterCondition> items) {
        if (this.matchingRules == null) {
            this.matchingRules = new ArrayList();
        }
        for (ClusterCondition item : items) {
            ClusterConditionBuilder builder = new ClusterConditionBuilder(item);
            this._visitables.get("matchingRules").add(builder);
            this.matchingRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatchingRules(ClusterCondition ... items) {
        if (this.matchingRules == null) {
            return (A)this;
        }
        for (ClusterCondition item : items) {
            ClusterConditionBuilder builder = new ClusterConditionBuilder(item);
            this._visitables.get("matchingRules").remove(builder);
            this.matchingRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatchingRules(Collection<ClusterCondition> items) {
        if (this.matchingRules == null) {
            return (A)this;
        }
        for (ClusterCondition item : items) {
            ClusterConditionBuilder builder = new ClusterConditionBuilder(item);
            this._visitables.get("matchingRules").remove(builder);
            this.matchingRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatchingRules(Predicate<ClusterConditionBuilder> predicate) {
        if (this.matchingRules == null) {
            return (A)this;
        }
        Iterator<ClusterConditionBuilder> each = this.matchingRules.iterator();
        Object visitables = this._visitables.get("matchingRules");
        while (each.hasNext()) {
            ClusterConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ClusterCondition> buildMatchingRules() {
        return this.matchingRules != null ? ConditionalUpdateRiskFluent.build(this.matchingRules) : null;
    }

    public ClusterCondition buildMatchingRule(int index) {
        return this.matchingRules.get(index).build();
    }

    public ClusterCondition buildFirstMatchingRule() {
        return this.matchingRules.get(0).build();
    }

    public ClusterCondition buildLastMatchingRule() {
        return this.matchingRules.get(this.matchingRules.size() - 1).build();
    }

    public ClusterCondition buildMatchingMatchingRule(Predicate<ClusterConditionBuilder> predicate) {
        for (ClusterConditionBuilder item : this.matchingRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchingRule(Predicate<ClusterConditionBuilder> predicate) {
        for (ClusterConditionBuilder item : this.matchingRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchingRules(List<ClusterCondition> matchingRules) {
        if (this.matchingRules != null) {
            this._visitables.get("matchingRules").clear();
        }
        if (matchingRules != null) {
            this.matchingRules = new ArrayList();
            for (ClusterCondition item : matchingRules) {
                this.addToMatchingRules(item);
            }
        } else {
            this.matchingRules = null;
        }
        return (A)this;
    }

    public A withMatchingRules(ClusterCondition ... matchingRules) {
        if (this.matchingRules != null) {
            this.matchingRules.clear();
            this._visitables.remove("matchingRules");
        }
        if (matchingRules != null) {
            for (ClusterCondition item : matchingRules) {
                this.addToMatchingRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchingRules() {
        return this.matchingRules != null && !this.matchingRules.isEmpty();
    }

    public MatchingRulesNested<A> addNewMatchingRule() {
        return new MatchingRulesNested(-1, null);
    }

    public MatchingRulesNested<A> addNewMatchingRuleLike(ClusterCondition item) {
        return new MatchingRulesNested(-1, item);
    }

    public MatchingRulesNested<A> setNewMatchingRuleLike(int index, ClusterCondition item) {
        return new MatchingRulesNested(index, item);
    }

    public MatchingRulesNested<A> editMatchingRule(int index) {
        if (this.matchingRules.size() <= index) {
            throw new RuntimeException("Can't edit matchingRules. Index exceeds size.");
        }
        return this.setNewMatchingRuleLike(index, this.buildMatchingRule(index));
    }

    public MatchingRulesNested<A> editFirstMatchingRule() {
        if (this.matchingRules.size() == 0) {
            throw new RuntimeException("Can't edit first matchingRules. The list is empty.");
        }
        return this.setNewMatchingRuleLike(0, this.buildMatchingRule(0));
    }

    public MatchingRulesNested<A> editLastMatchingRule() {
        int index = this.matchingRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchingRules. The list is empty.");
        }
        return this.setNewMatchingRuleLike(index, this.buildMatchingRule(index));
    }

    public MatchingRulesNested<A> editMatchingMatchingRule(Predicate<ClusterConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchingRules.size(); ++i) {
            if (!predicate.test(this.matchingRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchingRules. No match found.");
        }
        return this.setNewMatchingRuleLike(index, this.buildMatchingRule(index));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionalUpdateRiskFluent that = (ConditionalUpdateRiskFluent)o;
        if (!Objects.equals(this.matchingRules, that.matchingRules)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.matchingRules, this.message, this.name, this.url, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchingRules != null && !this.matchingRules.isEmpty()) {
            sb.append("matchingRules:");
            sb.append(String.valueOf(this.matchingRules) + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchingRulesNested<N>
    extends ClusterConditionFluent<MatchingRulesNested<N>>
    implements Nested<N> {
        ClusterConditionBuilder builder;
        int index;

        MatchingRulesNested(int index, ClusterCondition item) {
            this.index = index;
            this.builder = new ClusterConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConditionalUpdateRiskFluent.this.setToMatchingRules(this.index, this.builder.build());
        }

        public N endMatchingRule() {
            return this.and();
        }
    }
}

