/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BinaryBuildSourceBuilder;
import io.fabric8.openshift.api.model.BinaryBuildSourceFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.ConfigMapBuildSource;
import io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder;
import io.fabric8.openshift.api.model.ConfigMapBuildSourceFluent;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.GitBuildSourceBuilder;
import io.fabric8.openshift.api.model.GitBuildSourceFluent;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceBuilder;
import io.fabric8.openshift.api.model.ImageSourceFluent;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceBuilder;
import io.fabric8.openshift.api.model.SecretBuildSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BuildSourceFluent<A extends BuildSourceFluent<A>>
extends BaseFluent<A> {
    private BinaryBuildSourceBuilder binary;
    private ArrayList<ConfigMapBuildSourceBuilder> configMaps = new ArrayList();
    private String contextDir;
    private String dockerfile;
    private GitBuildSourceBuilder git;
    private ArrayList<ImageSourceBuilder> images = new ArrayList();
    private ArrayList<SecretBuildSourceBuilder> secrets = new ArrayList();
    private LocalObjectReferenceBuilder sourceSecret;
    private String type;
    private Map<String, Object> additionalProperties;

    public BuildSourceFluent() {
    }

    public BuildSourceFluent(BuildSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BuildSource instance) {
        BuildSource buildSource = instance = instance != null ? instance : new BuildSource();
        if (instance != null) {
            this.withBinary(instance.getBinary());
            this.withConfigMaps(instance.getConfigMaps());
            this.withContextDir(instance.getContextDir());
            this.withDockerfile(instance.getDockerfile());
            this.withGit(instance.getGit());
            this.withImages(instance.getImages());
            this.withSecrets(instance.getSecrets());
            this.withSourceSecret(instance.getSourceSecret());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BinaryBuildSource buildBinary() {
        return this.binary != null ? this.binary.build() : null;
    }

    public A withBinary(BinaryBuildSource binary) {
        this._visitables.remove("binary");
        if (binary != null) {
            this.binary = new BinaryBuildSourceBuilder(binary);
            this._visitables.get("binary").add(this.binary);
        } else {
            this.binary = null;
            this._visitables.get("binary").remove(this.binary);
        }
        return (A)this;
    }

    public boolean hasBinary() {
        return this.binary != null;
    }

    public A withNewBinary(String asFile) {
        return this.withBinary(new BinaryBuildSource(asFile));
    }

    public BinaryNested<A> withNewBinary() {
        return new BinaryNested(null);
    }

    public BinaryNested<A> withNewBinaryLike(BinaryBuildSource item) {
        return new BinaryNested(item);
    }

    public BinaryNested<A> editBinary() {
        return this.withNewBinaryLike(Optional.ofNullable(this.buildBinary()).orElse(null));
    }

    public BinaryNested<A> editOrNewBinary() {
        return this.withNewBinaryLike(Optional.ofNullable(this.buildBinary()).orElse(new BinaryBuildSourceBuilder().build()));
    }

    public BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item) {
        return this.withNewBinaryLike(Optional.ofNullable(this.buildBinary()).orElse(item));
    }

    public A addToConfigMaps(int index, ConfigMapBuildSource item) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList();
        }
        ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
        if (index < 0 || index >= this.configMaps.size()) {
            this._visitables.get("configMaps").add(builder);
            this.configMaps.add(builder);
        } else {
            this._visitables.get("configMaps").add(builder);
            this.configMaps.add(index, builder);
        }
        return (A)this;
    }

    public A setToConfigMaps(int index, ConfigMapBuildSource item) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList();
        }
        ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
        if (index < 0 || index >= this.configMaps.size()) {
            this._visitables.get("configMaps").add(builder);
            this.configMaps.add(builder);
        } else {
            this._visitables.get("configMaps").add(builder);
            this.configMaps.set(index, builder);
        }
        return (A)this;
    }

    public A addToConfigMaps(ConfigMapBuildSource ... items) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList();
        }
        for (ConfigMapBuildSource item : items) {
            ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
            this._visitables.get("configMaps").add(builder);
            this.configMaps.add(builder);
        }
        return (A)this;
    }

    public A addAllToConfigMaps(Collection<ConfigMapBuildSource> items) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList();
        }
        for (ConfigMapBuildSource item : items) {
            ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
            this._visitables.get("configMaps").add(builder);
            this.configMaps.add(builder);
        }
        return (A)this;
    }

    public A removeFromConfigMaps(ConfigMapBuildSource ... items) {
        if (this.configMaps == null) {
            return (A)this;
        }
        for (ConfigMapBuildSource item : items) {
            ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
            this._visitables.get("configMaps").remove(builder);
            this.configMaps.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConfigMaps(Collection<ConfigMapBuildSource> items) {
        if (this.configMaps == null) {
            return (A)this;
        }
        for (ConfigMapBuildSource item : items) {
            ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
            this._visitables.get("configMaps").remove(builder);
            this.configMaps.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConfigMaps(Predicate<ConfigMapBuildSourceBuilder> predicate) {
        if (this.configMaps == null) {
            return (A)this;
        }
        Iterator<ConfigMapBuildSourceBuilder> each = this.configMaps.iterator();
        Object visitables = this._visitables.get("configMaps");
        while (each.hasNext()) {
            ConfigMapBuildSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ConfigMapBuildSource> buildConfigMaps() {
        return this.configMaps != null ? BuildSourceFluent.build(this.configMaps) : null;
    }

    public ConfigMapBuildSource buildConfigMap(int index) {
        return this.configMaps.get(index).build();
    }

    public ConfigMapBuildSource buildFirstConfigMap() {
        return this.configMaps.get(0).build();
    }

    public ConfigMapBuildSource buildLastConfigMap() {
        return this.configMaps.get(this.configMaps.size() - 1).build();
    }

    public ConfigMapBuildSource buildMatchingConfigMap(Predicate<ConfigMapBuildSourceBuilder> predicate) {
        for (ConfigMapBuildSourceBuilder item : this.configMaps) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfigMap(Predicate<ConfigMapBuildSourceBuilder> predicate) {
        for (ConfigMapBuildSourceBuilder item : this.configMaps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfigMaps(List<ConfigMapBuildSource> configMaps) {
        if (this.configMaps != null) {
            this._visitables.get("configMaps").clear();
        }
        if (configMaps != null) {
            this.configMaps = new ArrayList();
            for (ConfigMapBuildSource item : configMaps) {
                this.addToConfigMaps(item);
            }
        } else {
            this.configMaps = null;
        }
        return (A)this;
    }

    public A withConfigMaps(ConfigMapBuildSource ... configMaps) {
        if (this.configMaps != null) {
            this.configMaps.clear();
            this._visitables.remove("configMaps");
        }
        if (configMaps != null) {
            for (ConfigMapBuildSource item : configMaps) {
                this.addToConfigMaps(item);
            }
        }
        return (A)this;
    }

    public boolean hasConfigMaps() {
        return this.configMaps != null && !this.configMaps.isEmpty();
    }

    public ConfigMapsNested<A> addNewConfigMap() {
        return new ConfigMapsNested(-1, null);
    }

    public ConfigMapsNested<A> addNewConfigMapLike(ConfigMapBuildSource item) {
        return new ConfigMapsNested(-1, item);
    }

    public ConfigMapsNested<A> setNewConfigMapLike(int index, ConfigMapBuildSource item) {
        return new ConfigMapsNested(index, item);
    }

    public ConfigMapsNested<A> editConfigMap(int index) {
        if (this.configMaps.size() <= index) {
            throw new RuntimeException("Can't edit configMaps. Index exceeds size.");
        }
        return this.setNewConfigMapLike(index, this.buildConfigMap(index));
    }

    public ConfigMapsNested<A> editFirstConfigMap() {
        if (this.configMaps.size() == 0) {
            throw new RuntimeException("Can't edit first configMaps. The list is empty.");
        }
        return this.setNewConfigMapLike(0, this.buildConfigMap(0));
    }

    public ConfigMapsNested<A> editLastConfigMap() {
        int index = this.configMaps.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configMaps. The list is empty.");
        }
        return this.setNewConfigMapLike(index, this.buildConfigMap(index));
    }

    public ConfigMapsNested<A> editMatchingConfigMap(Predicate<ConfigMapBuildSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configMaps.size(); ++i) {
            if (!predicate.test(this.configMaps.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configMaps. No match found.");
        }
        return this.setNewConfigMapLike(index, this.buildConfigMap(index));
    }

    public String getContextDir() {
        return this.contextDir;
    }

    public A withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (A)this;
    }

    public boolean hasContextDir() {
        return this.contextDir != null;
    }

    public String getDockerfile() {
        return this.dockerfile;
    }

    public A withDockerfile(String dockerfile) {
        this.dockerfile = dockerfile;
        return (A)this;
    }

    public boolean hasDockerfile() {
        return this.dockerfile != null;
    }

    public GitBuildSource buildGit() {
        return this.git != null ? this.git.build() : null;
    }

    public A withGit(GitBuildSource git) {
        this._visitables.remove("git");
        if (git != null) {
            this.git = new GitBuildSourceBuilder(git);
            this._visitables.get("git").add(this.git);
        } else {
            this.git = null;
            this._visitables.get("git").remove(this.git);
        }
        return (A)this;
    }

    public boolean hasGit() {
        return this.git != null;
    }

    public A withNewGit(String httpProxy, String httpsProxy, String noProxy, String ref, String uri) {
        return this.withGit(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
    }

    public GitNested<A> withNewGit() {
        return new GitNested(null);
    }

    public GitNested<A> withNewGitLike(GitBuildSource item) {
        return new GitNested(item);
    }

    public GitNested<A> editGit() {
        return this.withNewGitLike(Optional.ofNullable(this.buildGit()).orElse(null));
    }

    public GitNested<A> editOrNewGit() {
        return this.withNewGitLike(Optional.ofNullable(this.buildGit()).orElse(new GitBuildSourceBuilder().build()));
    }

    public GitNested<A> editOrNewGitLike(GitBuildSource item) {
        return this.withNewGitLike(Optional.ofNullable(this.buildGit()).orElse(item));
    }

    public A addToImages(int index, ImageSource item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ImageSourceBuilder builder = new ImageSourceBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get("images").add(builder);
            this.images.add(index, builder);
        }
        return (A)this;
    }

    public A setToImages(int index, ImageSource item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ImageSourceBuilder builder = new ImageSourceBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get("images").add(builder);
            this.images.set(index, builder);
        }
        return (A)this;
    }

    public A addToImages(ImageSource ... items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    public A addAllToImages(Collection<ImageSource> items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    public A removeFromImages(ImageSource ... items) {
        if (this.images == null) {
            return (A)this;
        }
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.get("images").remove(builder);
            this.images.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromImages(Collection<ImageSource> items) {
        if (this.images == null) {
            return (A)this;
        }
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.get("images").remove(builder);
            this.images.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromImages(Predicate<ImageSourceBuilder> predicate) {
        if (this.images == null) {
            return (A)this;
        }
        Iterator<ImageSourceBuilder> each = this.images.iterator();
        Object visitables = this._visitables.get("images");
        while (each.hasNext()) {
            ImageSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ImageSource> buildImages() {
        return this.images != null ? BuildSourceFluent.build(this.images) : null;
    }

    public ImageSource buildImage(int index) {
        return this.images.get(index).build();
    }

    public ImageSource buildFirstImage() {
        return this.images.get(0).build();
    }

    public ImageSource buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    public ImageSource buildMatchingImage(Predicate<ImageSourceBuilder> predicate) {
        for (ImageSourceBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImage(Predicate<ImageSourceBuilder> predicate) {
        for (ImageSourceBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImages(List<ImageSource> images) {
        if (this.images != null) {
            this._visitables.get("images").clear();
        }
        if (images != null) {
            this.images = new ArrayList();
            for (ImageSource item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)this;
    }

    public A withImages(ImageSource ... images) {
        if (this.images != null) {
            this.images.clear();
            this._visitables.remove("images");
        }
        if (images != null) {
            for (ImageSource item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    public boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    public ImagesNested<A> addNewImage() {
        return new ImagesNested(-1, null);
    }

    public ImagesNested<A> addNewImageLike(ImageSource item) {
        return new ImagesNested(-1, item);
    }

    public ImagesNested<A> setNewImageLike(int index, ImageSource item) {
        return new ImagesNested(index, item);
    }

    public ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    public ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public ImagesNested<A> editMatchingImage(Predicate<ImageSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.test(this.images.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public A addToSecrets(int index, SecretBuildSource item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(index, builder);
        }
        return (A)this;
    }

    public A setToSecrets(int index, SecretBuildSource item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get("secrets").add(builder);
            this.secrets.set(index, builder);
        }
        return (A)this;
    }

    public A addToSecrets(SecretBuildSource ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    public A addAllToSecrets(Collection<SecretBuildSource> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    public A removeFromSecrets(SecretBuildSource ... items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.get("secrets").remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSecrets(Collection<SecretBuildSource> items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.get("secrets").remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSecrets(Predicate<SecretBuildSourceBuilder> predicate) {
        if (this.secrets == null) {
            return (A)this;
        }
        Iterator<SecretBuildSourceBuilder> each = this.secrets.iterator();
        Object visitables = this._visitables.get("secrets");
        while (each.hasNext()) {
            SecretBuildSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SecretBuildSource> buildSecrets() {
        return this.secrets != null ? BuildSourceFluent.build(this.secrets) : null;
    }

    public SecretBuildSource buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    public SecretBuildSource buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    public SecretBuildSource buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    public SecretBuildSource buildMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
        for (SecretBuildSourceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
        for (SecretBuildSourceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecrets(List<SecretBuildSource> secrets) {
        if (this.secrets != null) {
            this._visitables.get("secrets").clear();
        }
        if (secrets != null) {
            this.secrets = new ArrayList();
            for (SecretBuildSource item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    public A withSecrets(SecretBuildSource ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove("secrets");
        }
        if (secrets != null) {
            for (SecretBuildSource item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    public boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    public SecretsNested<A> addNewSecret() {
        return new SecretsNested(-1, null);
    }

    public SecretsNested<A> addNewSecretLike(SecretBuildSource item) {
        return new SecretsNested(-1, item);
    }

    public SecretsNested<A> setNewSecretLike(int index, SecretBuildSource item) {
        return new SecretsNested(index, item);
    }

    public SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    public SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public SecretsNested<A> editMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.test(this.secrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public LocalObjectReference buildSourceSecret() {
        return this.sourceSecret != null ? this.sourceSecret.build() : null;
    }

    public A withSourceSecret(LocalObjectReference sourceSecret) {
        this._visitables.remove("sourceSecret");
        if (sourceSecret != null) {
            this.sourceSecret = new LocalObjectReferenceBuilder(sourceSecret);
            this._visitables.get("sourceSecret").add(this.sourceSecret);
        } else {
            this.sourceSecret = null;
            this._visitables.get("sourceSecret").remove(this.sourceSecret);
        }
        return (A)this;
    }

    public boolean hasSourceSecret() {
        return this.sourceSecret != null;
    }

    public A withNewSourceSecret(String name) {
        return this.withSourceSecret(new LocalObjectReference(name));
    }

    public SourceSecretNested<A> withNewSourceSecret() {
        return new SourceSecretNested(null);
    }

    public SourceSecretNested<A> withNewSourceSecretLike(LocalObjectReference item) {
        return new SourceSecretNested(item);
    }

    public SourceSecretNested<A> editSourceSecret() {
        return this.withNewSourceSecretLike(Optional.ofNullable(this.buildSourceSecret()).orElse(null));
    }

    public SourceSecretNested<A> editOrNewSourceSecret() {
        return this.withNewSourceSecretLike(Optional.ofNullable(this.buildSourceSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public SourceSecretNested<A> editOrNewSourceSecretLike(LocalObjectReference item) {
        return this.withNewSourceSecretLike(Optional.ofNullable(this.buildSourceSecret()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSourceFluent that = (BuildSourceFluent)o;
        if (!Objects.equals(this.binary, that.binary)) {
            return false;
        }
        if (!Objects.equals(this.configMaps, that.configMaps)) {
            return false;
        }
        if (!Objects.equals(this.contextDir, that.contextDir)) {
            return false;
        }
        if (!Objects.equals(this.dockerfile, that.dockerfile)) {
            return false;
        }
        if (!Objects.equals(this.git, that.git)) {
            return false;
        }
        if (!Objects.equals(this.images, that.images)) {
            return false;
        }
        if (!Objects.equals(this.secrets, that.secrets)) {
            return false;
        }
        if (!Objects.equals(this.sourceSecret, that.sourceSecret)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.binary, this.configMaps, this.contextDir, this.dockerfile, this.git, this.images, this.secrets, this.sourceSecret, this.type, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.binary != null) {
            sb.append("binary:");
            sb.append(String.valueOf(this.binary) + ",");
        }
        if (this.configMaps != null && !this.configMaps.isEmpty()) {
            sb.append("configMaps:");
            sb.append(String.valueOf(this.configMaps) + ",");
        }
        if (this.contextDir != null) {
            sb.append("contextDir:");
            sb.append(this.contextDir + ",");
        }
        if (this.dockerfile != null) {
            sb.append("dockerfile:");
            sb.append(this.dockerfile + ",");
        }
        if (this.git != null) {
            sb.append("git:");
            sb.append(String.valueOf(this.git) + ",");
        }
        if (this.images != null && !this.images.isEmpty()) {
            sb.append("images:");
            sb.append(String.valueOf(this.images) + ",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(String.valueOf(this.secrets) + ",");
        }
        if (this.sourceSecret != null) {
            sb.append("sourceSecret:");
            sb.append(String.valueOf(this.sourceSecret) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SourceSecretNested<N>
    extends LocalObjectReferenceFluent<SourceSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        SourceSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluent.this.withSourceSecret(this.builder.build());
        }

        public N endSourceSecret() {
            return this.and();
        }
    }

    public class SecretsNested<N>
    extends SecretBuildSourceFluent<SecretsNested<N>>
    implements Nested<N> {
        SecretBuildSourceBuilder builder;
        int index;

        SecretsNested(int index, SecretBuildSource item) {
            this.index = index;
            this.builder = new SecretBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluent.this.setToSecrets(this.index, this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }

    public class ImagesNested<N>
    extends ImageSourceFluent<ImagesNested<N>>
    implements Nested<N> {
        ImageSourceBuilder builder;
        int index;

        ImagesNested(int index, ImageSource item) {
            this.index = index;
            this.builder = new ImageSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluent.this.setToImages(this.index, this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }

    public class GitNested<N>
    extends GitBuildSourceFluent<GitNested<N>>
    implements Nested<N> {
        GitBuildSourceBuilder builder;

        GitNested(GitBuildSource item) {
            this.builder = new GitBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluent.this.withGit(this.builder.build());
        }

        public N endGit() {
            return this.and();
        }
    }

    public class ConfigMapsNested<N>
    extends ConfigMapBuildSourceFluent<ConfigMapsNested<N>>
    implements Nested<N> {
        ConfigMapBuildSourceBuilder builder;
        int index;

        ConfigMapsNested(int index, ConfigMapBuildSource item) {
            this.index = index;
            this.builder = new ConfigMapBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluent.this.setToConfigMaps(this.index, this.builder.build());
        }

        public N endConfigMap() {
            return this.and();
        }
    }

    public class BinaryNested<N>
    extends BinaryBuildSourceFluent<BinaryNested<N>>
    implements Nested<N> {
        BinaryBuildSourceBuilder builder;

        BinaryNested(BinaryBuildSource item) {
            this.builder = new BinaryBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluent.this.withBinary(this.builder.build());
        }

        public N endBinary() {
            return this.and();
        }
    }
}

