/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSelector;
import io.fabric8.kubernetes.api.model.resource.v1beta1.BasicDevice;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceAttribute;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceCapacity;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceCounterConsumption;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceCounterConsumptionBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceCounterConsumptionFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceTaint;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceTaintBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceTaintFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BasicDeviceFluent<A extends BasicDeviceFluent<A>>
extends BaseFluent<A> {
    private Boolean allNodes;
    private Map<String, DeviceAttribute> attributes;
    private Map<String, DeviceCapacity> capacity;
    private ArrayList<DeviceCounterConsumptionBuilder> consumesCounters = new ArrayList();
    private String nodeName;
    private NodeSelector nodeSelector;
    private ArrayList<DeviceTaintBuilder> taints = new ArrayList();
    private Map<String, Object> additionalProperties;

    public BasicDeviceFluent() {
    }

    public BasicDeviceFluent(BasicDevice instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BasicDevice instance) {
        BasicDevice basicDevice = instance = instance != null ? instance : new BasicDevice();
        if (instance != null) {
            this.withAllNodes(instance.getAllNodes());
            this.withAttributes(instance.getAttributes());
            this.withCapacity(instance.getCapacity());
            this.withConsumesCounters(instance.getConsumesCounters());
            this.withNodeName(instance.getNodeName());
            this.withNodeSelector(instance.getNodeSelector());
            this.withTaints(instance.getTaints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public A withAllNodes(Boolean allNodes) {
        this.allNodes = allNodes;
        return (A)this;
    }

    public boolean hasAllNodes() {
        return this.allNodes != null;
    }

    public A addToAttributes(String key, DeviceAttribute value) {
        if (this.attributes == null && key != null && value != null) {
            this.attributes = new LinkedHashMap<String, DeviceAttribute>();
        }
        if (key != null && value != null) {
            this.attributes.put(key, value);
        }
        return (A)this;
    }

    public A addToAttributes(Map<String, DeviceAttribute> map) {
        if (this.attributes == null && map != null) {
            this.attributes = new LinkedHashMap<String, DeviceAttribute>();
        }
        if (map != null) {
            this.attributes.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAttributes(String key) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (key != null && this.attributes != null) {
            this.attributes.remove(key);
        }
        return (A)this;
    }

    public A removeFromAttributes(Map<String, DeviceAttribute> map) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.attributes == null) continue;
                this.attributes.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, DeviceAttribute> getAttributes() {
        return this.attributes;
    }

    public <K, V> A withAttributes(Map<String, DeviceAttribute> attributes) {
        this.attributes = attributes == null ? null : new LinkedHashMap<String, DeviceAttribute>(attributes);
        return (A)this;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public A addToCapacity(String key, DeviceCapacity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, DeviceCapacity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    public A addToCapacity(Map<String, DeviceCapacity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, DeviceCapacity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    public A removeFromCapacity(Map<String, DeviceCapacity> map) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, DeviceCapacity> getCapacity() {
        return this.capacity;
    }

    public <K, V> A withCapacity(Map<String, DeviceCapacity> capacity) {
        this.capacity = capacity == null ? null : new LinkedHashMap<String, DeviceCapacity>(capacity);
        return (A)this;
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public A addToConsumesCounters(int index, DeviceCounterConsumption item) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
        if (index < 0 || index >= this.consumesCounters.size()) {
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        } else {
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.add(index, builder);
        }
        return (A)this;
    }

    public A setToConsumesCounters(int index, DeviceCounterConsumption item) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
        if (index < 0 || index >= this.consumesCounters.size()) {
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        } else {
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.set(index, builder);
        }
        return (A)this;
    }

    public A addToConsumesCounters(DeviceCounterConsumption ... items) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        for (DeviceCounterConsumption item : items) {
            DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        }
        return (A)this;
    }

    public A addAllToConsumesCounters(Collection<DeviceCounterConsumption> items) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        for (DeviceCounterConsumption item : items) {
            DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        }
        return (A)this;
    }

    public A removeFromConsumesCounters(DeviceCounterConsumption ... items) {
        if (this.consumesCounters == null) {
            return (A)this;
        }
        for (DeviceCounterConsumption item : items) {
            DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
            this._visitables.get("consumesCounters").remove(builder);
            this.consumesCounters.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConsumesCounters(Collection<DeviceCounterConsumption> items) {
        if (this.consumesCounters == null) {
            return (A)this;
        }
        for (DeviceCounterConsumption item : items) {
            DeviceCounterConsumptionBuilder builder = new DeviceCounterConsumptionBuilder(item);
            this._visitables.get("consumesCounters").remove(builder);
            this.consumesCounters.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConsumesCounters(Predicate<DeviceCounterConsumptionBuilder> predicate) {
        if (this.consumesCounters == null) {
            return (A)this;
        }
        Iterator<DeviceCounterConsumptionBuilder> each = this.consumesCounters.iterator();
        Object visitables = this._visitables.get("consumesCounters");
        while (each.hasNext()) {
            DeviceCounterConsumptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DeviceCounterConsumption> buildConsumesCounters() {
        return this.consumesCounters != null ? BasicDeviceFluent.build(this.consumesCounters) : null;
    }

    public DeviceCounterConsumption buildConsumesCounter(int index) {
        return this.consumesCounters.get(index).build();
    }

    public DeviceCounterConsumption buildFirstConsumesCounter() {
        return this.consumesCounters.get(0).build();
    }

    public DeviceCounterConsumption buildLastConsumesCounter() {
        return this.consumesCounters.get(this.consumesCounters.size() - 1).build();
    }

    public DeviceCounterConsumption buildMatchingConsumesCounter(Predicate<DeviceCounterConsumptionBuilder> predicate) {
        for (DeviceCounterConsumptionBuilder item : this.consumesCounters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConsumesCounter(Predicate<DeviceCounterConsumptionBuilder> predicate) {
        for (DeviceCounterConsumptionBuilder item : this.consumesCounters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConsumesCounters(List<DeviceCounterConsumption> consumesCounters) {
        if (this.consumesCounters != null) {
            this._visitables.get("consumesCounters").clear();
        }
        if (consumesCounters != null) {
            this.consumesCounters = new ArrayList();
            for (DeviceCounterConsumption item : consumesCounters) {
                this.addToConsumesCounters(item);
            }
        } else {
            this.consumesCounters = null;
        }
        return (A)this;
    }

    public A withConsumesCounters(DeviceCounterConsumption ... consumesCounters) {
        if (this.consumesCounters != null) {
            this.consumesCounters.clear();
            this._visitables.remove("consumesCounters");
        }
        if (consumesCounters != null) {
            for (DeviceCounterConsumption item : consumesCounters) {
                this.addToConsumesCounters(item);
            }
        }
        return (A)this;
    }

    public boolean hasConsumesCounters() {
        return this.consumesCounters != null && !this.consumesCounters.isEmpty();
    }

    public ConsumesCountersNested<A> addNewConsumesCounter() {
        return new ConsumesCountersNested(-1, null);
    }

    public ConsumesCountersNested<A> addNewConsumesCounterLike(DeviceCounterConsumption item) {
        return new ConsumesCountersNested(-1, item);
    }

    public ConsumesCountersNested<A> setNewConsumesCounterLike(int index, DeviceCounterConsumption item) {
        return new ConsumesCountersNested(index, item);
    }

    public ConsumesCountersNested<A> editConsumesCounter(int index) {
        if (this.consumesCounters.size() <= index) {
            throw new RuntimeException("Can't edit consumesCounters. Index exceeds size.");
        }
        return this.setNewConsumesCounterLike(index, this.buildConsumesCounter(index));
    }

    public ConsumesCountersNested<A> editFirstConsumesCounter() {
        if (this.consumesCounters.size() == 0) {
            throw new RuntimeException("Can't edit first consumesCounters. The list is empty.");
        }
        return this.setNewConsumesCounterLike(0, this.buildConsumesCounter(0));
    }

    public ConsumesCountersNested<A> editLastConsumesCounter() {
        int index = this.consumesCounters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last consumesCounters. The list is empty.");
        }
        return this.setNewConsumesCounterLike(index, this.buildConsumesCounter(index));
    }

    public ConsumesCountersNested<A> editMatchingConsumesCounter(Predicate<DeviceCounterConsumptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.consumesCounters.size(); ++i) {
            if (!predicate.test(this.consumesCounters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching consumesCounters. No match found.");
        }
        return this.setNewConsumesCounterLike(index, this.buildConsumesCounter(index));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public A withNodeSelector(NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return (A)this;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public A addToTaints(int index, DeviceTaint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get("taints").add(builder);
            this.taints.add(index, builder);
        }
        return (A)this;
    }

    public A setToTaints(int index, DeviceTaint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get("taints").add(builder);
            this.taints.set(index, builder);
        }
        return (A)this;
    }

    public A addToTaints(DeviceTaint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (DeviceTaint item : items) {
            DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    public A addAllToTaints(Collection<DeviceTaint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (DeviceTaint item : items) {
            DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    public A removeFromTaints(DeviceTaint ... items) {
        if (this.taints == null) {
            return (A)this;
        }
        for (DeviceTaint item : items) {
            DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            this.taints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTaints(Collection<DeviceTaint> items) {
        if (this.taints == null) {
            return (A)this;
        }
        for (DeviceTaint item : items) {
            DeviceTaintBuilder builder = new DeviceTaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            this.taints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTaints(Predicate<DeviceTaintBuilder> predicate) {
        if (this.taints == null) {
            return (A)this;
        }
        Iterator<DeviceTaintBuilder> each = this.taints.iterator();
        Object visitables = this._visitables.get("taints");
        while (each.hasNext()) {
            DeviceTaintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DeviceTaint> buildTaints() {
        return this.taints != null ? BasicDeviceFluent.build(this.taints) : null;
    }

    public DeviceTaint buildTaint(int index) {
        return this.taints.get(index).build();
    }

    public DeviceTaint buildFirstTaint() {
        return this.taints.get(0).build();
    }

    public DeviceTaint buildLastTaint() {
        return this.taints.get(this.taints.size() - 1).build();
    }

    public DeviceTaint buildMatchingTaint(Predicate<DeviceTaintBuilder> predicate) {
        for (DeviceTaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTaint(Predicate<DeviceTaintBuilder> predicate) {
        for (DeviceTaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTaints(List<DeviceTaint> taints) {
        if (this.taints != null) {
            this._visitables.get("taints").clear();
        }
        if (taints != null) {
            this.taints = new ArrayList();
            for (DeviceTaint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)this;
    }

    public A withTaints(DeviceTaint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
            this._visitables.remove("taints");
        }
        if (taints != null) {
            for (DeviceTaint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)this;
    }

    public boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    public A addNewTaint(String effect, String key, String timeAdded, String value) {
        return this.addToTaints(new DeviceTaint(effect, key, timeAdded, value));
    }

    public TaintsNested<A> addNewTaint() {
        return new TaintsNested(-1, null);
    }

    public TaintsNested<A> addNewTaintLike(DeviceTaint item) {
        return new TaintsNested(-1, item);
    }

    public TaintsNested<A> setNewTaintLike(int index, DeviceTaint item) {
        return new TaintsNested(index, item);
    }

    public TaintsNested<A> editTaint(int index) {
        if (this.taints.size() <= index) {
            throw new RuntimeException("Can't edit taints. Index exceeds size.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public TaintsNested<A> editFirstTaint() {
        if (this.taints.size() == 0) {
            throw new RuntimeException("Can't edit first taints. The list is empty.");
        }
        return this.setNewTaintLike(0, this.buildTaint(0));
    }

    public TaintsNested<A> editLastTaint() {
        int index = this.taints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last taints. The list is empty.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public TaintsNested<A> editMatchingTaint(Predicate<DeviceTaintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.taints.size(); ++i) {
            if (!predicate.test(this.taints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching taints. No match found.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasicDeviceFluent that = (BasicDeviceFluent)o;
        if (!Objects.equals(this.allNodes, that.allNodes)) {
            return false;
        }
        if (!Objects.equals(this.attributes, that.attributes)) {
            return false;
        }
        if (!Objects.equals(this.capacity, that.capacity)) {
            return false;
        }
        if (!Objects.equals(this.consumesCounters, that.consumesCounters)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.taints, that.taints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allNodes, this.attributes, this.capacity, this.consumesCounters, this.nodeName, this.nodeSelector, this.taints, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allNodes != null) {
            sb.append("allNodes:");
            sb.append(this.allNodes + ",");
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append("attributes:");
            sb.append(String.valueOf(this.attributes) + ",");
        }
        if (this.capacity != null && !this.capacity.isEmpty()) {
            sb.append("capacity:");
            sb.append(String.valueOf(this.capacity) + ",");
        }
        if (this.consumesCounters != null && !this.consumesCounters.isEmpty()) {
            sb.append("consumesCounters:");
            sb.append(String.valueOf(this.consumesCounters) + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append(String.valueOf(this.nodeSelector) + ",");
        }
        if (this.taints != null && !this.taints.isEmpty()) {
            sb.append("taints:");
            sb.append(String.valueOf(this.taints) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllNodes() {
        return this.withAllNodes(true);
    }

    public class TaintsNested<N>
    extends DeviceTaintFluent<TaintsNested<N>>
    implements Nested<N> {
        DeviceTaintBuilder builder;
        int index;

        TaintsNested(int index, DeviceTaint item) {
            this.index = index;
            this.builder = new DeviceTaintBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BasicDeviceFluent.this.setToTaints(this.index, this.builder.build());
        }

        public N endTaint() {
            return this.and();
        }
    }

    public class ConsumesCountersNested<N>
    extends DeviceCounterConsumptionFluent<ConsumesCountersNested<N>>
    implements Nested<N> {
        DeviceCounterConsumptionBuilder builder;
        int index;

        ConsumesCountersNested(int index, DeviceCounterConsumption item) {
            this.index = index;
            this.builder = new DeviceCounterConsumptionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BasicDeviceFluent.this.setToConsumesCounters(this.index, this.builder.build());
        }

        public N endConsumesCounter() {
            return this.and();
        }
    }
}

