/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.AllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.AllocationResultBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.AllocationResultFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimConsumerReference;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimConsumerReferenceBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimConsumerReferenceFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ResourceClaimStatusFluent<A extends ResourceClaimStatusFluent<A>>
extends BaseFluent<A> {
    private AllocationResultBuilder allocation;
    private Boolean deallocationRequested;
    private String driverName;
    private ArrayList<ResourceClaimConsumerReferenceBuilder> reservedFor = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ResourceClaimStatusFluent() {
    }

    public ResourceClaimStatusFluent(ResourceClaimStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceClaimStatus instance) {
        ResourceClaimStatus resourceClaimStatus = instance = instance != null ? instance : new ResourceClaimStatus();
        if (instance != null) {
            this.withAllocation(instance.getAllocation());
            this.withDeallocationRequested(instance.getDeallocationRequested());
            this.withDriverName(instance.getDriverName());
            this.withReservedFor(instance.getReservedFor());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AllocationResult buildAllocation() {
        return this.allocation != null ? this.allocation.build() : null;
    }

    public A withAllocation(AllocationResult allocation) {
        this._visitables.remove("allocation");
        if (allocation != null) {
            this.allocation = new AllocationResultBuilder(allocation);
            this._visitables.get("allocation").add(this.allocation);
        } else {
            this.allocation = null;
            this._visitables.get("allocation").remove(this.allocation);
        }
        return (A)this;
    }

    public boolean hasAllocation() {
        return this.allocation != null;
    }

    public AllocationNested<A> withNewAllocation() {
        return new AllocationNested(null);
    }

    public AllocationNested<A> withNewAllocationLike(AllocationResult item) {
        return new AllocationNested(item);
    }

    public AllocationNested<A> editAllocation() {
        return this.withNewAllocationLike(Optional.ofNullable(this.buildAllocation()).orElse(null));
    }

    public AllocationNested<A> editOrNewAllocation() {
        return this.withNewAllocationLike(Optional.ofNullable(this.buildAllocation()).orElse(new AllocationResultBuilder().build()));
    }

    public AllocationNested<A> editOrNewAllocationLike(AllocationResult item) {
        return this.withNewAllocationLike(Optional.ofNullable(this.buildAllocation()).orElse(item));
    }

    public Boolean getDeallocationRequested() {
        return this.deallocationRequested;
    }

    public A withDeallocationRequested(Boolean deallocationRequested) {
        this.deallocationRequested = deallocationRequested;
        return (A)this;
    }

    public boolean hasDeallocationRequested() {
        return this.deallocationRequested != null;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    public boolean hasDriverName() {
        return this.driverName != null;
    }

    public A addToReservedFor(int index, ResourceClaimConsumerReference item) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
        if (index < 0 || index >= this.reservedFor.size()) {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        } else {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(index, builder);
        }
        return (A)this;
    }

    public A setToReservedFor(int index, ResourceClaimConsumerReference item) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
        if (index < 0 || index >= this.reservedFor.size()) {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        } else {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.set(index, builder);
        }
        return (A)this;
    }

    public A addToReservedFor(ResourceClaimConsumerReference ... items) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        for (ResourceClaimConsumerReference item : items) {
            ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        }
        return (A)this;
    }

    public A addAllToReservedFor(Collection<ResourceClaimConsumerReference> items) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        for (ResourceClaimConsumerReference item : items) {
            ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        }
        return (A)this;
    }

    public A removeFromReservedFor(ResourceClaimConsumerReference ... items) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        for (ResourceClaimConsumerReference item : items) {
            ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").remove(builder);
            this.reservedFor.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromReservedFor(Collection<ResourceClaimConsumerReference> items) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        for (ResourceClaimConsumerReference item : items) {
            ResourceClaimConsumerReferenceBuilder builder = new ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").remove(builder);
            this.reservedFor.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        Iterator<ResourceClaimConsumerReferenceBuilder> each = this.reservedFor.iterator();
        Object visitables = this._visitables.get("reservedFor");
        while (each.hasNext()) {
            ResourceClaimConsumerReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ResourceClaimConsumerReference> buildReservedFor() {
        return this.reservedFor != null ? ResourceClaimStatusFluent.build(this.reservedFor) : null;
    }

    public ResourceClaimConsumerReference buildReservedFor(int index) {
        return this.reservedFor.get(index).build();
    }

    public ResourceClaimConsumerReference buildFirstReservedFor() {
        return this.reservedFor.get(0).build();
    }

    public ResourceClaimConsumerReference buildLastReservedFor() {
        return this.reservedFor.get(this.reservedFor.size() - 1).build();
    }

    public ResourceClaimConsumerReference buildMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
        for (ResourceClaimConsumerReferenceBuilder item : this.reservedFor) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
        for (ResourceClaimConsumerReferenceBuilder item : this.reservedFor) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withReservedFor(List<ResourceClaimConsumerReference> reservedFor) {
        if (this.reservedFor != null) {
            this._visitables.get("reservedFor").clear();
        }
        if (reservedFor != null) {
            this.reservedFor = new ArrayList();
            for (ResourceClaimConsumerReference item : reservedFor) {
                this.addToReservedFor(item);
            }
        } else {
            this.reservedFor = null;
        }
        return (A)this;
    }

    public A withReservedFor(ResourceClaimConsumerReference ... reservedFor) {
        if (this.reservedFor != null) {
            this.reservedFor.clear();
            this._visitables.remove("reservedFor");
        }
        if (reservedFor != null) {
            for (ResourceClaimConsumerReference item : reservedFor) {
                this.addToReservedFor(item);
            }
        }
        return (A)this;
    }

    public boolean hasReservedFor() {
        return this.reservedFor != null && !this.reservedFor.isEmpty();
    }

    public A addNewReservedFor(String apiGroup, String name, String resource, String uid) {
        return this.addToReservedFor(new ResourceClaimConsumerReference(apiGroup, name, resource, uid));
    }

    public ReservedForNested<A> addNewReservedFor() {
        return new ReservedForNested(-1, null);
    }

    public ReservedForNested<A> addNewReservedForLike(ResourceClaimConsumerReference item) {
        return new ReservedForNested(-1, item);
    }

    public ReservedForNested<A> setNewReservedForLike(int index, ResourceClaimConsumerReference item) {
        return new ReservedForNested(index, item);
    }

    public ReservedForNested<A> editReservedFor(int index) {
        if (this.reservedFor.size() <= index) {
            throw new RuntimeException("Can't edit reservedFor. Index exceeds size.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    public ReservedForNested<A> editFirstReservedFor() {
        if (this.reservedFor.size() == 0) {
            throw new RuntimeException("Can't edit first reservedFor. The list is empty.");
        }
        return this.setNewReservedForLike(0, this.buildReservedFor(0));
    }

    public ReservedForNested<A> editLastReservedFor() {
        int index = this.reservedFor.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last reservedFor. The list is empty.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    public ReservedForNested<A> editMatchingReservedFor(Predicate<ResourceClaimConsumerReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.reservedFor.size(); ++i) {
            if (!predicate.test(this.reservedFor.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching reservedFor. No match found.");
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceClaimStatusFluent that = (ResourceClaimStatusFluent)o;
        if (!Objects.equals(this.allocation, that.allocation)) {
            return false;
        }
        if (!Objects.equals(this.deallocationRequested, that.deallocationRequested)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.reservedFor, that.reservedFor)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocation, this.deallocationRequested, this.driverName, this.reservedFor, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocation != null) {
            sb.append("allocation:");
            sb.append(String.valueOf(this.allocation) + ",");
        }
        if (this.deallocationRequested != null) {
            sb.append("deallocationRequested:");
            sb.append(this.deallocationRequested + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.reservedFor != null && !this.reservedFor.isEmpty()) {
            sb.append("reservedFor:");
            sb.append(String.valueOf(this.reservedFor) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDeallocationRequested() {
        return this.withDeallocationRequested(true);
    }

    public class ReservedForNested<N>
    extends ResourceClaimConsumerReferenceFluent<ReservedForNested<N>>
    implements Nested<N> {
        ResourceClaimConsumerReferenceBuilder builder;
        int index;

        ReservedForNested(int index, ResourceClaimConsumerReference item) {
            this.index = index;
            this.builder = new ResourceClaimConsumerReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceClaimStatusFluent.this.setToReservedFor(this.index, this.builder.build());
        }

        public N endReservedFor() {
            return this.and();
        }
    }

    public class AllocationNested<N>
    extends AllocationResultFluent<AllocationNested<N>>
    implements Nested<N> {
        AllocationResultBuilder builder;

        AllocationNested(AllocationResult item) {
            this.builder = new AllocationResultBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceClaimStatusFluent.this.withAllocation(this.builder.build());
        }

        public N endAllocation() {
            return this.and();
        }
    }
}

