/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.coordination.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.model.coordination.v1beta1.LeaseCandidateSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class LeaseCandidateSpecFluent<A extends LeaseCandidateSpecFluent<A>>
extends BaseFluent<A> {
    private String binaryVersion;
    private String emulationVersion;
    private String leaseName;
    private MicroTime pingTime;
    private MicroTime renewTime;
    private String strategy;
    private Map<String, Object> additionalProperties;

    public LeaseCandidateSpecFluent() {
    }

    public LeaseCandidateSpecFluent(LeaseCandidateSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LeaseCandidateSpec instance) {
        LeaseCandidateSpec leaseCandidateSpec = instance = instance != null ? instance : new LeaseCandidateSpec();
        if (instance != null) {
            this.withBinaryVersion(instance.getBinaryVersion());
            this.withEmulationVersion(instance.getEmulationVersion());
            this.withLeaseName(instance.getLeaseName());
            this.withPingTime(instance.getPingTime());
            this.withRenewTime(instance.getRenewTime());
            this.withStrategy(instance.getStrategy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBinaryVersion() {
        return this.binaryVersion;
    }

    public A withBinaryVersion(String binaryVersion) {
        this.binaryVersion = binaryVersion;
        return (A)this;
    }

    public boolean hasBinaryVersion() {
        return this.binaryVersion != null;
    }

    public String getEmulationVersion() {
        return this.emulationVersion;
    }

    public A withEmulationVersion(String emulationVersion) {
        this.emulationVersion = emulationVersion;
        return (A)this;
    }

    public boolean hasEmulationVersion() {
        return this.emulationVersion != null;
    }

    public String getLeaseName() {
        return this.leaseName;
    }

    public A withLeaseName(String leaseName) {
        this.leaseName = leaseName;
        return (A)this;
    }

    public boolean hasLeaseName() {
        return this.leaseName != null;
    }

    public MicroTime getPingTime() {
        return this.pingTime;
    }

    public A withPingTime(MicroTime pingTime) {
        this.pingTime = pingTime;
        return (A)this;
    }

    public boolean hasPingTime() {
        return this.pingTime != null;
    }

    public A withNewPingTime(String time) {
        return this.withPingTime(new MicroTime(time));
    }

    public MicroTime getRenewTime() {
        return this.renewTime;
    }

    public A withRenewTime(MicroTime renewTime) {
        this.renewTime = renewTime;
        return (A)this;
    }

    public boolean hasRenewTime() {
        return this.renewTime != null;
    }

    public A withNewRenewTime(String time) {
        return this.withRenewTime(new MicroTime(time));
    }

    public String getStrategy() {
        return this.strategy;
    }

    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LeaseCandidateSpecFluent that = (LeaseCandidateSpecFluent)o;
        if (!Objects.equals(this.binaryVersion, that.binaryVersion)) {
            return false;
        }
        if (!Objects.equals(this.emulationVersion, that.emulationVersion)) {
            return false;
        }
        if (!Objects.equals(this.leaseName, that.leaseName)) {
            return false;
        }
        if (!Objects.equals(this.pingTime, that.pingTime)) {
            return false;
        }
        if (!Objects.equals(this.renewTime, that.renewTime)) {
            return false;
        }
        if (!Objects.equals(this.strategy, that.strategy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.binaryVersion, this.emulationVersion, this.leaseName, this.pingTime, this.renewTime, this.strategy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.binaryVersion != null) {
            sb.append("binaryVersion:");
            sb.append(this.binaryVersion + ",");
        }
        if (this.emulationVersion != null) {
            sb.append("emulationVersion:");
            sb.append(this.emulationVersion + ",");
        }
        if (this.leaseName != null) {
            sb.append("leaseName:");
            sb.append(this.leaseName + ",");
        }
        if (this.pingTime != null) {
            sb.append("pingTime:");
            sb.append(String.valueOf(this.pingTime) + ",");
        }
        if (this.renewTime != null) {
            sb.append("renewTime:");
            sb.append(String.valueOf(this.renewTime) + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

