/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.StaticConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StaticConfigFluent<A extends StaticConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> labels;
    private List<String> targets = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public StaticConfigFluent() {
    }

    public StaticConfigFluent(StaticConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StaticConfig instance) {
        StaticConfig staticConfig = instance = instance != null ? instance : new StaticConfig();
        if (instance != null) {
            this.withLabels(instance.getLabels());
            this.withTargets(instance.getTargets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public A addToTargets(int index, String item) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.add(index, item);
        return (A)this;
    }

    public A setToTargets(int index, String item) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.set(index, item);
        return (A)this;
    }

    public A addToTargets(String ... items) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        for (String item : items) {
            this.targets.add(item);
        }
        return (A)this;
    }

    public A addAllToTargets(Collection<String> items) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        for (String item : items) {
            this.targets.add(item);
        }
        return (A)this;
    }

    public A removeFromTargets(String ... items) {
        if (this.targets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.targets.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromTargets(Collection<String> items) {
        if (this.targets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.targets.remove(item);
        }
        return (A)this;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public String getTarget(int index) {
        return this.targets.get(index);
    }

    public String getFirstTarget() {
        return this.targets.get(0);
    }

    public String getLastTarget() {
        return this.targets.get(this.targets.size() - 1);
    }

    public String getMatchingTarget(Predicate<String> predicate) {
        for (String item : this.targets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTarget(Predicate<String> predicate) {
        for (String item : this.targets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargets(List<String> targets) {
        if (targets != null) {
            this.targets = new ArrayList<String>();
            for (String item : targets) {
                this.addToTargets(item);
            }
        } else {
            this.targets = null;
        }
        return (A)this;
    }

    public A withTargets(String ... targets) {
        if (this.targets != null) {
            this.targets.clear();
            this._visitables.remove("targets");
        }
        if (targets != null) {
            for (String item : targets) {
                this.addToTargets(item);
            }
        }
        return (A)this;
    }

    public boolean hasTargets() {
        return this.targets != null && !this.targets.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StaticConfigFluent that = (StaticConfigFluent)o;
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.targets, that.targets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.labels, this.targets, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(String.valueOf(this.labels) + ",");
        }
        if (this.targets != null && !this.targets.isEmpty()) {
            sb.append("targets:");
            sb.append(String.valueOf(this.targets) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

