/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.LightSailSDConfig;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LightSailSDConfigFluent<A extends LightSailSDConfigFluent<A>>
extends BaseFluent<A> {
    private SecretKeySelector accessKey;
    private SafeAuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private Boolean enableHTTP2;
    private String endpoint;
    private Boolean followRedirects;
    private String noProxy;
    private OAuth2Builder oauth2;
    private Integer port;
    private Map<String, List<SecretKeySelector>> proxyConnectHeader;
    private Boolean proxyFromEnvironment;
    private String proxyUrl;
    private String refreshInterval;
    private String region;
    private String roleARN;
    private SecretKeySelector secretKey;
    private SafeTLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public LightSailSDConfigFluent() {
    }

    public LightSailSDConfigFluent(LightSailSDConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LightSailSDConfig instance) {
        LightSailSDConfig lightSailSDConfig = instance = instance != null ? instance : new LightSailSDConfig();
        if (instance != null) {
            this.withAccessKey(instance.getAccessKey());
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withEnableHTTP2(instance.getEnableHTTP2());
            this.withEndpoint(instance.getEndpoint());
            this.withFollowRedirects(instance.getFollowRedirects());
            this.withNoProxy(instance.getNoProxy());
            this.withOauth2(instance.getOauth2());
            this.withPort(instance.getPort());
            this.withProxyConnectHeader(instance.getProxyConnectHeader());
            this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
            this.withProxyUrl(instance.getProxyUrl());
            this.withRefreshInterval(instance.getRefreshInterval());
            this.withRegion(instance.getRegion());
            this.withRoleARN(instance.getRoleARN());
            this.withSecretKey(instance.getSecretKey());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretKeySelector getAccessKey() {
        return this.accessKey;
    }

    public A withAccessKey(SecretKeySelector accessKey) {
        this.accessKey = accessKey;
        return (A)this;
    }

    public boolean hasAccessKey() {
        return this.accessKey != null;
    }

    public A withNewAccessKey(String key, String name, Boolean optional) {
        return this.withAccessKey(new SecretKeySelector(key, name, optional));
    }

    public SafeAuthorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(SafeAuthorization authorization) {
        this._visitables.remove("authorization");
        if (authorization != null) {
            this.authorization = new SafeAuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get("authorization").remove(this.authorization);
        }
        return (A)this;
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.remove("basicAuth");
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get("basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get("basicAuth").remove(this.basicAuth);
        }
        return (A)this;
    }

    public boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNested(null);
    }

    public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNested(item);
    }

    public BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(null));
    }

    public BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
    }

    public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(item));
    }

    public Boolean getEnableHTTP2() {
        return this.enableHTTP2;
    }

    public A withEnableHTTP2(Boolean enableHTTP2) {
        this.enableHTTP2 = enableHTTP2;
        return (A)this;
    }

    public boolean hasEnableHTTP2() {
        return this.enableHTTP2 != null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public A withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return (A)this;
    }

    public boolean hasEndpoint() {
        return this.endpoint != null;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public A withFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return (A)this;
    }

    public boolean hasFollowRedirects() {
        return this.followRedirects != null;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)this;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public OAuth2 buildOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    public A withOauth2(OAuth2 oauth2) {
        this._visitables.remove("oauth2");
        if (oauth2 != null) {
            this.oauth2 = new OAuth2Builder(oauth2);
            this._visitables.get("oauth2").add(this.oauth2);
        } else {
            this.oauth2 = null;
            this._visitables.get("oauth2").remove(this.oauth2);
        }
        return (A)this;
    }

    public boolean hasOauth2() {
        return this.oauth2 != null;
    }

    public Oauth2Nested<A> withNewOauth2() {
        return new Oauth2Nested(null);
    }

    public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
        return new Oauth2Nested(item);
    }

    public Oauth2Nested<A> editOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(null));
    }

    public Oauth2Nested<A> editOrNewOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(new OAuth2Builder().build()));
    }

    public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(item));
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A addToProxyConnectHeader(String key, List<SecretKeySelector> value) {
        if (this.proxyConnectHeader == null && key != null && value != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (key != null && value != null) {
            this.proxyConnectHeader.put(key, value);
        }
        return (A)this;
    }

    public A addToProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null && map != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (map != null) {
            this.proxyConnectHeader.putAll(map);
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(String key) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (key != null && this.proxyConnectHeader != null) {
            this.proxyConnectHeader.remove(key);
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyConnectHeader == null) continue;
                this.proxyConnectHeader.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, List<SecretKeySelector>> getProxyConnectHeader() {
        return this.proxyConnectHeader;
    }

    public <K, V> A withProxyConnectHeader(Map<String, List<SecretKeySelector>> proxyConnectHeader) {
        this.proxyConnectHeader = proxyConnectHeader == null ? null : new LinkedHashMap<String, List<SecretKeySelector>>(proxyConnectHeader);
        return (A)this;
    }

    public boolean hasProxyConnectHeader() {
        return this.proxyConnectHeader != null;
    }

    public Boolean getProxyFromEnvironment() {
        return this.proxyFromEnvironment;
    }

    public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
        this.proxyFromEnvironment = proxyFromEnvironment;
        return (A)this;
    }

    public boolean hasProxyFromEnvironment() {
        return this.proxyFromEnvironment != null;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)this;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public A withRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
        return (A)this;
    }

    public boolean hasRefreshInterval() {
        return this.refreshInterval != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public A withRoleARN(String roleARN) {
        this.roleARN = roleARN;
        return (A)this;
    }

    public boolean hasRoleARN() {
        return this.roleARN != null;
    }

    public SecretKeySelector getSecretKey() {
        return this.secretKey;
    }

    public A withSecretKey(SecretKeySelector secretKey) {
        this.secretKey = secretKey;
        return (A)this;
    }

    public boolean hasSecretKey() {
        return this.secretKey != null;
    }

    public A withNewSecretKey(String key, String name, Boolean optional) {
        return this.withSecretKey(new SecretKeySelector(key, name, optional));
    }

    public SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(SafeTLSConfig tlsConfig) {
        this._visitables.remove("tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LightSailSDConfigFluent that = (LightSailSDConfigFluent)o;
        if (!Objects.equals(this.accessKey, that.accessKey)) {
            return false;
        }
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals(this.basicAuth, that.basicAuth)) {
            return false;
        }
        if (!Objects.equals(this.enableHTTP2, that.enableHTTP2)) {
            return false;
        }
        if (!Objects.equals(this.endpoint, that.endpoint)) {
            return false;
        }
        if (!Objects.equals(this.followRedirects, that.followRedirects)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.oauth2, that.oauth2)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.proxyConnectHeader, that.proxyConnectHeader)) {
            return false;
        }
        if (!Objects.equals(this.proxyFromEnvironment, that.proxyFromEnvironment)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.refreshInterval, that.refreshInterval)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.roleARN, that.roleARN)) {
            return false;
        }
        if (!Objects.equals(this.secretKey, that.secretKey)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.accessKey, this.authorization, this.basicAuth, this.enableHTTP2, this.endpoint, this.followRedirects, this.noProxy, this.oauth2, this.port, this.proxyConnectHeader, this.proxyFromEnvironment, this.proxyUrl, this.refreshInterval, this.region, this.roleARN, this.secretKey, this.tlsConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accessKey != null) {
            sb.append("accessKey:");
            sb.append(String.valueOf(this.accessKey) + ",");
        }
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(String.valueOf(this.authorization) + ",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append(String.valueOf(this.basicAuth) + ",");
        }
        if (this.enableHTTP2 != null) {
            sb.append("enableHTTP2:");
            sb.append(this.enableHTTP2 + ",");
        }
        if (this.endpoint != null) {
            sb.append("endpoint:");
            sb.append(this.endpoint + ",");
        }
        if (this.followRedirects != null) {
            sb.append("followRedirects:");
            sb.append(this.followRedirects + ",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy + ",");
        }
        if (this.oauth2 != null) {
            sb.append("oauth2:");
            sb.append(String.valueOf(this.oauth2) + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.proxyConnectHeader != null && !this.proxyConnectHeader.isEmpty()) {
            sb.append("proxyConnectHeader:");
            sb.append(String.valueOf(this.proxyConnectHeader) + ",");
        }
        if (this.proxyFromEnvironment != null) {
            sb.append("proxyFromEnvironment:");
            sb.append(this.proxyFromEnvironment + ",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl + ",");
        }
        if (this.refreshInterval != null) {
            sb.append("refreshInterval:");
            sb.append(this.refreshInterval + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.roleARN != null) {
            sb.append("roleARN:");
            sb.append(this.roleARN + ",");
        }
        if (this.secretKey != null) {
            sb.append("secretKey:");
            sb.append(String.valueOf(this.secretKey) + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(String.valueOf(this.tlsConfig) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnableHTTP2() {
        return this.withEnableHTTP2(true);
    }

    public A withFollowRedirects() {
        return this.withFollowRedirects(true);
    }

    public A withProxyFromEnvironment() {
        return this.withProxyFromEnvironment(true);
    }

    public class TlsConfigNested<N>
    extends SafeTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        TlsConfigNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)LightSailSDConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class Oauth2Nested<N>
    extends OAuth2Fluent<Oauth2Nested<N>>
    implements Nested<N> {
        OAuth2Builder builder;

        Oauth2Nested(OAuth2 item) {
            this.builder = new OAuth2Builder(this, item);
        }

        @Override
        public N and() {
            return (N)LightSailSDConfigFluent.this.withOauth2(this.builder.build());
        }

        public N endOauth2() {
            return this.and();
        }
    }

    public class BasicAuthNested<N>
    extends BasicAuthFluent<BasicAuthNested<N>>
    implements Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNested(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)LightSailSDConfigFluent.this.withBasicAuth(this.builder.build());
        }

        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends SafeAuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        SafeAuthorizationBuilder builder;

        AuthorizationNested(SafeAuthorization item) {
            this.builder = new SafeAuthorizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)LightSailSDConfigFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }
}

