/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReference;
import io.fabric8.openshift.api.model.machine.v1beta1.Filter;
import io.fabric8.openshift.api.model.machine.v1beta1.FilterBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.FilterFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AWSResourceReferenceFluent<A extends AWSResourceReferenceFluent<A>>
extends BaseFluent<A> {
    private String arn;
    private ArrayList<FilterBuilder> filters = new ArrayList();
    private String id;
    private Map<String, Object> additionalProperties;

    public AWSResourceReferenceFluent() {
    }

    public AWSResourceReferenceFluent(AWSResourceReference instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AWSResourceReference instance) {
        AWSResourceReference aWSResourceReference = instance = instance != null ? instance : new AWSResourceReference();
        if (instance != null) {
            this.withArn(instance.getArn());
            this.withFilters(instance.getFilters());
            this.withId(instance.getId());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getArn() {
        return this.arn;
    }

    public A withArn(String arn) {
        this.arn = arn;
        return (A)this;
    }

    public boolean hasArn() {
        return this.arn != null;
    }

    public A addToFilters(int index, Filter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        FilterBuilder builder = new FilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get("filters").add(builder);
            this.filters.add(index, builder);
        }
        return (A)this;
    }

    public A setToFilters(int index, Filter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        FilterBuilder builder = new FilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get("filters").add(builder);
            this.filters.set(index, builder);
        }
        return (A)this;
    }

    public A addToFilters(Filter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    public A addAllToFilters(Collection<Filter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    public A removeFromFilters(Filter ... items) {
        if (this.filters == null) {
            return (A)this;
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get("filters").remove(builder);
            this.filters.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFilters(Collection<Filter> items) {
        if (this.filters == null) {
            return (A)this;
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get("filters").remove(builder);
            this.filters.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFilters(Predicate<FilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)this;
        }
        Iterator<FilterBuilder> each = this.filters.iterator();
        Object visitables = this._visitables.get("filters");
        while (each.hasNext()) {
            FilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Filter> buildFilters() {
        return this.filters != null ? AWSResourceReferenceFluent.build(this.filters) : null;
    }

    public Filter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    public Filter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    public Filter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    public Filter buildMatchingFilter(Predicate<FilterBuilder> predicate) {
        for (FilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFilter(Predicate<FilterBuilder> predicate) {
        for (FilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFilters(List<Filter> filters) {
        if (this.filters != null) {
            this._visitables.get("filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (Filter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)this;
    }

    public A withFilters(Filter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove("filters");
        }
        if (filters != null) {
            for (Filter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)this;
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public FiltersNested<A> addNewFilter() {
        return new FiltersNested(-1, null);
    }

    public FiltersNested<A> addNewFilterLike(Filter item) {
        return new FiltersNested(-1, item);
    }

    public FiltersNested<A> setNewFilterLike(int index, Filter item) {
        return new FiltersNested(index, item);
    }

    public FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    public FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editMatchingFilter(Predicate<FilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSResourceReferenceFluent that = (AWSResourceReferenceFluent)o;
        if (!Objects.equals(this.arn, that.arn)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arn, this.filters, this.id, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arn != null) {
            sb.append("arn:");
            sb.append(this.arn + ",");
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(String.valueOf(this.filters) + ",");
        }
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FiltersNested<N>
    extends FilterFluent<FiltersNested<N>>
    implements Nested<N> {
        FilterBuilder builder;
        int index;

        FiltersNested(int index, Filter item) {
            this.index = index;
            this.builder = new FilterBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AWSResourceReferenceFluent.this.setToFilters(this.index, this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }
}

