/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.v1.MachinePoolPlatform;
import io.fabric8.openshift.api.model.installer.v1.MachinePoolPlatformBuilder;
import io.fabric8.openshift.api.model.installer.v1.MachinePoolPlatformFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private String architecture;
    private String hyperthreading;
    private String name;
    private MachinePoolPlatformBuilder platform;
    private Long replicas;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withArchitecture(instance.getArchitecture());
            this.withHyperthreading(instance.getHyperthreading());
            this.withName(instance.getName());
            this.withPlatform(instance.getPlatform());
            this.withReplicas(instance.getReplicas());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public A withArchitecture(String architecture) {
        this.architecture = architecture;
        return (A)this;
    }

    public boolean hasArchitecture() {
        return this.architecture != null;
    }

    public String getHyperthreading() {
        return this.hyperthreading;
    }

    public A withHyperthreading(String hyperthreading) {
        this.hyperthreading = hyperthreading;
        return (A)this;
    }

    public boolean hasHyperthreading() {
        return this.hyperthreading != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public MachinePoolPlatform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    public A withPlatform(MachinePoolPlatform platform) {
        this._visitables.remove("platform");
        if (platform != null) {
            this.platform = new MachinePoolPlatformBuilder(platform);
            this._visitables.get("platform").add(this.platform);
        } else {
            this.platform = null;
            this._visitables.get("platform").remove(this.platform);
        }
        return (A)this;
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public PlatformNested<A> withNewPlatform() {
        return new PlatformNested(null);
    }

    public PlatformNested<A> withNewPlatformLike(MachinePoolPlatform item) {
        return new PlatformNested(item);
    }

    public PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(null));
    }

    public PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(new MachinePoolPlatformBuilder().build()));
    }

    public PlatformNested<A> editOrNewPlatformLike(MachinePoolPlatform item) {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(item));
    }

    public Long getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Long replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.architecture, that.architecture)) {
            return false;
        }
        if (!Objects.equals(this.hyperthreading, that.hyperthreading)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.architecture, this.hyperthreading, this.name, this.platform, this.replicas, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.architecture != null) {
            sb.append("architecture:");
            sb.append(this.architecture + ",");
        }
        if (this.hyperthreading != null) {
            sb.append("hyperthreading:");
            sb.append(this.hyperthreading + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(String.valueOf(this.platform) + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PlatformNested<N>
    extends MachinePoolPlatformFluent<PlatformNested<N>>
    implements Nested<N> {
        MachinePoolPlatformBuilder builder;

        PlatformNested(MachinePoolPlatform item) {
            this.builder = new MachinePoolPlatformBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluent.this.withPlatform(this.builder.build());
        }

        public N endPlatform() {
            return this.and();
        }
    }
}

