/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.azure.v1.CustomerManagedKey;
import io.fabric8.openshift.api.model.installer.azure.v1.KeyVault;
import io.fabric8.openshift.api.model.installer.azure.v1.KeyVaultBuilder;
import io.fabric8.openshift.api.model.installer.azure.v1.KeyVaultFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CustomerManagedKeyFluent<A extends CustomerManagedKeyFluent<A>>
extends BaseFluent<A> {
    private KeyVaultBuilder keyVault;
    private String userAssignedIdentityKey;
    private Map<String, Object> additionalProperties;

    public CustomerManagedKeyFluent() {
    }

    public CustomerManagedKeyFluent(CustomerManagedKey instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CustomerManagedKey instance) {
        CustomerManagedKey customerManagedKey = instance = instance != null ? instance : new CustomerManagedKey();
        if (instance != null) {
            this.withKeyVault(instance.getKeyVault());
            this.withUserAssignedIdentityKey(instance.getUserAssignedIdentityKey());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public KeyVault buildKeyVault() {
        return this.keyVault != null ? this.keyVault.build() : null;
    }

    public A withKeyVault(KeyVault keyVault) {
        this._visitables.remove("keyVault");
        if (keyVault != null) {
            this.keyVault = new KeyVaultBuilder(keyVault);
            this._visitables.get("keyVault").add(this.keyVault);
        } else {
            this.keyVault = null;
            this._visitables.get("keyVault").remove(this.keyVault);
        }
        return (A)this;
    }

    public boolean hasKeyVault() {
        return this.keyVault != null;
    }

    public A withNewKeyVault(String keyName, String name, String resourceGroup) {
        return this.withKeyVault(new KeyVault(keyName, name, resourceGroup));
    }

    public KeyVaultNested<A> withNewKeyVault() {
        return new KeyVaultNested(null);
    }

    public KeyVaultNested<A> withNewKeyVaultLike(KeyVault item) {
        return new KeyVaultNested(item);
    }

    public KeyVaultNested<A> editKeyVault() {
        return this.withNewKeyVaultLike(Optional.ofNullable(this.buildKeyVault()).orElse(null));
    }

    public KeyVaultNested<A> editOrNewKeyVault() {
        return this.withNewKeyVaultLike(Optional.ofNullable(this.buildKeyVault()).orElse(new KeyVaultBuilder().build()));
    }

    public KeyVaultNested<A> editOrNewKeyVaultLike(KeyVault item) {
        return this.withNewKeyVaultLike(Optional.ofNullable(this.buildKeyVault()).orElse(item));
    }

    public String getUserAssignedIdentityKey() {
        return this.userAssignedIdentityKey;
    }

    public A withUserAssignedIdentityKey(String userAssignedIdentityKey) {
        this.userAssignedIdentityKey = userAssignedIdentityKey;
        return (A)this;
    }

    public boolean hasUserAssignedIdentityKey() {
        return this.userAssignedIdentityKey != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomerManagedKeyFluent that = (CustomerManagedKeyFluent)o;
        if (!Objects.equals(this.keyVault, that.keyVault)) {
            return false;
        }
        if (!Objects.equals(this.userAssignedIdentityKey, that.userAssignedIdentityKey)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyVault, this.userAssignedIdentityKey, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyVault != null) {
            sb.append("keyVault:");
            sb.append(String.valueOf(this.keyVault) + ",");
        }
        if (this.userAssignedIdentityKey != null) {
            sb.append("userAssignedIdentityKey:");
            sb.append(this.userAssignedIdentityKey + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class KeyVaultNested<N>
    extends KeyVaultFluent<KeyVaultNested<N>>
    implements Nested<N> {
        KeyVaultBuilder builder;

        KeyVaultNested(KeyVault item) {
            this.builder = new KeyVaultBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CustomerManagedKeyFluent.this.withKeyVault(this.builder.build());
        }

        public N endKeyVault() {
            return this.and();
        }
    }
}

