/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.ImageImportStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageImportStatusFluent<A extends ImageImportStatusFluent<A>>
extends BaseFluent<A> {
    private ImageBuilder image;
    private ArrayList<ImageBuilder> manifests = new ArrayList();
    private Status status;
    private String tag;
    private Map<String, Object> additionalProperties;

    public ImageImportStatusFluent() {
    }

    public ImageImportStatusFluent(ImageImportStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageImportStatus instance) {
        ImageImportStatus imageImportStatus = instance = instance != null ? instance : new ImageImportStatus();
        if (instance != null) {
            this.withImage(instance.getImage());
            this.withManifests(instance.getManifests());
            this.withStatus(instance.getStatus());
            this.withTag(instance.getTag());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    public A withImage(Image image) {
        this._visitables.remove("image");
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get("image").add(this.image);
        } else {
            this.image = null;
            this._visitables.get("image").remove(this.image);
        }
        return (A)this;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public ImageNested<A> withNewImage() {
        return new ImageNested(null);
    }

    public ImageNested<A> withNewImageLike(Image item) {
        return new ImageNested(item);
    }

    public ImageNested<A> editImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(null));
    }

    public ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(new ImageBuilder().build()));
    }

    public ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(item));
    }

    public A addToManifests(int index, Image item) {
        if (this.manifests == null) {
            this.manifests = new ArrayList();
        }
        ImageBuilder builder = new ImageBuilder(item);
        if (index < 0 || index >= this.manifests.size()) {
            this._visitables.get("manifests").add(builder);
            this.manifests.add(builder);
        } else {
            this._visitables.get("manifests").add(builder);
            this.manifests.add(index, builder);
        }
        return (A)this;
    }

    public A setToManifests(int index, Image item) {
        if (this.manifests == null) {
            this.manifests = new ArrayList();
        }
        ImageBuilder builder = new ImageBuilder(item);
        if (index < 0 || index >= this.manifests.size()) {
            this._visitables.get("manifests").add(builder);
            this.manifests.add(builder);
        } else {
            this._visitables.get("manifests").add(builder);
            this.manifests.set(index, builder);
        }
        return (A)this;
    }

    public A addToManifests(Image ... items) {
        if (this.manifests == null) {
            this.manifests = new ArrayList();
        }
        for (Image item : items) {
            ImageBuilder builder = new ImageBuilder(item);
            this._visitables.get("manifests").add(builder);
            this.manifests.add(builder);
        }
        return (A)this;
    }

    public A addAllToManifests(Collection<Image> items) {
        if (this.manifests == null) {
            this.manifests = new ArrayList();
        }
        for (Image item : items) {
            ImageBuilder builder = new ImageBuilder(item);
            this._visitables.get("manifests").add(builder);
            this.manifests.add(builder);
        }
        return (A)this;
    }

    public A removeFromManifests(Image ... items) {
        if (this.manifests == null) {
            return (A)this;
        }
        for (Image item : items) {
            ImageBuilder builder = new ImageBuilder(item);
            this._visitables.get("manifests").remove(builder);
            this.manifests.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromManifests(Collection<Image> items) {
        if (this.manifests == null) {
            return (A)this;
        }
        for (Image item : items) {
            ImageBuilder builder = new ImageBuilder(item);
            this._visitables.get("manifests").remove(builder);
            this.manifests.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromManifests(Predicate<ImageBuilder> predicate) {
        if (this.manifests == null) {
            return (A)this;
        }
        Iterator<ImageBuilder> each = this.manifests.iterator();
        Object visitables = this._visitables.get("manifests");
        while (each.hasNext()) {
            ImageBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Image> buildManifests() {
        return this.manifests != null ? ImageImportStatusFluent.build(this.manifests) : null;
    }

    public Image buildManifest(int index) {
        return this.manifests.get(index).build();
    }

    public Image buildFirstManifest() {
        return this.manifests.get(0).build();
    }

    public Image buildLastManifest() {
        return this.manifests.get(this.manifests.size() - 1).build();
    }

    public Image buildMatchingManifest(Predicate<ImageBuilder> predicate) {
        for (ImageBuilder item : this.manifests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingManifest(Predicate<ImageBuilder> predicate) {
        for (ImageBuilder item : this.manifests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withManifests(List<Image> manifests) {
        if (this.manifests != null) {
            this._visitables.get("manifests").clear();
        }
        if (manifests != null) {
            this.manifests = new ArrayList();
            for (Image item : manifests) {
                this.addToManifests(item);
            }
        } else {
            this.manifests = null;
        }
        return (A)this;
    }

    public A withManifests(Image ... manifests) {
        if (this.manifests != null) {
            this.manifests.clear();
            this._visitables.remove("manifests");
        }
        if (manifests != null) {
            for (Image item : manifests) {
                this.addToManifests(item);
            }
        }
        return (A)this;
    }

    public boolean hasManifests() {
        return this.manifests != null && !this.manifests.isEmpty();
    }

    public ManifestsNested<A> addNewManifest() {
        return new ManifestsNested(-1, null);
    }

    public ManifestsNested<A> addNewManifestLike(Image item) {
        return new ManifestsNested(-1, item);
    }

    public ManifestsNested<A> setNewManifestLike(int index, Image item) {
        return new ManifestsNested(index, item);
    }

    public ManifestsNested<A> editManifest(int index) {
        if (this.manifests.size() <= index) {
            throw new RuntimeException("Can't edit manifests. Index exceeds size.");
        }
        return this.setNewManifestLike(index, this.buildManifest(index));
    }

    public ManifestsNested<A> editFirstManifest() {
        if (this.manifests.size() == 0) {
            throw new RuntimeException("Can't edit first manifests. The list is empty.");
        }
        return this.setNewManifestLike(0, this.buildManifest(0));
    }

    public ManifestsNested<A> editLastManifest() {
        int index = this.manifests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last manifests. The list is empty.");
        }
        return this.setNewManifestLike(index, this.buildManifest(index));
    }

    public ManifestsNested<A> editMatchingManifest(Predicate<ImageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.manifests.size(); ++i) {
            if (!predicate.test(this.manifests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching manifests. No match found.");
        }
        return this.setNewManifestLike(index, this.buildManifest(index));
    }

    public Status getStatus() {
        return this.status;
    }

    public A withStatus(Status status) {
        this.status = status;
        return (A)this;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public String getTag() {
        return this.tag;
    }

    public A withTag(String tag) {
        this.tag = tag;
        return (A)this;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageImportStatusFluent that = (ImageImportStatusFluent)o;
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.manifests, that.manifests)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        if (!Objects.equals(this.tag, that.tag)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.image, this.manifests, this.status, this.tag, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image != null) {
            sb.append("image:");
            sb.append(String.valueOf(this.image) + ",");
        }
        if (this.manifests != null && !this.manifests.isEmpty()) {
            sb.append("manifests:");
            sb.append(String.valueOf(this.manifests) + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(String.valueOf(this.status) + ",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append(this.tag + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ManifestsNested<N>
    extends ImageFluent<ManifestsNested<N>>
    implements Nested<N> {
        ImageBuilder builder;
        int index;

        ManifestsNested(int index, Image item) {
            this.index = index;
            this.builder = new ImageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageImportStatusFluent.this.setToManifests(this.index, this.builder.build());
        }

        public N endManifest() {
            return this.and();
        }
    }

    public class ImageNested<N>
    extends ImageFluent<ImageNested<N>>
    implements Nested<N> {
        ImageBuilder builder;

        ImageNested(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageImportStatusFluent.this.withImage(this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }
}

