/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExternalMetricSourceFluent<A extends ExternalMetricSourceFluent<A>>
extends BaseFluent<A> {
    private String metricName;
    private LabelSelectorBuilder metricSelector;
    private Quantity targetAverageValue;
    private Quantity targetValue;
    private Map<String, Object> additionalProperties;

    public ExternalMetricSourceFluent() {
    }

    public ExternalMetricSourceFluent(ExternalMetricSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ExternalMetricSource instance) {
        ExternalMetricSource externalMetricSource = instance = instance != null ? instance : new ExternalMetricSource();
        if (instance != null) {
            this.withMetricName(instance.getMetricName());
            this.withMetricSelector(instance.getMetricSelector());
            this.withTargetAverageValue(instance.getTargetAverageValue());
            this.withTargetValue(instance.getTargetValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getMetricName() {
        return this.metricName;
    }

    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    public boolean hasMetricName() {
        return this.metricName != null;
    }

    public LabelSelector buildMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    public A withMetricSelector(LabelSelector metricSelector) {
        this._visitables.remove("metricSelector");
        if (metricSelector != null) {
            this.metricSelector = new LabelSelectorBuilder(metricSelector);
            this._visitables.get("metricSelector").add(this.metricSelector);
        } else {
            this.metricSelector = null;
            this._visitables.get("metricSelector").remove(this.metricSelector);
        }
        return (A)this;
    }

    public boolean hasMetricSelector() {
        return this.metricSelector != null;
    }

    public MetricSelectorNested<A> withNewMetricSelector() {
        return new MetricSelectorNested(null);
    }

    public MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
        return new MetricSelectorNested(item);
    }

    public MetricSelectorNested<A> editMetricSelector() {
        return this.withNewMetricSelectorLike(Optional.ofNullable(this.buildMetricSelector()).orElse(null));
    }

    public MetricSelectorNested<A> editOrNewMetricSelector() {
        return this.withNewMetricSelectorLike(Optional.ofNullable(this.buildMetricSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
        return this.withNewMetricSelectorLike(Optional.ofNullable(this.buildMetricSelector()).orElse(item));
    }

    public Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    public A withTargetAverageValue(Quantity targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return (A)this;
    }

    public boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    public A withNewTargetAverageValue(String amount, String format) {
        return this.withTargetAverageValue(new Quantity(amount, format));
    }

    public A withNewTargetAverageValue(String amount) {
        return this.withTargetAverageValue(new Quantity(amount));
    }

    public Quantity getTargetValue() {
        return this.targetValue;
    }

    public A withTargetValue(Quantity targetValue) {
        this.targetValue = targetValue;
        return (A)this;
    }

    public boolean hasTargetValue() {
        return this.targetValue != null;
    }

    public A withNewTargetValue(String amount, String format) {
        return this.withTargetValue(new Quantity(amount, format));
    }

    public A withNewTargetValue(String amount) {
        return this.withTargetValue(new Quantity(amount));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalMetricSourceFluent that = (ExternalMetricSourceFluent)o;
        if (!Objects.equals(this.metricName, that.metricName)) {
            return false;
        }
        if (!Objects.equals(this.metricSelector, that.metricSelector)) {
            return false;
        }
        if (!Objects.equals(this.targetAverageValue, that.targetAverageValue)) {
            return false;
        }
        if (!Objects.equals(this.targetValue, that.targetValue)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.metricName, this.metricSelector, this.targetAverageValue, this.targetValue, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metricName != null) {
            sb.append("metricName:");
            sb.append(this.metricName + ",");
        }
        if (this.metricSelector != null) {
            sb.append("metricSelector:");
            sb.append(String.valueOf(this.metricSelector) + ",");
        }
        if (this.targetAverageValue != null) {
            sb.append("targetAverageValue:");
            sb.append(String.valueOf(this.targetAverageValue) + ",");
        }
        if (this.targetValue != null) {
            sb.append("targetValue:");
            sb.append(String.valueOf(this.targetValue) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetricSelectorNested<N>
    extends LabelSelectorFluent<MetricSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        MetricSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ExternalMetricSourceFluent.this.withMetricSelector(this.builder.build());
        }

        public N endMetricSelector() {
            return this.and();
        }
    }
}

