/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.PreprovisioningImageStatus;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SecretStatus;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SecretStatusBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SecretStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PreprovisioningImageStatusFluent<A extends PreprovisioningImageStatusFluent<A>>
extends BaseFluent<A> {
    private String architecture;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String extraKernelParams;
    private String format;
    private String imageUrl;
    private String kernelUrl;
    private SecretStatusBuilder networkData;
    private Map<String, Object> additionalProperties;

    public PreprovisioningImageStatusFluent() {
    }

    public PreprovisioningImageStatusFluent(PreprovisioningImageStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PreprovisioningImageStatus instance) {
        PreprovisioningImageStatus preprovisioningImageStatus = instance = instance != null ? instance : new PreprovisioningImageStatus();
        if (instance != null) {
            this.withArchitecture(instance.getArchitecture());
            this.withConditions(instance.getConditions());
            this.withExtraKernelParams(instance.getExtraKernelParams());
            this.withFormat(instance.getFormat());
            this.withImageUrl(instance.getImageUrl());
            this.withKernelUrl(instance.getKernelUrl());
            this.withNetworkData(instance.getNetworkData());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public A withArchitecture(String architecture) {
        this.architecture = architecture;
        return (A)this;
    }

    public boolean hasArchitecture() {
        return this.architecture != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public String getExtraKernelParams() {
        return this.extraKernelParams;
    }

    public A withExtraKernelParams(String extraKernelParams) {
        this.extraKernelParams = extraKernelParams;
        return (A)this;
    }

    public boolean hasExtraKernelParams() {
        return this.extraKernelParams != null;
    }

    public String getFormat() {
        return this.format;
    }

    public A withFormat(String format) {
        this.format = format;
        return (A)this;
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public A withImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return (A)this;
    }

    public boolean hasImageUrl() {
        return this.imageUrl != null;
    }

    public String getKernelUrl() {
        return this.kernelUrl;
    }

    public A withKernelUrl(String kernelUrl) {
        this.kernelUrl = kernelUrl;
        return (A)this;
    }

    public boolean hasKernelUrl() {
        return this.kernelUrl != null;
    }

    public SecretStatus buildNetworkData() {
        return this.networkData != null ? this.networkData.build() : null;
    }

    public A withNetworkData(SecretStatus networkData) {
        this._visitables.remove("networkData");
        if (networkData != null) {
            this.networkData = new SecretStatusBuilder(networkData);
            this._visitables.get("networkData").add(this.networkData);
        } else {
            this.networkData = null;
            this._visitables.get("networkData").remove(this.networkData);
        }
        return (A)this;
    }

    public boolean hasNetworkData() {
        return this.networkData != null;
    }

    public A withNewNetworkData(String name, String version) {
        return this.withNetworkData(new SecretStatus(name, version));
    }

    public NetworkDataNested<A> withNewNetworkData() {
        return new NetworkDataNested(null);
    }

    public NetworkDataNested<A> withNewNetworkDataLike(SecretStatus item) {
        return new NetworkDataNested(item);
    }

    public NetworkDataNested<A> editNetworkData() {
        return this.withNewNetworkDataLike(Optional.ofNullable(this.buildNetworkData()).orElse(null));
    }

    public NetworkDataNested<A> editOrNewNetworkData() {
        return this.withNewNetworkDataLike(Optional.ofNullable(this.buildNetworkData()).orElse(new SecretStatusBuilder().build()));
    }

    public NetworkDataNested<A> editOrNewNetworkDataLike(SecretStatus item) {
        return this.withNewNetworkDataLike(Optional.ofNullable(this.buildNetworkData()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PreprovisioningImageStatusFluent that = (PreprovisioningImageStatusFluent)o;
        if (!Objects.equals(this.architecture, that.architecture)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.extraKernelParams, that.extraKernelParams)) {
            return false;
        }
        if (!Objects.equals(this.format, that.format)) {
            return false;
        }
        if (!Objects.equals(this.imageUrl, that.imageUrl)) {
            return false;
        }
        if (!Objects.equals(this.kernelUrl, that.kernelUrl)) {
            return false;
        }
        if (!Objects.equals(this.networkData, that.networkData)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.architecture, this.conditions, this.extraKernelParams, this.format, this.imageUrl, this.kernelUrl, this.networkData, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.architecture != null) {
            sb.append("architecture:");
            sb.append(this.architecture + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.extraKernelParams != null) {
            sb.append("extraKernelParams:");
            sb.append(this.extraKernelParams + ",");
        }
        if (this.format != null) {
            sb.append("format:");
            sb.append(this.format + ",");
        }
        if (this.imageUrl != null) {
            sb.append("imageUrl:");
            sb.append(this.imageUrl + ",");
        }
        if (this.kernelUrl != null) {
            sb.append("kernelUrl:");
            sb.append(this.kernelUrl + ",");
        }
        if (this.networkData != null) {
            sb.append("networkData:");
            sb.append(this.networkData + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NetworkDataNested<N>
    extends SecretStatusFluent<NetworkDataNested<N>>
    implements Nested<N> {
        SecretStatusBuilder builder;

        NetworkDataNested(SecretStatus item) {
            this.builder = new SecretStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PreprovisioningImageStatusFluent.this.withNetworkData(this.builder.build());
        }

        public N endNetworkData() {
            return this.and();
        }
    }
}

