/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.customresourcestatus.conditions.v1.Condition;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentCustomizationStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterDeploymentCustomizationStatusFluent<A extends ClusterDeploymentCustomizationStatusFluent<A>>
extends BaseFluent<A> {
    private LocalObjectReferenceBuilder clusterDeploymentRef;
    private LocalObjectReferenceBuilder clusterPoolRef;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String lastAppliedConfiguration;
    private Map<String, Object> additionalProperties;

    public ClusterDeploymentCustomizationStatusFluent() {
    }

    public ClusterDeploymentCustomizationStatusFluent(ClusterDeploymentCustomizationStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterDeploymentCustomizationStatus instance) {
        ClusterDeploymentCustomizationStatus clusterDeploymentCustomizationStatus = instance = instance != null ? instance : new ClusterDeploymentCustomizationStatus();
        if (instance != null) {
            this.withClusterDeploymentRef(instance.getClusterDeploymentRef());
            this.withClusterPoolRef(instance.getClusterPoolRef());
            this.withConditions(instance.getConditions());
            this.withLastAppliedConfiguration(instance.getLastAppliedConfiguration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LocalObjectReference buildClusterDeploymentRef() {
        return this.clusterDeploymentRef != null ? this.clusterDeploymentRef.build() : null;
    }

    public A withClusterDeploymentRef(LocalObjectReference clusterDeploymentRef) {
        this._visitables.remove("clusterDeploymentRef");
        if (clusterDeploymentRef != null) {
            this.clusterDeploymentRef = new LocalObjectReferenceBuilder(clusterDeploymentRef);
            this._visitables.get("clusterDeploymentRef").add(this.clusterDeploymentRef);
        } else {
            this.clusterDeploymentRef = null;
            this._visitables.get("clusterDeploymentRef").remove(this.clusterDeploymentRef);
        }
        return (A)this;
    }

    public boolean hasClusterDeploymentRef() {
        return this.clusterDeploymentRef != null;
    }

    public A withNewClusterDeploymentRef(String name) {
        return this.withClusterDeploymentRef(new LocalObjectReference(name));
    }

    public ClusterDeploymentRefNested<A> withNewClusterDeploymentRef() {
        return new ClusterDeploymentRefNested(null);
    }

    public ClusterDeploymentRefNested<A> withNewClusterDeploymentRefLike(LocalObjectReference item) {
        return new ClusterDeploymentRefNested(item);
    }

    public ClusterDeploymentRefNested<A> editClusterDeploymentRef() {
        return this.withNewClusterDeploymentRefLike(Optional.ofNullable(this.buildClusterDeploymentRef()).orElse(null));
    }

    public ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRef() {
        return this.withNewClusterDeploymentRefLike(Optional.ofNullable(this.buildClusterDeploymentRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRefLike(LocalObjectReference item) {
        return this.withNewClusterDeploymentRefLike(Optional.ofNullable(this.buildClusterDeploymentRef()).orElse(item));
    }

    public LocalObjectReference buildClusterPoolRef() {
        return this.clusterPoolRef != null ? this.clusterPoolRef.build() : null;
    }

    public A withClusterPoolRef(LocalObjectReference clusterPoolRef) {
        this._visitables.remove("clusterPoolRef");
        if (clusterPoolRef != null) {
            this.clusterPoolRef = new LocalObjectReferenceBuilder(clusterPoolRef);
            this._visitables.get("clusterPoolRef").add(this.clusterPoolRef);
        } else {
            this.clusterPoolRef = null;
            this._visitables.get("clusterPoolRef").remove(this.clusterPoolRef);
        }
        return (A)this;
    }

    public boolean hasClusterPoolRef() {
        return this.clusterPoolRef != null;
    }

    public A withNewClusterPoolRef(String name) {
        return this.withClusterPoolRef(new LocalObjectReference(name));
    }

    public ClusterPoolRefNested<A> withNewClusterPoolRef() {
        return new ClusterPoolRefNested(null);
    }

    public ClusterPoolRefNested<A> withNewClusterPoolRefLike(LocalObjectReference item) {
        return new ClusterPoolRefNested(item);
    }

    public ClusterPoolRefNested<A> editClusterPoolRef() {
        return this.withNewClusterPoolRefLike(Optional.ofNullable(this.buildClusterPoolRef()).orElse(null));
    }

    public ClusterPoolRefNested<A> editOrNewClusterPoolRef() {
        return this.withNewClusterPoolRefLike(Optional.ofNullable(this.buildClusterPoolRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ClusterPoolRefNested<A> editOrNewClusterPoolRefLike(LocalObjectReference item) {
        return this.withNewClusterPoolRefLike(Optional.ofNullable(this.buildClusterPoolRef()).orElse(item));
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public String getLastAppliedConfiguration() {
        return this.lastAppliedConfiguration;
    }

    public A withLastAppliedConfiguration(String lastAppliedConfiguration) {
        this.lastAppliedConfiguration = lastAppliedConfiguration;
        return (A)this;
    }

    public boolean hasLastAppliedConfiguration() {
        return this.lastAppliedConfiguration != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterDeploymentCustomizationStatusFluent that = (ClusterDeploymentCustomizationStatusFluent)o;
        if (!Objects.equals(this.clusterDeploymentRef, that.clusterDeploymentRef)) {
            return false;
        }
        if (!Objects.equals(this.clusterPoolRef, that.clusterPoolRef)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.lastAppliedConfiguration, that.lastAppliedConfiguration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterDeploymentRef, this.clusterPoolRef, this.conditions, this.lastAppliedConfiguration, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterDeploymentRef != null) {
            sb.append("clusterDeploymentRef:");
            sb.append(this.clusterDeploymentRef + ",");
        }
        if (this.clusterPoolRef != null) {
            sb.append("clusterPoolRef:");
            sb.append(this.clusterPoolRef + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.lastAppliedConfiguration != null) {
            sb.append("lastAppliedConfiguration:");
            sb.append(this.lastAppliedConfiguration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClusterPoolRefNested<N>
    extends LocalObjectReferenceFluent<ClusterPoolRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ClusterPoolRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentCustomizationStatusFluent.this.withClusterPoolRef(this.builder.build());
        }

        public N endClusterPoolRef() {
            return this.and();
        }
    }

    public class ClusterDeploymentRefNested<N>
    extends LocalObjectReferenceFluent<ClusterDeploymentRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ClusterDeploymentRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterDeploymentCustomizationStatusFluent.this.withClusterDeploymentRef(this.builder.build());
        }

        public N endClusterDeploymentRef() {
            return this.and();
        }
    }
}

