/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.HTTPServingInfo;
import io.fabric8.openshift.api.model.config.v1.LeaderElection;
import io.fabric8.openshift.api.model.operator.v1alpha1.DelegatedAuthentication;
import io.fabric8.openshift.api.model.operator.v1alpha1.DelegatedAuthenticationBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.DelegatedAuthenticationFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.DelegatedAuthorization;
import io.fabric8.openshift.api.model.operator.v1alpha1.DelegatedAuthorizationBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.DelegatedAuthorizationFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.GenericOperatorConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GenericOperatorConfigFluent<A extends GenericOperatorConfigFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private DelegatedAuthenticationBuilder authentication;
    private DelegatedAuthorizationBuilder authorization;
    private String kind;
    private LeaderElection leaderElection;
    private HTTPServingInfo servingInfo;
    private Map<String, Object> additionalProperties;

    public GenericOperatorConfigFluent() {
    }

    public GenericOperatorConfigFluent(GenericOperatorConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GenericOperatorConfig instance) {
        GenericOperatorConfig genericOperatorConfig = instance = instance != null ? instance : new GenericOperatorConfig();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withAuthentication(instance.getAuthentication());
            this.withAuthorization(instance.getAuthorization());
            this.withKind(instance.getKind());
            this.withLeaderElection(instance.getLeaderElection());
            this.withServingInfo(instance.getServingInfo());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public DelegatedAuthentication buildAuthentication() {
        return this.authentication != null ? this.authentication.build() : null;
    }

    public A withAuthentication(DelegatedAuthentication authentication) {
        this._visitables.remove("authentication");
        if (authentication != null) {
            this.authentication = new DelegatedAuthenticationBuilder(authentication);
            this._visitables.get("authentication").add(this.authentication);
        } else {
            this.authentication = null;
            this._visitables.get("authentication").remove(this.authentication);
        }
        return (A)this;
    }

    public boolean hasAuthentication() {
        return this.authentication != null;
    }

    public A withNewAuthentication(Boolean disabled) {
        return this.withAuthentication(new DelegatedAuthentication(disabled));
    }

    public AuthenticationNested<A> withNewAuthentication() {
        return new AuthenticationNested(null);
    }

    public AuthenticationNested<A> withNewAuthenticationLike(DelegatedAuthentication item) {
        return new AuthenticationNested(item);
    }

    public AuthenticationNested<A> editAuthentication() {
        return this.withNewAuthenticationLike(Optional.ofNullable(this.buildAuthentication()).orElse(null));
    }

    public AuthenticationNested<A> editOrNewAuthentication() {
        return this.withNewAuthenticationLike(Optional.ofNullable(this.buildAuthentication()).orElse(new DelegatedAuthenticationBuilder().build()));
    }

    public AuthenticationNested<A> editOrNewAuthenticationLike(DelegatedAuthentication item) {
        return this.withNewAuthenticationLike(Optional.ofNullable(this.buildAuthentication()).orElse(item));
    }

    public DelegatedAuthorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(DelegatedAuthorization authorization) {
        this._visitables.remove("authorization");
        if (authorization != null) {
            this.authorization = new DelegatedAuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get("authorization").remove(this.authorization);
        }
        return (A)this;
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public A withNewAuthorization(Boolean disabled) {
        return this.withAuthorization(new DelegatedAuthorization(disabled));
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(DelegatedAuthorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new DelegatedAuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(DelegatedAuthorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public LeaderElection getLeaderElection() {
        return this.leaderElection;
    }

    public A withLeaderElection(LeaderElection leaderElection) {
        this.leaderElection = leaderElection;
        return (A)this;
    }

    public boolean hasLeaderElection() {
        return this.leaderElection != null;
    }

    public HTTPServingInfo getServingInfo() {
        return this.servingInfo;
    }

    public A withServingInfo(HTTPServingInfo servingInfo) {
        this.servingInfo = servingInfo;
        return (A)this;
    }

    public boolean hasServingInfo() {
        return this.servingInfo != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericOperatorConfigFluent that = (GenericOperatorConfigFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.authentication, that.authentication)) {
            return false;
        }
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.leaderElection, that.leaderElection)) {
            return false;
        }
        if (!Objects.equals(this.servingInfo, that.servingInfo)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.authentication, this.authorization, this.kind, this.leaderElection, this.servingInfo, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.authentication != null) {
            sb.append("authentication:");
            sb.append(this.authentication + ",");
        }
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.leaderElection != null) {
            sb.append("leaderElection:");
            sb.append(this.leaderElection + ",");
        }
        if (this.servingInfo != null) {
            sb.append("servingInfo:");
            sb.append(this.servingInfo + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AuthorizationNested<N>
    extends DelegatedAuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        DelegatedAuthorizationBuilder builder;

        AuthorizationNested(DelegatedAuthorization item) {
            this.builder = new DelegatedAuthorizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GenericOperatorConfigFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }

    public class AuthenticationNested<N>
    extends DelegatedAuthenticationFluent<AuthenticationNested<N>>
    implements Nested<N> {
        DelegatedAuthenticationBuilder builder;

        AuthenticationNested(DelegatedAuthentication item) {
            this.builder = new DelegatedAuthenticationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GenericOperatorConfigFluent.this.withAuthentication(this.builder.build());
        }

        public N endAuthentication() {
            return this.and();
        }
    }
}

