/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.imageregistry.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.AzureNetworkAccess;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.AzureNetworkAccessBuilder;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.AzureNetworkAccessFluent;
import io.fabric8.openshift.api.model.operator.imageregistry.v1.ImageRegistryConfigStorageAzure;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ImageRegistryConfigStorageAzureFluent<A extends ImageRegistryConfigStorageAzureFluent<A>>
extends BaseFluent<A> {
    private String accountName;
    private String cloudName;
    private String container;
    private AzureNetworkAccessBuilder networkAccess;
    private Map<String, Object> additionalProperties;

    public ImageRegistryConfigStorageAzureFluent() {
    }

    public ImageRegistryConfigStorageAzureFluent(ImageRegistryConfigStorageAzure instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageRegistryConfigStorageAzure instance) {
        ImageRegistryConfigStorageAzure imageRegistryConfigStorageAzure = instance = instance != null ? instance : new ImageRegistryConfigStorageAzure();
        if (instance != null) {
            this.withAccountName(instance.getAccountName());
            this.withCloudName(instance.getCloudName());
            this.withContainer(instance.getContainer());
            this.withNetworkAccess(instance.getNetworkAccess());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAccountName() {
        return this.accountName;
    }

    public A withAccountName(String accountName) {
        this.accountName = accountName;
        return (A)this;
    }

    public boolean hasAccountName() {
        return this.accountName != null;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public A withCloudName(String cloudName) {
        this.cloudName = cloudName;
        return (A)this;
    }

    public boolean hasCloudName() {
        return this.cloudName != null;
    }

    public String getContainer() {
        return this.container;
    }

    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    public boolean hasContainer() {
        return this.container != null;
    }

    public AzureNetworkAccess buildNetworkAccess() {
        return this.networkAccess != null ? this.networkAccess.build() : null;
    }

    public A withNetworkAccess(AzureNetworkAccess networkAccess) {
        this._visitables.remove("networkAccess");
        if (networkAccess != null) {
            this.networkAccess = new AzureNetworkAccessBuilder(networkAccess);
            this._visitables.get("networkAccess").add(this.networkAccess);
        } else {
            this.networkAccess = null;
            this._visitables.get("networkAccess").remove(this.networkAccess);
        }
        return (A)this;
    }

    public boolean hasNetworkAccess() {
        return this.networkAccess != null;
    }

    public NetworkAccessNested<A> withNewNetworkAccess() {
        return new NetworkAccessNested(null);
    }

    public NetworkAccessNested<A> withNewNetworkAccessLike(AzureNetworkAccess item) {
        return new NetworkAccessNested(item);
    }

    public NetworkAccessNested<A> editNetworkAccess() {
        return this.withNewNetworkAccessLike(Optional.ofNullable(this.buildNetworkAccess()).orElse(null));
    }

    public NetworkAccessNested<A> editOrNewNetworkAccess() {
        return this.withNewNetworkAccessLike(Optional.ofNullable(this.buildNetworkAccess()).orElse(new AzureNetworkAccessBuilder().build()));
    }

    public NetworkAccessNested<A> editOrNewNetworkAccessLike(AzureNetworkAccess item) {
        return this.withNewNetworkAccessLike(Optional.ofNullable(this.buildNetworkAccess()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageRegistryConfigStorageAzureFluent that = (ImageRegistryConfigStorageAzureFluent)o;
        if (!Objects.equals(this.accountName, that.accountName)) {
            return false;
        }
        if (!Objects.equals(this.cloudName, that.cloudName)) {
            return false;
        }
        if (!Objects.equals(this.container, that.container)) {
            return false;
        }
        if (!Objects.equals(this.networkAccess, that.networkAccess)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.accountName, this.cloudName, this.container, this.networkAccess, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountName != null) {
            sb.append("accountName:");
            sb.append(this.accountName + ",");
        }
        if (this.cloudName != null) {
            sb.append("cloudName:");
            sb.append(this.cloudName + ",");
        }
        if (this.container != null) {
            sb.append("container:");
            sb.append(this.container + ",");
        }
        if (this.networkAccess != null) {
            sb.append("networkAccess:");
            sb.append(this.networkAccess + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NetworkAccessNested<N>
    extends AzureNetworkAccessFluent<NetworkAccessNested<N>>
    implements Nested<N> {
        AzureNetworkAccessBuilder builder;

        NetworkAccessNested(AzureNetworkAccess item) {
            this.builder = new AzureNetworkAccessBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageRegistryConfigStorageAzureFluent.this.withNetworkAccess(this.builder.build());
        }

        public N endNetworkAccess() {
            return this.and();
        }
    }
}

