/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.GCPProviderSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GCPProviderSpecFluent<A extends GCPProviderSpecFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String audience;
    private String kind;
    private List<String> permissions = new ArrayList<String>();
    private List<String> predefinedRoles = new ArrayList<String>();
    private String serviceAccountEmail;
    private Boolean skipServiceCheck;
    private Map<String, Object> additionalProperties;

    public GCPProviderSpecFluent() {
    }

    public GCPProviderSpecFluent(GCPProviderSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GCPProviderSpec instance) {
        GCPProviderSpec gCPProviderSpec = instance = instance != null ? instance : new GCPProviderSpec();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withAudience(instance.getAudience());
            this.withKind(instance.getKind());
            this.withPermissions(instance.getPermissions());
            this.withPredefinedRoles(instance.getPredefinedRoles());
            this.withServiceAccountEmail(instance.getServiceAccountEmail());
            this.withSkipServiceCheck(instance.getSkipServiceCheck());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getAudience() {
        return this.audience;
    }

    public A withAudience(String audience) {
        this.audience = audience;
        return (A)this;
    }

    public boolean hasAudience() {
        return this.audience != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToPermissions(int index, String item) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(index, item);
        return (A)this;
    }

    public A setToPermissions(int index, String item) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.set(index, item);
        return (A)this;
    }

    public A addToPermissions(String ... items) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        for (String item : items) {
            this.permissions.add(item);
        }
        return (A)this;
    }

    public A addAllToPermissions(Collection<String> items) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        for (String item : items) {
            this.permissions.add(item);
        }
        return (A)this;
    }

    public A removeFromPermissions(String ... items) {
        if (this.permissions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.permissions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPermissions(Collection<String> items) {
        if (this.permissions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.permissions.remove(item);
        }
        return (A)this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public String getPermission(int index) {
        return this.permissions.get(index);
    }

    public String getFirstPermission() {
        return this.permissions.get(0);
    }

    public String getLastPermission() {
        return this.permissions.get(this.permissions.size() - 1);
    }

    public String getMatchingPermission(Predicate<String> predicate) {
        for (String item : this.permissions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPermission(Predicate<String> predicate) {
        for (String item : this.permissions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPermissions(List<String> permissions) {
        if (permissions != null) {
            this.permissions = new ArrayList<String>();
            for (String item : permissions) {
                this.addToPermissions(item);
            }
        } else {
            this.permissions = null;
        }
        return (A)this;
    }

    public A withPermissions(String ... permissions) {
        if (this.permissions != null) {
            this.permissions.clear();
            this._visitables.remove("permissions");
        }
        if (permissions != null) {
            for (String item : permissions) {
                this.addToPermissions(item);
            }
        }
        return (A)this;
    }

    public boolean hasPermissions() {
        return this.permissions != null && !this.permissions.isEmpty();
    }

    public A addToPredefinedRoles(int index, String item) {
        if (this.predefinedRoles == null) {
            this.predefinedRoles = new ArrayList<String>();
        }
        this.predefinedRoles.add(index, item);
        return (A)this;
    }

    public A setToPredefinedRoles(int index, String item) {
        if (this.predefinedRoles == null) {
            this.predefinedRoles = new ArrayList<String>();
        }
        this.predefinedRoles.set(index, item);
        return (A)this;
    }

    public A addToPredefinedRoles(String ... items) {
        if (this.predefinedRoles == null) {
            this.predefinedRoles = new ArrayList<String>();
        }
        for (String item : items) {
            this.predefinedRoles.add(item);
        }
        return (A)this;
    }

    public A addAllToPredefinedRoles(Collection<String> items) {
        if (this.predefinedRoles == null) {
            this.predefinedRoles = new ArrayList<String>();
        }
        for (String item : items) {
            this.predefinedRoles.add(item);
        }
        return (A)this;
    }

    public A removeFromPredefinedRoles(String ... items) {
        if (this.predefinedRoles == null) {
            return (A)this;
        }
        for (String item : items) {
            this.predefinedRoles.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPredefinedRoles(Collection<String> items) {
        if (this.predefinedRoles == null) {
            return (A)this;
        }
        for (String item : items) {
            this.predefinedRoles.remove(item);
        }
        return (A)this;
    }

    public List<String> getPredefinedRoles() {
        return this.predefinedRoles;
    }

    public String getPredefinedRole(int index) {
        return this.predefinedRoles.get(index);
    }

    public String getFirstPredefinedRole() {
        return this.predefinedRoles.get(0);
    }

    public String getLastPredefinedRole() {
        return this.predefinedRoles.get(this.predefinedRoles.size() - 1);
    }

    public String getMatchingPredefinedRole(Predicate<String> predicate) {
        for (String item : this.predefinedRoles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPredefinedRole(Predicate<String> predicate) {
        for (String item : this.predefinedRoles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPredefinedRoles(List<String> predefinedRoles) {
        if (predefinedRoles != null) {
            this.predefinedRoles = new ArrayList<String>();
            for (String item : predefinedRoles) {
                this.addToPredefinedRoles(item);
            }
        } else {
            this.predefinedRoles = null;
        }
        return (A)this;
    }

    public A withPredefinedRoles(String ... predefinedRoles) {
        if (this.predefinedRoles != null) {
            this.predefinedRoles.clear();
            this._visitables.remove("predefinedRoles");
        }
        if (predefinedRoles != null) {
            for (String item : predefinedRoles) {
                this.addToPredefinedRoles(item);
            }
        }
        return (A)this;
    }

    public boolean hasPredefinedRoles() {
        return this.predefinedRoles != null && !this.predefinedRoles.isEmpty();
    }

    public String getServiceAccountEmail() {
        return this.serviceAccountEmail;
    }

    public A withServiceAccountEmail(String serviceAccountEmail) {
        this.serviceAccountEmail = serviceAccountEmail;
        return (A)this;
    }

    public boolean hasServiceAccountEmail() {
        return this.serviceAccountEmail != null;
    }

    public Boolean getSkipServiceCheck() {
        return this.skipServiceCheck;
    }

    public A withSkipServiceCheck(Boolean skipServiceCheck) {
        this.skipServiceCheck = skipServiceCheck;
        return (A)this;
    }

    public boolean hasSkipServiceCheck() {
        return this.skipServiceCheck != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GCPProviderSpecFluent that = (GCPProviderSpecFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.audience, that.audience)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.permissions, that.permissions)) {
            return false;
        }
        if (!Objects.equals(this.predefinedRoles, that.predefinedRoles)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountEmail, that.serviceAccountEmail)) {
            return false;
        }
        if (!Objects.equals(this.skipServiceCheck, that.skipServiceCheck)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.audience, this.kind, this.permissions, this.predefinedRoles, this.serviceAccountEmail, this.skipServiceCheck, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.audience != null) {
            sb.append("audience:");
            sb.append(this.audience + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.permissions != null && !this.permissions.isEmpty()) {
            sb.append("permissions:");
            sb.append(this.permissions + ",");
        }
        if (this.predefinedRoles != null && !this.predefinedRoles.isEmpty()) {
            sb.append("predefinedRoles:");
            sb.append(this.predefinedRoles + ",");
        }
        if (this.serviceAccountEmail != null) {
            sb.append("serviceAccountEmail:");
            sb.append(this.serviceAccountEmail + ",");
        }
        if (this.skipServiceCheck != null) {
            sb.append("skipServiceCheck:");
            sb.append(this.skipServiceCheck + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSkipServiceCheck() {
        return this.withSkipServiceCheck(true);
    }
}

