/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReference;
import io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReferenceBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.AWSResourceReferenceFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.EBSBlockDeviceSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EBSBlockDeviceSpecFluent<A extends EBSBlockDeviceSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean deleteOnTermination;
    private Boolean encrypted;
    private Long iops;
    private AWSResourceReferenceBuilder kmsKey;
    private Long volumeSize;
    private String volumeType;
    private Map<String, Object> additionalProperties;

    public EBSBlockDeviceSpecFluent() {
    }

    public EBSBlockDeviceSpecFluent(EBSBlockDeviceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EBSBlockDeviceSpec instance) {
        EBSBlockDeviceSpec eBSBlockDeviceSpec = instance = instance != null ? instance : new EBSBlockDeviceSpec();
        if (instance != null) {
            this.withDeleteOnTermination(instance.getDeleteOnTermination());
            this.withEncrypted(instance.getEncrypted());
            this.withIops(instance.getIops());
            this.withKmsKey(instance.getKmsKey());
            this.withVolumeSize(instance.getVolumeSize());
            this.withVolumeType(instance.getVolumeType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public A withDeleteOnTermination(Boolean deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination;
        return (A)this;
    }

    public boolean hasDeleteOnTermination() {
        return this.deleteOnTermination != null;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public A withEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
        return (A)this;
    }

    public boolean hasEncrypted() {
        return this.encrypted != null;
    }

    public Long getIops() {
        return this.iops;
    }

    public A withIops(Long iops) {
        this.iops = iops;
        return (A)this;
    }

    public boolean hasIops() {
        return this.iops != null;
    }

    public AWSResourceReference buildKmsKey() {
        return this.kmsKey != null ? this.kmsKey.build() : null;
    }

    public A withKmsKey(AWSResourceReference kmsKey) {
        this._visitables.remove("kmsKey");
        if (kmsKey != null) {
            this.kmsKey = new AWSResourceReferenceBuilder(kmsKey);
            this._visitables.get("kmsKey").add(this.kmsKey);
        } else {
            this.kmsKey = null;
            this._visitables.get("kmsKey").remove(this.kmsKey);
        }
        return (A)this;
    }

    public boolean hasKmsKey() {
        return this.kmsKey != null;
    }

    public KmsKeyNested<A> withNewKmsKey() {
        return new KmsKeyNested(null);
    }

    public KmsKeyNested<A> withNewKmsKeyLike(AWSResourceReference item) {
        return new KmsKeyNested(item);
    }

    public KmsKeyNested<A> editKmsKey() {
        return this.withNewKmsKeyLike(Optional.ofNullable(this.buildKmsKey()).orElse(null));
    }

    public KmsKeyNested<A> editOrNewKmsKey() {
        return this.withNewKmsKeyLike(Optional.ofNullable(this.buildKmsKey()).orElse(new AWSResourceReferenceBuilder().build()));
    }

    public KmsKeyNested<A> editOrNewKmsKeyLike(AWSResourceReference item) {
        return this.withNewKmsKeyLike(Optional.ofNullable(this.buildKmsKey()).orElse(item));
    }

    public Long getVolumeSize() {
        return this.volumeSize;
    }

    public A withVolumeSize(Long volumeSize) {
        this.volumeSize = volumeSize;
        return (A)this;
    }

    public boolean hasVolumeSize() {
        return this.volumeSize != null;
    }

    public String getVolumeType() {
        return this.volumeType;
    }

    public A withVolumeType(String volumeType) {
        this.volumeType = volumeType;
        return (A)this;
    }

    public boolean hasVolumeType() {
        return this.volumeType != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EBSBlockDeviceSpecFluent that = (EBSBlockDeviceSpecFluent)o;
        if (!Objects.equals(this.deleteOnTermination, that.deleteOnTermination)) {
            return false;
        }
        if (!Objects.equals(this.encrypted, that.encrypted)) {
            return false;
        }
        if (!Objects.equals(this.iops, that.iops)) {
            return false;
        }
        if (!Objects.equals(this.kmsKey, that.kmsKey)) {
            return false;
        }
        if (!Objects.equals(this.volumeSize, that.volumeSize)) {
            return false;
        }
        if (!Objects.equals(this.volumeType, that.volumeType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.deleteOnTermination, this.encrypted, this.iops, this.kmsKey, this.volumeSize, this.volumeType, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deleteOnTermination != null) {
            sb.append("deleteOnTermination:");
            sb.append(this.deleteOnTermination + ",");
        }
        if (this.encrypted != null) {
            sb.append("encrypted:");
            sb.append(this.encrypted + ",");
        }
        if (this.iops != null) {
            sb.append("iops:");
            sb.append(this.iops + ",");
        }
        if (this.kmsKey != null) {
            sb.append("kmsKey:");
            sb.append(this.kmsKey + ",");
        }
        if (this.volumeSize != null) {
            sb.append("volumeSize:");
            sb.append(this.volumeSize + ",");
        }
        if (this.volumeType != null) {
            sb.append("volumeType:");
            sb.append(this.volumeType + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDeleteOnTermination() {
        return this.withDeleteOnTermination(true);
    }

    public A withEncrypted() {
        return this.withEncrypted(true);
    }

    public class KmsKeyNested<N>
    extends AWSResourceReferenceFluent<KmsKeyNested<N>>
    implements Nested<N> {
        AWSResourceReferenceBuilder builder;

        KmsKeyNested(AWSResourceReference item) {
            this.builder = new AWSResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EBSBlockDeviceSpecFluent.this.withKmsKey(this.builder.build());
        }

        public N endKmsKey() {
            return this.and();
        }
    }
}

