/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpec;
import io.fabric8.openshift.api.model.console.v1.Link;
import io.fabric8.openshift.api.model.console.v1.LinkBuilder;
import io.fabric8.openshift.api.model.console.v1.LinkFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConsoleNotificationSpecFluent<A extends ConsoleNotificationSpecFluent<A>>
extends BaseFluent<A> {
    private String backgroundColor;
    private String color;
    private LinkBuilder link;
    private String location;
    private String text;
    private Map<String, Object> additionalProperties;

    public ConsoleNotificationSpecFluent() {
    }

    public ConsoleNotificationSpecFluent(ConsoleNotificationSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConsoleNotificationSpec instance) {
        ConsoleNotificationSpec consoleNotificationSpec = instance = instance != null ? instance : new ConsoleNotificationSpec();
        if (instance != null) {
            this.withBackgroundColor(instance.getBackgroundColor());
            this.withColor(instance.getColor());
            this.withLink(instance.getLink());
            this.withLocation(instance.getLocation());
            this.withText(instance.getText());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public A withBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return (A)this;
    }

    public boolean hasBackgroundColor() {
        return this.backgroundColor != null;
    }

    public String getColor() {
        return this.color;
    }

    public A withColor(String color) {
        this.color = color;
        return (A)this;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    public Link buildLink() {
        return this.link != null ? this.link.build() : null;
    }

    public A withLink(Link link) {
        this._visitables.remove("link");
        if (link != null) {
            this.link = new LinkBuilder(link);
            this._visitables.get("link").add(this.link);
        } else {
            this.link = null;
            this._visitables.get("link").remove(this.link);
        }
        return (A)this;
    }

    public boolean hasLink() {
        return this.link != null;
    }

    public A withNewLink(String href, String text) {
        return this.withLink(new Link(href, text));
    }

    public LinkNested<A> withNewLink() {
        return new LinkNested(null);
    }

    public LinkNested<A> withNewLinkLike(Link item) {
        return new LinkNested(item);
    }

    public LinkNested<A> editLink() {
        return this.withNewLinkLike(Optional.ofNullable(this.buildLink()).orElse(null));
    }

    public LinkNested<A> editOrNewLink() {
        return this.withNewLinkLike(Optional.ofNullable(this.buildLink()).orElse(new LinkBuilder().build()));
    }

    public LinkNested<A> editOrNewLinkLike(Link item) {
        return this.withNewLinkLike(Optional.ofNullable(this.buildLink()).orElse(item));
    }

    public String getLocation() {
        return this.location;
    }

    public A withLocation(String location) {
        this.location = location;
        return (A)this;
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public String getText() {
        return this.text;
    }

    public A withText(String text) {
        this.text = text;
        return (A)this;
    }

    public boolean hasText() {
        return this.text != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsoleNotificationSpecFluent that = (ConsoleNotificationSpecFluent)o;
        if (!Objects.equals(this.backgroundColor, that.backgroundColor)) {
            return false;
        }
        if (!Objects.equals(this.color, that.color)) {
            return false;
        }
        if (!Objects.equals(this.link, that.link)) {
            return false;
        }
        if (!Objects.equals(this.location, that.location)) {
            return false;
        }
        if (!Objects.equals(this.text, that.text)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backgroundColor, this.color, this.link, this.location, this.text, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backgroundColor != null) {
            sb.append("backgroundColor:");
            sb.append(this.backgroundColor + ",");
        }
        if (this.color != null) {
            sb.append("color:");
            sb.append(this.color + ",");
        }
        if (this.link != null) {
            sb.append("link:");
            sb.append(this.link + ",");
        }
        if (this.location != null) {
            sb.append("location:");
            sb.append(this.location + ",");
        }
        if (this.text != null) {
            sb.append("text:");
            sb.append(this.text + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LinkNested<N>
    extends LinkFluent<LinkNested<N>>
    implements Nested<N> {
        LinkBuilder builder;

        LinkNested(Link item) {
            this.builder = new LinkBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConsoleNotificationSpecFluent.this.withLink(this.builder.build());
        }

        public N endLink() {
            return this.and();
        }
    }
}

