/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerConfig;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerIPs;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerIPsBuilder;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerIPsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CloudLoadBalancerConfigFluent<A extends CloudLoadBalancerConfigFluent<A>>
extends BaseFluent<A> {
    private CloudLoadBalancerIPsBuilder clusterHosted;
    private String dnsType;
    private Map<String, Object> additionalProperties;

    public CloudLoadBalancerConfigFluent() {
    }

    public CloudLoadBalancerConfigFluent(CloudLoadBalancerConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CloudLoadBalancerConfig instance) {
        CloudLoadBalancerConfig cloudLoadBalancerConfig = instance = instance != null ? instance : new CloudLoadBalancerConfig();
        if (instance != null) {
            this.withClusterHosted(instance.getClusterHosted());
            this.withDnsType(instance.getDnsType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CloudLoadBalancerIPs buildClusterHosted() {
        return this.clusterHosted != null ? this.clusterHosted.build() : null;
    }

    public A withClusterHosted(CloudLoadBalancerIPs clusterHosted) {
        this._visitables.remove("clusterHosted");
        if (clusterHosted != null) {
            this.clusterHosted = new CloudLoadBalancerIPsBuilder(clusterHosted);
            this._visitables.get("clusterHosted").add(this.clusterHosted);
        } else {
            this.clusterHosted = null;
            this._visitables.get("clusterHosted").remove(this.clusterHosted);
        }
        return (A)this;
    }

    public boolean hasClusterHosted() {
        return this.clusterHosted != null;
    }

    public ClusterHostedNested<A> withNewClusterHosted() {
        return new ClusterHostedNested(null);
    }

    public ClusterHostedNested<A> withNewClusterHostedLike(CloudLoadBalancerIPs item) {
        return new ClusterHostedNested(item);
    }

    public ClusterHostedNested<A> editClusterHosted() {
        return this.withNewClusterHostedLike(Optional.ofNullable(this.buildClusterHosted()).orElse(null));
    }

    public ClusterHostedNested<A> editOrNewClusterHosted() {
        return this.withNewClusterHostedLike(Optional.ofNullable(this.buildClusterHosted()).orElse(new CloudLoadBalancerIPsBuilder().build()));
    }

    public ClusterHostedNested<A> editOrNewClusterHostedLike(CloudLoadBalancerIPs item) {
        return this.withNewClusterHostedLike(Optional.ofNullable(this.buildClusterHosted()).orElse(item));
    }

    public String getDnsType() {
        return this.dnsType;
    }

    public A withDnsType(String dnsType) {
        this.dnsType = dnsType;
        return (A)this;
    }

    public boolean hasDnsType() {
        return this.dnsType != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudLoadBalancerConfigFluent that = (CloudLoadBalancerConfigFluent)o;
        if (!Objects.equals(this.clusterHosted, that.clusterHosted)) {
            return false;
        }
        if (!Objects.equals(this.dnsType, that.dnsType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterHosted, this.dnsType, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterHosted != null) {
            sb.append("clusterHosted:");
            sb.append(this.clusterHosted + ",");
        }
        if (this.dnsType != null) {
            sb.append("dnsType:");
            sb.append(this.dnsType + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClusterHostedNested<N>
    extends CloudLoadBalancerIPsFluent<ClusterHostedNested<N>>
    implements Nested<N> {
        CloudLoadBalancerIPsBuilder builder;

        ClusterHostedNested(CloudLoadBalancerIPs item) {
            this.builder = new CloudLoadBalancerIPsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CloudLoadBalancerConfigFluent.this.withClusterHosted(this.builder.build());
        }

        public N endClusterHosted() {
            return this.and();
        }
    }
}

