/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.RouteHTTPHeader;
import io.fabric8.openshift.api.model.RouteHTTPHeaderActions;
import io.fabric8.openshift.api.model.RouteHTTPHeaderBuilder;
import io.fabric8.openshift.api.model.RouteHTTPHeaderFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteHTTPHeaderActionsFluent<A extends RouteHTTPHeaderActionsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RouteHTTPHeaderBuilder> request = new ArrayList();
    private ArrayList<RouteHTTPHeaderBuilder> response = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RouteHTTPHeaderActionsFluent() {
    }

    public RouteHTTPHeaderActionsFluent(RouteHTTPHeaderActions instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RouteHTTPHeaderActions instance) {
        RouteHTTPHeaderActions routeHTTPHeaderActions = instance = instance != null ? instance : new RouteHTTPHeaderActions();
        if (instance != null) {
            this.withRequest(instance.getRequest());
            this.withResponse(instance.getResponse());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToRequest(int index, RouteHTTPHeader item) {
        if (this.request == null) {
            this.request = new ArrayList();
        }
        RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
        if (index < 0 || index >= this.request.size()) {
            this._visitables.get("request").add(builder);
            this.request.add(builder);
        } else {
            this._visitables.get("request").add(index, builder);
            this.request.add(index, builder);
        }
        return (A)this;
    }

    public A setToRequest(int index, RouteHTTPHeader item) {
        if (this.request == null) {
            this.request = new ArrayList();
        }
        RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
        if (index < 0 || index >= this.request.size()) {
            this._visitables.get("request").add(builder);
            this.request.add(builder);
        } else {
            this._visitables.get("request").set(index, builder);
            this.request.set(index, builder);
        }
        return (A)this;
    }

    public A addToRequest(RouteHTTPHeader ... items) {
        if (this.request == null) {
            this.request = new ArrayList();
        }
        for (RouteHTTPHeader item : items) {
            RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
            this._visitables.get("request").add(builder);
            this.request.add(builder);
        }
        return (A)this;
    }

    public A addAllToRequest(Collection<RouteHTTPHeader> items) {
        if (this.request == null) {
            this.request = new ArrayList();
        }
        for (RouteHTTPHeader item : items) {
            RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
            this._visitables.get("request").add(builder);
            this.request.add(builder);
        }
        return (A)this;
    }

    public A removeFromRequest(RouteHTTPHeader ... items) {
        if (this.request == null) {
            return (A)this;
        }
        for (RouteHTTPHeader item : items) {
            RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
            this._visitables.get("request").remove(builder);
            this.request.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRequest(Collection<RouteHTTPHeader> items) {
        if (this.request == null) {
            return (A)this;
        }
        for (RouteHTTPHeader item : items) {
            RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
            this._visitables.get("request").remove(builder);
            this.request.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRequest(Predicate<RouteHTTPHeaderBuilder> predicate) {
        if (this.request == null) {
            return (A)this;
        }
        Iterator<RouteHTTPHeaderBuilder> each = this.request.iterator();
        Object visitables = this._visitables.get("request");
        while (each.hasNext()) {
            RouteHTTPHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RouteHTTPHeader> buildRequest() {
        return this.request != null ? RouteHTTPHeaderActionsFluent.build(this.request) : null;
    }

    public RouteHTTPHeader buildRequest(int index) {
        return this.request.get(index).build();
    }

    public RouteHTTPHeader buildFirstRequest() {
        return this.request.get(0).build();
    }

    public RouteHTTPHeader buildLastRequest() {
        return this.request.get(this.request.size() - 1).build();
    }

    public RouteHTTPHeader buildMatchingRequest(Predicate<RouteHTTPHeaderBuilder> predicate) {
        for (RouteHTTPHeaderBuilder item : this.request) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRequest(Predicate<RouteHTTPHeaderBuilder> predicate) {
        for (RouteHTTPHeaderBuilder item : this.request) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequest(List<RouteHTTPHeader> request) {
        if (this.request != null) {
            this._visitables.get("request").clear();
        }
        if (request != null) {
            this.request = new ArrayList();
            for (RouteHTTPHeader item : request) {
                this.addToRequest(item);
            }
        } else {
            this.request = null;
        }
        return (A)this;
    }

    public A withRequest(RouteHTTPHeader ... request) {
        if (this.request != null) {
            this.request.clear();
            this._visitables.remove("request");
        }
        if (request != null) {
            for (RouteHTTPHeader item : request) {
                this.addToRequest(item);
            }
        }
        return (A)this;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public RequestNested<A> addNewRequest() {
        return new RequestNested(-1, null);
    }

    public RequestNested<A> addNewRequestLike(RouteHTTPHeader item) {
        return new RequestNested(-1, item);
    }

    public RequestNested<A> setNewRequestLike(int index, RouteHTTPHeader item) {
        return new RequestNested(index, item);
    }

    public RequestNested<A> editRequest(int index) {
        if (this.request.size() <= index) {
            throw new RuntimeException("Can't edit request. Index exceeds size.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public RequestNested<A> editFirstRequest() {
        if (this.request.size() == 0) {
            throw new RuntimeException("Can't edit first request. The list is empty.");
        }
        return this.setNewRequestLike(0, this.buildRequest(0));
    }

    public RequestNested<A> editLastRequest() {
        int index = this.request.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last request. The list is empty.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public RequestNested<A> editMatchingRequest(Predicate<RouteHTTPHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.request.size(); ++i) {
            if (!predicate.test(this.request.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching request. No match found.");
        }
        return this.setNewRequestLike(index, this.buildRequest(index));
    }

    public A addToResponse(int index, RouteHTTPHeader item) {
        if (this.response == null) {
            this.response = new ArrayList();
        }
        RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
        if (index < 0 || index >= this.response.size()) {
            this._visitables.get("response").add(builder);
            this.response.add(builder);
        } else {
            this._visitables.get("response").add(index, builder);
            this.response.add(index, builder);
        }
        return (A)this;
    }

    public A setToResponse(int index, RouteHTTPHeader item) {
        if (this.response == null) {
            this.response = new ArrayList();
        }
        RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
        if (index < 0 || index >= this.response.size()) {
            this._visitables.get("response").add(builder);
            this.response.add(builder);
        } else {
            this._visitables.get("response").set(index, builder);
            this.response.set(index, builder);
        }
        return (A)this;
    }

    public A addToResponse(RouteHTTPHeader ... items) {
        if (this.response == null) {
            this.response = new ArrayList();
        }
        for (RouteHTTPHeader item : items) {
            RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
            this._visitables.get("response").add(builder);
            this.response.add(builder);
        }
        return (A)this;
    }

    public A addAllToResponse(Collection<RouteHTTPHeader> items) {
        if (this.response == null) {
            this.response = new ArrayList();
        }
        for (RouteHTTPHeader item : items) {
            RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
            this._visitables.get("response").add(builder);
            this.response.add(builder);
        }
        return (A)this;
    }

    public A removeFromResponse(RouteHTTPHeader ... items) {
        if (this.response == null) {
            return (A)this;
        }
        for (RouteHTTPHeader item : items) {
            RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
            this._visitables.get("response").remove(builder);
            this.response.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResponse(Collection<RouteHTTPHeader> items) {
        if (this.response == null) {
            return (A)this;
        }
        for (RouteHTTPHeader item : items) {
            RouteHTTPHeaderBuilder builder = new RouteHTTPHeaderBuilder(item);
            this._visitables.get("response").remove(builder);
            this.response.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResponse(Predicate<RouteHTTPHeaderBuilder> predicate) {
        if (this.response == null) {
            return (A)this;
        }
        Iterator<RouteHTTPHeaderBuilder> each = this.response.iterator();
        Object visitables = this._visitables.get("response");
        while (each.hasNext()) {
            RouteHTTPHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RouteHTTPHeader> buildResponse() {
        return this.response != null ? RouteHTTPHeaderActionsFluent.build(this.response) : null;
    }

    public RouteHTTPHeader buildResponse(int index) {
        return this.response.get(index).build();
    }

    public RouteHTTPHeader buildFirstResponse() {
        return this.response.get(0).build();
    }

    public RouteHTTPHeader buildLastResponse() {
        return this.response.get(this.response.size() - 1).build();
    }

    public RouteHTTPHeader buildMatchingResponse(Predicate<RouteHTTPHeaderBuilder> predicate) {
        for (RouteHTTPHeaderBuilder item : this.response) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResponse(Predicate<RouteHTTPHeaderBuilder> predicate) {
        for (RouteHTTPHeaderBuilder item : this.response) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResponse(List<RouteHTTPHeader> response) {
        if (this.response != null) {
            this._visitables.get("response").clear();
        }
        if (response != null) {
            this.response = new ArrayList();
            for (RouteHTTPHeader item : response) {
                this.addToResponse(item);
            }
        } else {
            this.response = null;
        }
        return (A)this;
    }

    public A withResponse(RouteHTTPHeader ... response) {
        if (this.response != null) {
            this.response.clear();
            this._visitables.remove("response");
        }
        if (response != null) {
            for (RouteHTTPHeader item : response) {
                this.addToResponse(item);
            }
        }
        return (A)this;
    }

    public boolean hasResponse() {
        return this.response != null && !this.response.isEmpty();
    }

    public ResponseNested<A> addNewResponse() {
        return new ResponseNested(-1, null);
    }

    public ResponseNested<A> addNewResponseLike(RouteHTTPHeader item) {
        return new ResponseNested(-1, item);
    }

    public ResponseNested<A> setNewResponseLike(int index, RouteHTTPHeader item) {
        return new ResponseNested(index, item);
    }

    public ResponseNested<A> editResponse(int index) {
        if (this.response.size() <= index) {
            throw new RuntimeException("Can't edit response. Index exceeds size.");
        }
        return this.setNewResponseLike(index, this.buildResponse(index));
    }

    public ResponseNested<A> editFirstResponse() {
        if (this.response.size() == 0) {
            throw new RuntimeException("Can't edit first response. The list is empty.");
        }
        return this.setNewResponseLike(0, this.buildResponse(0));
    }

    public ResponseNested<A> editLastResponse() {
        int index = this.response.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last response. The list is empty.");
        }
        return this.setNewResponseLike(index, this.buildResponse(index));
    }

    public ResponseNested<A> editMatchingResponse(Predicate<RouteHTTPHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.response.size(); ++i) {
            if (!predicate.test(this.response.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching response. No match found.");
        }
        return this.setNewResponseLike(index, this.buildResponse(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteHTTPHeaderActionsFluent that = (RouteHTTPHeaderActionsFluent)o;
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        if (!Objects.equals(this.response, that.response)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.request, this.response, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.request != null && !this.request.isEmpty()) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.response != null && !this.response.isEmpty()) {
            sb.append("response:");
            sb.append(this.response + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResponseNested<N>
    extends RouteHTTPHeaderFluent<ResponseNested<N>>
    implements Nested<N> {
        RouteHTTPHeaderBuilder builder;
        int index;

        ResponseNested(int index, RouteHTTPHeader item) {
            this.index = index;
            this.builder = new RouteHTTPHeaderBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteHTTPHeaderActionsFluent.this.setToResponse(this.index, this.builder.build());
        }

        public N endResponse() {
            return this.and();
        }
    }

    public class RequestNested<N>
    extends RouteHTTPHeaderFluent<RequestNested<N>>
    implements Nested<N> {
        RouteHTTPHeaderBuilder builder;
        int index;

        RequestNested(int index, RouteHTTPHeader item) {
            this.index = index;
            this.builder = new RouteHTTPHeaderBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteHTTPHeaderActionsFluent.this.setToRequest(this.index, this.builder.build());
        }

        public N endRequest() {
            return this.and();
        }
    }
}

