/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal.build;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.OperationInfo;
import io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimestampBytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.internal.PodOperationUtil;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildOperationsImpl
extends HasMetadataOperation<Build, BuildList, BuildResource>
implements BuildResource {
    public static final String OPENSHIFT_IO_BUILD_NAME = "openshift.io/build.name";
    private Integer version;
    private final PodOperationContext operationContext;

    public BuildOperationsImpl(Client client) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext(client), null);
    }

    public BuildOperationsImpl(PodOperationContext context, OperationContext superContext, Integer version) {
        super(superContext.withApiGroupName("build.openshift.io").withPlural("builds"), Build.class, BuildList.class);
        this.operationContext = context;
        this.context = superContext;
        this.version = version;
    }

    @Override
    public BuildOperationsImpl newInstance(OperationContext context) {
        return new BuildOperationsImpl(this.operationContext, context, this.version);
    }

    PodOperationContext getContext() {
        return this.operationContext;
    }

    protected String getLogParameters() {
        Object params = this.operationContext.getLogParameters();
        if (this.version != null) {
            params = (String)params + "&version=" + this.version;
        }
        return params;
    }

    protected <T> T doGetLog(Class<T> type) {
        try {
            URL url = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.getLogParameters()}));
            return this.handleRawGet(url, type);
        }
        catch (IOException t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("doGetLog"), (Throwable)t);
        }
    }

    public String getLog() {
        return this.doGetLog(String.class);
    }

    public String getLog(boolean isPretty) {
        return new BuildOperationsImpl(this.getContext().withPrettyOutput(isPretty), this.context, this.version).getLog();
    }

    public Reader getLogReader() {
        return this.doGetLog(Reader.class);
    }

    public InputStream getLogInputStream() {
        return this.doGetLog(InputStream.class);
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    public LogWatch watchLog(OutputStream out) {
        try {
            this.waitUntilBuildPodBecomesReady((Build)this.get());
            URL url = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.getLogParameters() + "&follow=true"}));
            LogWatchCallback callback = new LogWatchCallback(out, this.context);
            return callback.callAndWait(this.httpClient, url);
        }
        catch (IOException t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("watchLog"), (Throwable)t);
        }
    }

    public Loggable withLogWaitTimeout(Integer logWaitTimeout) {
        return this.withReadyWaitTimeout(logWaitTimeout);
    }

    public Loggable withReadyWaitTimeout(Integer timeout) {
        return new BuildOperationsImpl(this.getContext().withReadyWaitTimeout(timeout), this.context, this.version);
    }

    public Loggable withPrettyOutput() {
        return new BuildOperationsImpl(this.getContext().withPrettyOutput(true), this.context, this.version);
    }

    public PrettyLoggable tailingLines(int tailingLines) {
        return new BuildOperationsImpl(this.getContext().withTailingLines(tailingLines), this.context, this.version);
    }

    public TimeTailPrettyLoggable terminated() {
        return new BuildOperationsImpl(this.getContext().withTerminatedStatus(true), this.context, this.version);
    }

    public TailPrettyLoggable sinceTime(String sinceTimestamp) {
        return new BuildOperationsImpl(this.getContext().withSinceTimestamp(sinceTimestamp), this.context, this.version);
    }

    public TailPrettyLoggable sinceSeconds(int sinceSeconds) {
        return new BuildOperationsImpl(this.getContext().withSinceSeconds(sinceSeconds), this.context, this.version);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new BuildOperationsImpl(this.getContext().withLimitBytes(limitBytes), this.context, this.version);
    }

    public TimestampBytesLimitTerminateTimeTailPrettyLoggable withVersion(Integer version) {
        return new BuildOperationsImpl(this.getContext(), this.context, version);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new BuildOperationsImpl(this.getContext().withTimestamps(true), this.context, this.version);
    }

    private void waitUntilBuildPodBecomesReady(Build build) {
        List<PodResource> podOps = PodOperationUtil.getPodOperationsForController(this.context, this.operationContext, build.getMetadata().getUid(), BuildOperationsImpl.getBuildPodLabels(build));
        BuildOperationsImpl.waitForBuildPodToBecomeReady(podOps, this.operationContext.getReadyWaitTimeout() != null ? this.operationContext.getReadyWaitTimeout() : 0);
    }

    private static void waitForBuildPodToBecomeReady(List<PodResource> podOps, Integer podLogWaitTimeout) {
        for (PodResource podOp : podOps) {
            PodOperationUtil.waitUntilReadyOrTerminal(podOp, podLogWaitTimeout);
        }
    }

    static Map<String, String> getBuildPodLabels(Build build) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (build != null && build.getMetadata() != null) {
            labels.put(OPENSHIFT_IO_BUILD_NAME, build.getMetadata().getName());
        }
        return labels;
    }
}

