/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.AttachMetadata;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.AttachMetadataBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.AttachMetadataFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.K8SSelectorConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.K8SSelectorConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.K8SSelectorConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KubernetesSDConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.NamespaceDiscovery;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.NamespaceDiscoveryBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.NamespaceDiscoveryFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KubernetesSDConfigFluent<A extends KubernetesSDConfigFluent<A>>
extends BaseFluent<A> {
    private String apiServer;
    private AttachMetadataBuilder attachMetadata;
    private SafeAuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private Boolean enableHTTP2;
    private Boolean followRedirects;
    private NamespaceDiscoveryBuilder namespaces;
    private String noProxy;
    private OAuth2Builder oauth2;
    private Map<String, List<SecretKeySelector>> proxyConnectHeader;
    private Boolean proxyFromEnvironment;
    private String proxyUrl;
    private String role;
    private ArrayList<K8SSelectorConfigBuilder> selectors = new ArrayList();
    private SafeTLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public KubernetesSDConfigFluent() {
    }

    public KubernetesSDConfigFluent(KubernetesSDConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KubernetesSDConfig instance) {
        KubernetesSDConfig kubernetesSDConfig = instance = instance != null ? instance : new KubernetesSDConfig();
        if (instance != null) {
            this.withApiServer(instance.getApiServer());
            this.withAttachMetadata(instance.getAttachMetadata());
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withEnableHTTP2(instance.getEnableHTTP2());
            this.withFollowRedirects(instance.getFollowRedirects());
            this.withNamespaces(instance.getNamespaces());
            this.withNoProxy(instance.getNoProxy());
            this.withOauth2(instance.getOauth2());
            this.withProxyConnectHeader(instance.getProxyConnectHeader());
            this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
            this.withProxyUrl(instance.getProxyUrl());
            this.withRole(instance.getRole());
            this.withSelectors(instance.getSelectors());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiServer() {
        return this.apiServer;
    }

    public A withApiServer(String apiServer) {
        this.apiServer = apiServer;
        return (A)this;
    }

    public boolean hasApiServer() {
        return this.apiServer != null;
    }

    public AttachMetadata buildAttachMetadata() {
        return this.attachMetadata != null ? this.attachMetadata.build() : null;
    }

    public A withAttachMetadata(AttachMetadata attachMetadata) {
        this._visitables.remove("attachMetadata");
        if (attachMetadata != null) {
            this.attachMetadata = new AttachMetadataBuilder(attachMetadata);
            this._visitables.get("attachMetadata").add(this.attachMetadata);
        } else {
            this.attachMetadata = null;
            this._visitables.get("attachMetadata").remove(this.attachMetadata);
        }
        return (A)this;
    }

    public boolean hasAttachMetadata() {
        return this.attachMetadata != null;
    }

    public A withNewAttachMetadata(Boolean node) {
        return this.withAttachMetadata(new AttachMetadata(node));
    }

    public AttachMetadataNested<A> withNewAttachMetadata() {
        return new AttachMetadataNested(null);
    }

    public AttachMetadataNested<A> withNewAttachMetadataLike(AttachMetadata item) {
        return new AttachMetadataNested(item);
    }

    public AttachMetadataNested<A> editAttachMetadata() {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(null));
    }

    public AttachMetadataNested<A> editOrNewAttachMetadata() {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(new AttachMetadataBuilder().build()));
    }

    public AttachMetadataNested<A> editOrNewAttachMetadataLike(AttachMetadata item) {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(item));
    }

    public SafeAuthorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(SafeAuthorization authorization) {
        this._visitables.remove("authorization");
        if (authorization != null) {
            this.authorization = new SafeAuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get("authorization").remove(this.authorization);
        }
        return (A)this;
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.remove("basicAuth");
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get("basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get("basicAuth").remove(this.basicAuth);
        }
        return (A)this;
    }

    public boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNested(null);
    }

    public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNested(item);
    }

    public BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(null));
    }

    public BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
    }

    public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(item));
    }

    public Boolean getEnableHTTP2() {
        return this.enableHTTP2;
    }

    public A withEnableHTTP2(Boolean enableHTTP2) {
        this.enableHTTP2 = enableHTTP2;
        return (A)this;
    }

    public boolean hasEnableHTTP2() {
        return this.enableHTTP2 != null;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public A withFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return (A)this;
    }

    public boolean hasFollowRedirects() {
        return this.followRedirects != null;
    }

    public NamespaceDiscovery buildNamespaces() {
        return this.namespaces != null ? this.namespaces.build() : null;
    }

    public A withNamespaces(NamespaceDiscovery namespaces) {
        this._visitables.remove("namespaces");
        if (namespaces != null) {
            this.namespaces = new NamespaceDiscoveryBuilder(namespaces);
            this._visitables.get("namespaces").add(this.namespaces);
        } else {
            this.namespaces = null;
            this._visitables.get("namespaces").remove(this.namespaces);
        }
        return (A)this;
    }

    public boolean hasNamespaces() {
        return this.namespaces != null;
    }

    public NamespacesNested<A> withNewNamespaces() {
        return new NamespacesNested(null);
    }

    public NamespacesNested<A> withNewNamespacesLike(NamespaceDiscovery item) {
        return new NamespacesNested(item);
    }

    public NamespacesNested<A> editNamespaces() {
        return this.withNewNamespacesLike(Optional.ofNullable(this.buildNamespaces()).orElse(null));
    }

    public NamespacesNested<A> editOrNewNamespaces() {
        return this.withNewNamespacesLike(Optional.ofNullable(this.buildNamespaces()).orElse(new NamespaceDiscoveryBuilder().build()));
    }

    public NamespacesNested<A> editOrNewNamespacesLike(NamespaceDiscovery item) {
        return this.withNewNamespacesLike(Optional.ofNullable(this.buildNamespaces()).orElse(item));
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)this;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public OAuth2 buildOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    public A withOauth2(OAuth2 oauth2) {
        this._visitables.remove("oauth2");
        if (oauth2 != null) {
            this.oauth2 = new OAuth2Builder(oauth2);
            this._visitables.get("oauth2").add(this.oauth2);
        } else {
            this.oauth2 = null;
            this._visitables.get("oauth2").remove(this.oauth2);
        }
        return (A)this;
    }

    public boolean hasOauth2() {
        return this.oauth2 != null;
    }

    public Oauth2Nested<A> withNewOauth2() {
        return new Oauth2Nested(null);
    }

    public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
        return new Oauth2Nested(item);
    }

    public Oauth2Nested<A> editOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(null));
    }

    public Oauth2Nested<A> editOrNewOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(new OAuth2Builder().build()));
    }

    public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(item));
    }

    public A addToProxyConnectHeader(String key, List<SecretKeySelector> value) {
        if (this.proxyConnectHeader == null && key != null && value != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (key != null && value != null) {
            this.proxyConnectHeader.put(key, value);
        }
        return (A)this;
    }

    public A addToProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null && map != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (map != null) {
            this.proxyConnectHeader.putAll(map);
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(String key) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (key != null && this.proxyConnectHeader != null) {
            this.proxyConnectHeader.remove(key);
        }
        return (A)this;
    }

    public A removeFromProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyConnectHeader == null) continue;
                this.proxyConnectHeader.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, List<SecretKeySelector>> getProxyConnectHeader() {
        return this.proxyConnectHeader;
    }

    public <K, V> A withProxyConnectHeader(Map<String, List<SecretKeySelector>> proxyConnectHeader) {
        this.proxyConnectHeader = proxyConnectHeader == null ? null : new LinkedHashMap<String, List<SecretKeySelector>>(proxyConnectHeader);
        return (A)this;
    }

    public boolean hasProxyConnectHeader() {
        return this.proxyConnectHeader != null;
    }

    public Boolean getProxyFromEnvironment() {
        return this.proxyFromEnvironment;
    }

    public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
        this.proxyFromEnvironment = proxyFromEnvironment;
        return (A)this;
    }

    public boolean hasProxyFromEnvironment() {
        return this.proxyFromEnvironment != null;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)this;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public String getRole() {
        return this.role;
    }

    public A withRole(String role) {
        this.role = role;
        return (A)this;
    }

    public boolean hasRole() {
        return this.role != null;
    }

    public A addToSelectors(int index, K8SSelectorConfig item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        K8SSelectorConfigBuilder builder = new K8SSelectorConfigBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(index, builder);
            this.selectors.add(index, builder);
        }
        return (A)this;
    }

    public A setToSelectors(int index, K8SSelectorConfig item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        K8SSelectorConfigBuilder builder = new K8SSelectorConfigBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").set(index, builder);
            this.selectors.set(index, builder);
        }
        return (A)this;
    }

    public A addToSelectors(K8SSelectorConfig ... items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (K8SSelectorConfig item : items) {
            K8SSelectorConfigBuilder builder = new K8SSelectorConfigBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A addAllToSelectors(Collection<K8SSelectorConfig> items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (K8SSelectorConfig item : items) {
            K8SSelectorConfigBuilder builder = new K8SSelectorConfigBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A removeFromSelectors(K8SSelectorConfig ... items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (K8SSelectorConfig item : items) {
            K8SSelectorConfigBuilder builder = new K8SSelectorConfigBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSelectors(Collection<K8SSelectorConfig> items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (K8SSelectorConfig item : items) {
            K8SSelectorConfigBuilder builder = new K8SSelectorConfigBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSelectors(Predicate<K8SSelectorConfigBuilder> predicate) {
        if (this.selectors == null) {
            return (A)this;
        }
        Iterator<K8SSelectorConfigBuilder> each = this.selectors.iterator();
        Object visitables = this._visitables.get("selectors");
        while (each.hasNext()) {
            K8SSelectorConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<K8SSelectorConfig> buildSelectors() {
        return this.selectors != null ? KubernetesSDConfigFluent.build(this.selectors) : null;
    }

    public K8SSelectorConfig buildSelector(int index) {
        return this.selectors.get(index).build();
    }

    public K8SSelectorConfig buildFirstSelector() {
        return this.selectors.get(0).build();
    }

    public K8SSelectorConfig buildLastSelector() {
        return this.selectors.get(this.selectors.size() - 1).build();
    }

    public K8SSelectorConfig buildMatchingSelector(Predicate<K8SSelectorConfigBuilder> predicate) {
        for (K8SSelectorConfigBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSelector(Predicate<K8SSelectorConfigBuilder> predicate) {
        for (K8SSelectorConfigBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSelectors(List<K8SSelectorConfig> selectors) {
        if (this.selectors != null) {
            this._visitables.get("selectors").clear();
        }
        if (selectors != null) {
            this.selectors = new ArrayList();
            for (K8SSelectorConfig item : selectors) {
                this.addToSelectors(item);
            }
        } else {
            this.selectors = null;
        }
        return (A)this;
    }

    public A withSelectors(K8SSelectorConfig ... selectors) {
        if (this.selectors != null) {
            this.selectors.clear();
            this._visitables.remove("selectors");
        }
        if (selectors != null) {
            for (K8SSelectorConfig item : selectors) {
                this.addToSelectors(item);
            }
        }
        return (A)this;
    }

    public boolean hasSelectors() {
        return this.selectors != null && !this.selectors.isEmpty();
    }

    public A addNewSelector(String field, String label, String role) {
        return this.addToSelectors(new K8SSelectorConfig(field, label, role));
    }

    public SelectorsNested<A> addNewSelector() {
        return new SelectorsNested(-1, null);
    }

    public SelectorsNested<A> addNewSelectorLike(K8SSelectorConfig item) {
        return new SelectorsNested(-1, item);
    }

    public SelectorsNested<A> setNewSelectorLike(int index, K8SSelectorConfig item) {
        return new SelectorsNested(index, item);
    }

    public SelectorsNested<A> editSelector(int index) {
        if (this.selectors.size() <= index) {
            throw new RuntimeException("Can't edit selectors. Index exceeds size.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editFirstSelector() {
        if (this.selectors.size() == 0) {
            throw new RuntimeException("Can't edit first selectors. The list is empty.");
        }
        return this.setNewSelectorLike(0, this.buildSelector(0));
    }

    public SelectorsNested<A> editLastSelector() {
        int index = this.selectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last selectors. The list is empty.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editMatchingSelector(Predicate<K8SSelectorConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (!predicate.test(this.selectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching selectors. No match found.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(SafeTLSConfig tlsConfig) {
        this._visitables.remove("tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesSDConfigFluent that = (KubernetesSDConfigFluent)o;
        if (!Objects.equals(this.apiServer, that.apiServer)) {
            return false;
        }
        if (!Objects.equals(this.attachMetadata, that.attachMetadata)) {
            return false;
        }
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals(this.basicAuth, that.basicAuth)) {
            return false;
        }
        if (!Objects.equals(this.enableHTTP2, that.enableHTTP2)) {
            return false;
        }
        if (!Objects.equals(this.followRedirects, that.followRedirects)) {
            return false;
        }
        if (!Objects.equals(this.namespaces, that.namespaces)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.oauth2, that.oauth2)) {
            return false;
        }
        if (!Objects.equals(this.proxyConnectHeader, that.proxyConnectHeader)) {
            return false;
        }
        if (!Objects.equals(this.proxyFromEnvironment, that.proxyFromEnvironment)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.role, that.role)) {
            return false;
        }
        if (!Objects.equals(this.selectors, that.selectors)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiServer, this.attachMetadata, this.authorization, this.basicAuth, this.enableHTTP2, this.followRedirects, this.namespaces, this.noProxy, this.oauth2, this.proxyConnectHeader, this.proxyFromEnvironment, this.proxyUrl, this.role, this.selectors, this.tlsConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiServer != null) {
            sb.append("apiServer:");
            sb.append(this.apiServer + ",");
        }
        if (this.attachMetadata != null) {
            sb.append("attachMetadata:");
            sb.append(this.attachMetadata + ",");
        }
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization + ",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append(this.basicAuth + ",");
        }
        if (this.enableHTTP2 != null) {
            sb.append("enableHTTP2:");
            sb.append(this.enableHTTP2 + ",");
        }
        if (this.followRedirects != null) {
            sb.append("followRedirects:");
            sb.append(this.followRedirects + ",");
        }
        if (this.namespaces != null) {
            sb.append("namespaces:");
            sb.append(this.namespaces + ",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy + ",");
        }
        if (this.oauth2 != null) {
            sb.append("oauth2:");
            sb.append(this.oauth2 + ",");
        }
        if (this.proxyConnectHeader != null && !this.proxyConnectHeader.isEmpty()) {
            sb.append("proxyConnectHeader:");
            sb.append(this.proxyConnectHeader + ",");
        }
        if (this.proxyFromEnvironment != null) {
            sb.append("proxyFromEnvironment:");
            sb.append(this.proxyFromEnvironment + ",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl + ",");
        }
        if (this.role != null) {
            sb.append("role:");
            sb.append(this.role + ",");
        }
        if (this.selectors != null && !this.selectors.isEmpty()) {
            sb.append("selectors:");
            sb.append(this.selectors + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnableHTTP2() {
        return this.withEnableHTTP2(true);
    }

    public A withFollowRedirects() {
        return this.withFollowRedirects(true);
    }

    public A withProxyFromEnvironment() {
        return this.withProxyFromEnvironment(true);
    }

    public class TlsConfigNested<N>
    extends SafeTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        TlsConfigNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)KubernetesSDConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class SelectorsNested<N>
    extends K8SSelectorConfigFluent<SelectorsNested<N>>
    implements Nested<N> {
        K8SSelectorConfigBuilder builder;
        int index;

        SelectorsNested(int index, K8SSelectorConfig item) {
            this.index = index;
            this.builder = new K8SSelectorConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)KubernetesSDConfigFluent.this.setToSelectors(this.index, this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class Oauth2Nested<N>
    extends OAuth2Fluent<Oauth2Nested<N>>
    implements Nested<N> {
        OAuth2Builder builder;

        Oauth2Nested(OAuth2 item) {
            this.builder = new OAuth2Builder(this, item);
        }

        @Override
        public N and() {
            return (N)KubernetesSDConfigFluent.this.withOauth2(this.builder.build());
        }

        public N endOauth2() {
            return this.and();
        }
    }

    public class NamespacesNested<N>
    extends NamespaceDiscoveryFluent<NamespacesNested<N>>
    implements Nested<N> {
        NamespaceDiscoveryBuilder builder;

        NamespacesNested(NamespaceDiscovery item) {
            this.builder = new NamespaceDiscoveryBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)KubernetesSDConfigFluent.this.withNamespaces(this.builder.build());
        }

        public N endNamespaces() {
            return this.and();
        }
    }

    public class BasicAuthNested<N>
    extends BasicAuthFluent<BasicAuthNested<N>>
    implements Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNested(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)KubernetesSDConfigFluent.this.withBasicAuth(this.builder.build());
        }

        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends SafeAuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        SafeAuthorizationBuilder builder;

        AuthorizationNested(SafeAuthorization item) {
            this.builder = new SafeAuthorizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)KubernetesSDConfigFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }

    public class AttachMetadataNested<N>
    extends AttachMetadataFluent<AttachMetadataNested<N>>
    implements Nested<N> {
        AttachMetadataBuilder builder;

        AttachMetadataNested(AttachMetadata item) {
            this.builder = new AttachMetadataBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)KubernetesSDConfigFluent.this.withAttachMetadata(this.builder.build());
        }

        public N endAttachMetadata() {
            return this.and();
        }
    }
}

