/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkDeviceSpec;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkDeviceSpecBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkDeviceSpecFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.NetworkSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkSpecFluent<A extends NetworkSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NetworkDeviceSpecBuilder> devices = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NetworkSpecFluent() {
    }

    public NetworkSpecFluent(NetworkSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkSpec instance) {
        NetworkSpec networkSpec = instance = instance != null ? instance : new NetworkSpec();
        if (instance != null) {
            this.withDevices(instance.getDevices());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDevices(int index, NetworkDeviceSpec item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get("devices").add(index, builder);
            this.devices.add(index, builder);
        }
        return (A)this;
    }

    public A setToDevices(int index, NetworkDeviceSpec item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get("devices").set(index, builder);
            this.devices.set(index, builder);
        }
        return (A)this;
    }

    public A addToDevices(NetworkDeviceSpec ... items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (NetworkDeviceSpec item : items) {
            NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        }
        return (A)this;
    }

    public A addAllToDevices(Collection<NetworkDeviceSpec> items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (NetworkDeviceSpec item : items) {
            NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        }
        return (A)this;
    }

    public A removeFromDevices(NetworkDeviceSpec ... items) {
        if (this.devices == null) {
            return (A)this;
        }
        for (NetworkDeviceSpec item : items) {
            NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
            this._visitables.get("devices").remove(builder);
            this.devices.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDevices(Collection<NetworkDeviceSpec> items) {
        if (this.devices == null) {
            return (A)this;
        }
        for (NetworkDeviceSpec item : items) {
            NetworkDeviceSpecBuilder builder = new NetworkDeviceSpecBuilder(item);
            this._visitables.get("devices").remove(builder);
            this.devices.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDevices(Predicate<NetworkDeviceSpecBuilder> predicate) {
        if (this.devices == null) {
            return (A)this;
        }
        Iterator<NetworkDeviceSpecBuilder> each = this.devices.iterator();
        Object visitables = this._visitables.get("devices");
        while (each.hasNext()) {
            NetworkDeviceSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NetworkDeviceSpec> buildDevices() {
        return this.devices != null ? NetworkSpecFluent.build(this.devices) : null;
    }

    public NetworkDeviceSpec buildDevice(int index) {
        return this.devices.get(index).build();
    }

    public NetworkDeviceSpec buildFirstDevice() {
        return this.devices.get(0).build();
    }

    public NetworkDeviceSpec buildLastDevice() {
        return this.devices.get(this.devices.size() - 1).build();
    }

    public NetworkDeviceSpec buildMatchingDevice(Predicate<NetworkDeviceSpecBuilder> predicate) {
        for (NetworkDeviceSpecBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDevice(Predicate<NetworkDeviceSpecBuilder> predicate) {
        for (NetworkDeviceSpecBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDevices(List<NetworkDeviceSpec> devices) {
        if (this.devices != null) {
            this._visitables.get("devices").clear();
        }
        if (devices != null) {
            this.devices = new ArrayList();
            for (NetworkDeviceSpec item : devices) {
                this.addToDevices(item);
            }
        } else {
            this.devices = null;
        }
        return (A)this;
    }

    public A withDevices(NetworkDeviceSpec ... devices) {
        if (this.devices != null) {
            this.devices.clear();
            this._visitables.remove("devices");
        }
        if (devices != null) {
            for (NetworkDeviceSpec item : devices) {
                this.addToDevices(item);
            }
        }
        return (A)this;
    }

    public boolean hasDevices() {
        return this.devices != null && !this.devices.isEmpty();
    }

    public DevicesNested<A> addNewDevice() {
        return new DevicesNested(-1, null);
    }

    public DevicesNested<A> addNewDeviceLike(NetworkDeviceSpec item) {
        return new DevicesNested(-1, item);
    }

    public DevicesNested<A> setNewDeviceLike(int index, NetworkDeviceSpec item) {
        return new DevicesNested(index, item);
    }

    public DevicesNested<A> editDevice(int index) {
        if (this.devices.size() <= index) {
            throw new RuntimeException("Can't edit devices. Index exceeds size.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editFirstDevice() {
        if (this.devices.size() == 0) {
            throw new RuntimeException("Can't edit first devices. The list is empty.");
        }
        return this.setNewDeviceLike(0, this.buildDevice(0));
    }

    public DevicesNested<A> editLastDevice() {
        int index = this.devices.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last devices. The list is empty.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editMatchingDevice(Predicate<NetworkDeviceSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!predicate.test(this.devices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching devices. No match found.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkSpecFluent that = (NetworkSpecFluent)o;
        if (!Objects.equals(this.devices, that.devices)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.devices, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.devices != null && !this.devices.isEmpty()) {
            sb.append("devices:");
            sb.append(this.devices + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DevicesNested<N>
    extends NetworkDeviceSpecFluent<DevicesNested<N>>
    implements Nested<N> {
        NetworkDeviceSpecBuilder builder;
        int index;

        DevicesNested(int index, NetworkDeviceSpec item) {
            this.index = index;
            this.builder = new NetworkDeviceSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSpecFluent.this.setToDevices(this.index, this.builder.build());
        }

        public N endDevice() {
            return this.and();
        }
    }
}

