/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.PrefixedClaimMapping;
import io.fabric8.openshift.api.model.config.v1.PrefixedClaimMappingBuilder;
import io.fabric8.openshift.api.model.config.v1.PrefixedClaimMappingFluent;
import io.fabric8.openshift.api.model.config.v1.TokenClaimMappings;
import io.fabric8.openshift.api.model.config.v1.UsernameClaimMapping;
import io.fabric8.openshift.api.model.config.v1.UsernameClaimMappingBuilder;
import io.fabric8.openshift.api.model.config.v1.UsernameClaimMappingFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TokenClaimMappingsFluent<A extends TokenClaimMappingsFluent<A>>
extends BaseFluent<A> {
    private PrefixedClaimMappingBuilder groups;
    private UsernameClaimMappingBuilder username;
    private Map<String, Object> additionalProperties;

    public TokenClaimMappingsFluent() {
    }

    public TokenClaimMappingsFluent(TokenClaimMappings instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TokenClaimMappings instance) {
        TokenClaimMappings tokenClaimMappings = instance = instance != null ? instance : new TokenClaimMappings();
        if (instance != null) {
            this.withGroups(instance.getGroups());
            this.withUsername(instance.getUsername());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PrefixedClaimMapping buildGroups() {
        return this.groups != null ? this.groups.build() : null;
    }

    public A withGroups(PrefixedClaimMapping groups) {
        this._visitables.remove("groups");
        if (groups != null) {
            this.groups = new PrefixedClaimMappingBuilder(groups);
            this._visitables.get("groups").add(this.groups);
        } else {
            this.groups = null;
            this._visitables.get("groups").remove(this.groups);
        }
        return (A)this;
    }

    public boolean hasGroups() {
        return this.groups != null;
    }

    public A withNewGroups(String claim, String prefix) {
        return this.withGroups(new PrefixedClaimMapping(claim, prefix));
    }

    public GroupsNested<A> withNewGroups() {
        return new GroupsNested(null);
    }

    public GroupsNested<A> withNewGroupsLike(PrefixedClaimMapping item) {
        return new GroupsNested(item);
    }

    public GroupsNested<A> editGroups() {
        return this.withNewGroupsLike(Optional.ofNullable(this.buildGroups()).orElse(null));
    }

    public GroupsNested<A> editOrNewGroups() {
        return this.withNewGroupsLike(Optional.ofNullable(this.buildGroups()).orElse(new PrefixedClaimMappingBuilder().build()));
    }

    public GroupsNested<A> editOrNewGroupsLike(PrefixedClaimMapping item) {
        return this.withNewGroupsLike(Optional.ofNullable(this.buildGroups()).orElse(item));
    }

    public UsernameClaimMapping buildUsername() {
        return this.username != null ? this.username.build() : null;
    }

    public A withUsername(UsernameClaimMapping username) {
        this._visitables.remove("username");
        if (username != null) {
            this.username = new UsernameClaimMappingBuilder(username);
            this._visitables.get("username").add(this.username);
        } else {
            this.username = null;
            this._visitables.get("username").remove(this.username);
        }
        return (A)this;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public UsernameNested<A> withNewUsername() {
        return new UsernameNested(null);
    }

    public UsernameNested<A> withNewUsernameLike(UsernameClaimMapping item) {
        return new UsernameNested(item);
    }

    public UsernameNested<A> editUsername() {
        return this.withNewUsernameLike(Optional.ofNullable(this.buildUsername()).orElse(null));
    }

    public UsernameNested<A> editOrNewUsername() {
        return this.withNewUsernameLike(Optional.ofNullable(this.buildUsername()).orElse(new UsernameClaimMappingBuilder().build()));
    }

    public UsernameNested<A> editOrNewUsernameLike(UsernameClaimMapping item) {
        return this.withNewUsernameLike(Optional.ofNullable(this.buildUsername()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenClaimMappingsFluent that = (TokenClaimMappingsFluent)o;
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groups, this.username, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.groups != null) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UsernameNested<N>
    extends UsernameClaimMappingFluent<UsernameNested<N>>
    implements Nested<N> {
        UsernameClaimMappingBuilder builder;

        UsernameNested(UsernameClaimMapping item) {
            this.builder = new UsernameClaimMappingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TokenClaimMappingsFluent.this.withUsername(this.builder.build());
        }

        public N endUsername() {
            return this.and();
        }
    }

    public class GroupsNested<N>
    extends PrefixedClaimMappingFluent<GroupsNested<N>>
    implements Nested<N> {
        PrefixedClaimMappingBuilder builder;

        GroupsNested(PrefixedClaimMapping item) {
            this.builder = new PrefixedClaimMappingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TokenClaimMappingsFluent.this.withGroups(this.builder.build());
        }

        public N endGroups() {
            return this.and();
        }
    }
}

