/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RoleBindingFluentImpl<A extends RoleBindingFluent<A>>
extends BaseFluent<A>
implements RoleBindingFluent<A> {
    private String apiVersion;
    private List<String> groupNames = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private ObjectReferenceBuilder roleRef;
    private ArrayList<ObjectReferenceBuilder> subjects = new ArrayList();
    private List<String> userNames = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public RoleBindingFluentImpl() {
    }

    public RoleBindingFluentImpl(RoleBinding instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withGroupNames(instance.getGroupNames());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRoleRef(instance.getRoleRef());
            this.withSubjects(instance.getSubjects());
            this.withUserNames(instance.getUserNames());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToGroupNames(int index, String item) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        this.groupNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroupNames(int index, String item) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        this.groupNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroupNames(String ... items) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroupNames(Collection<String> items) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroupNames(String ... items) {
        for (String item : items) {
            if (this.groupNames == null) continue;
            this.groupNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroupNames(Collection<String> items) {
        for (String item : items) {
            if (this.groupNames == null) continue;
            this.groupNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroupNames() {
        return this.groupNames;
    }

    @Override
    public String getGroupName(int index) {
        return this.groupNames.get(index);
    }

    @Override
    public String getFirstGroupName() {
        return this.groupNames.get(0);
    }

    @Override
    public String getLastGroupName() {
        return this.groupNames.get(this.groupNames.size() - 1);
    }

    @Override
    public String getMatchingGroupName(Predicate<String> predicate) {
        for (String item : this.groupNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroupName(Predicate<String> predicate) {
        for (String item : this.groupNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroupNames(List<String> groupNames) {
        if (groupNames != null) {
            this.groupNames = new ArrayList<String>();
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        } else {
            this.groupNames = null;
        }
        return (A)this;
    }

    @Override
    public A withGroupNames(String ... groupNames) {
        if (this.groupNames != null) {
            this.groupNames.clear();
            this._visitables.remove("groupNames");
        }
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroupNames() {
        return this.groupNames != null && !this.groupNames.isEmpty();
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ObjectReference getRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public ObjectReference buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(ObjectReference roleRef) {
        this._visitables.get("roleRef").remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new ObjectReferenceBuilder(roleRef);
            this._visitables.get("roleRef").add(this.roleRef);
        } else {
            this.roleRef = null;
            this._visitables.get("roleRef").remove(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleRef() {
        return this.roleRef != null;
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(ObjectReference item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(ObjectReference item) {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : item);
    }

    @Override
    public A addToSubjects(int index, ObjectReference item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").add(index, builder);
            this.subjects.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToSubjects(int index, ObjectReference item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").set(index, builder);
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(ObjectReference ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<ObjectReference> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubjects(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.subjects.iterator();
        Object visitables = this._visitables.get("subjects");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ObjectReference> getSubjects() {
        return this.subjects != null ? RoleBindingFluentImpl.build(this.subjects) : null;
    }

    @Override
    public List<ObjectReference> buildSubjects() {
        return this.subjects != null ? RoleBindingFluentImpl.build(this.subjects) : null;
    }

    @Override
    public ObjectReference buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    @Override
    public ObjectReference buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public ObjectReference buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public ObjectReference buildMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubjects(List<ObjectReference> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").clear();
        }
        if (subjects != null) {
            this.subjects = new ArrayList();
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjects(ObjectReference ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
            this._visitables.remove("subjects");
        }
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(ObjectReference item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index, ObjectReference item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public A addToUserNames(int index, String item) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        this.userNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUserNames(int index, String item) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        this.userNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUserNames(String ... items) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.userNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUserNames(Collection<String> items) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.userNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUserNames(String ... items) {
        for (String item : items) {
            if (this.userNames == null) continue;
            this.userNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUserNames(Collection<String> items) {
        for (String item : items) {
            if (this.userNames == null) continue;
            this.userNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUserNames() {
        return this.userNames;
    }

    @Override
    public String getUserName(int index) {
        return this.userNames.get(index);
    }

    @Override
    public String getFirstUserName() {
        return this.userNames.get(0);
    }

    @Override
    public String getLastUserName() {
        return this.userNames.get(this.userNames.size() - 1);
    }

    @Override
    public String getMatchingUserName(Predicate<String> predicate) {
        for (String item : this.userNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUserName(Predicate<String> predicate) {
        for (String item : this.userNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUserNames(List<String> userNames) {
        if (userNames != null) {
            this.userNames = new ArrayList<String>();
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        } else {
            this.userNames = null;
        }
        return (A)this;
    }

    @Override
    public A withUserNames(String ... userNames) {
        if (this.userNames != null) {
            this.userNames.clear();
            this._visitables.remove("userNames");
        }
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUserNames() {
        return this.userNames != null && !this.userNames.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleBindingFluentImpl that = (RoleBindingFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.groupNames, that.groupNames)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.roleRef, that.roleRef)) {
            return false;
        }
        if (!Objects.equals(this.subjects, that.subjects)) {
            return false;
        }
        if (!Objects.equals(this.userNames, that.userNames)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groupNames, this.kind, this.metadata, this.roleRef, this.subjects, this.userNames, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.groupNames != null && !this.groupNames.isEmpty()) {
            sb.append("groupNames:");
            sb.append(this.groupNames + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.roleRef != null) {
            sb.append("roleRef:");
            sb.append(this.roleRef + ",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects + ",");
        }
        if (this.userNames != null && !this.userNames.isEmpty()) {
            sb.append("userNames:");
            sb.append(this.userNames + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SubjectsNestedImpl<N>
    extends ObjectReferenceFluentImpl<RoleBindingFluent.SubjectsNested<N>>
    implements RoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;
        int index;

        SubjectsNestedImpl(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    class RoleRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<RoleBindingFluent.RoleRefNested<N>>
    implements RoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        RoleRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<RoleBindingFluent.MetadataNested<N>>
    implements RoleBindingFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

