/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2RootVolume;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2RootVolumeBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2RootVolumeFluentImpl;
import io.fabric8.openshift.api.model.installer.aws.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>>
extends BaseFluent<A>
implements MachinePoolFluent<A> {
    private String amiID;
    private String iamRole;
    private EC2RootVolumeBuilder rootVolume;
    private String type;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolFluentImpl() {
    }

    public MachinePoolFluentImpl(MachinePool instance) {
        this.withAmiID(instance.getAmiID());
        this.withIamRole(instance.getIamRole());
        this.withRootVolume(instance.getRootVolume());
        this.withType(instance.getType());
        this.withZones(instance.getZones());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getAmiID() {
        return this.amiID;
    }

    @Override
    public A withAmiID(String amiID) {
        this.amiID = amiID;
        return (A)this;
    }

    @Override
    public Boolean hasAmiID() {
        return this.amiID != null;
    }

    @Override
    public String getIamRole() {
        return this.iamRole;
    }

    @Override
    public A withIamRole(String iamRole) {
        this.iamRole = iamRole;
        return (A)this;
    }

    @Override
    public Boolean hasIamRole() {
        return this.iamRole != null;
    }

    @Override
    @Deprecated
    public EC2RootVolume getRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    @Override
    public EC2RootVolume buildRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    @Override
    public A withRootVolume(EC2RootVolume rootVolume) {
        this._visitables.get("rootVolume").remove(this.rootVolume);
        if (rootVolume != null) {
            this.rootVolume = new EC2RootVolumeBuilder(rootVolume);
            this._visitables.get("rootVolume").add(this.rootVolume);
        } else {
            this.rootVolume = null;
            this._visitables.get("rootVolume").remove(this.rootVolume);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRootVolume() {
        return this.rootVolume != null;
    }

    @Override
    public A withNewRootVolume(Integer iops, String kmsKeyARN, Integer size, String type) {
        return this.withRootVolume(new EC2RootVolume(iops, kmsKeyARN, size, type));
    }

    @Override
    public MachinePoolFluent.RootVolumeNested<A> withNewRootVolume() {
        return new RootVolumeNestedImpl();
    }

    @Override
    public MachinePoolFluent.RootVolumeNested<A> withNewRootVolumeLike(EC2RootVolume item) {
        return new RootVolumeNestedImpl(item);
    }

    @Override
    public MachinePoolFluent.RootVolumeNested<A> editRootVolume() {
        return this.withNewRootVolumeLike(this.getRootVolume());
    }

    @Override
    public MachinePoolFluent.RootVolumeNested<A> editOrNewRootVolume() {
        return this.withNewRootVolumeLike(this.getRootVolume() != null ? this.getRootVolume() : new EC2RootVolumeBuilder().build());
    }

    @Override
    public MachinePoolFluent.RootVolumeNested<A> editOrNewRootVolumeLike(EC2RootVolume item) {
        return this.withNewRootVolumeLike(this.getRootVolume() != null ? this.getRootVolume() : item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public A addToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    @Override
    public A setToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    @Override
    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromZones(String ... items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromZones(Collection<String> items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getZones() {
        return this.zones;
    }

    @Override
    public String getZone(Integer index) {
        return this.zones.get(index);
    }

    @Override
    public String getFirstZone() {
        return this.zones.get(0);
    }

    @Override
    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    @Override
    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    @Override
    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachinePoolFluentImpl that = (MachinePoolFluentImpl)o;
        if (this.amiID != null ? !this.amiID.equals(that.amiID) : that.amiID != null) {
            return false;
        }
        if (this.iamRole != null ? !this.iamRole.equals(that.iamRole) : that.iamRole != null) {
            return false;
        }
        if (this.rootVolume != null ? !this.rootVolume.equals(that.rootVolume) : that.rootVolume != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.zones != null ? !this.zones.equals(that.zones) : that.zones != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.amiID, this.iamRole, this.rootVolume, this.type, this.zones, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.amiID != null) {
            sb.append("amiID:");
            sb.append(this.amiID + ",");
        }
        if (this.iamRole != null) {
            sb.append("iamRole:");
            sb.append(this.iamRole + ",");
        }
        if (this.rootVolume != null) {
            sb.append("rootVolume:");
            sb.append(this.rootVolume + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(this.zones + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class RootVolumeNestedImpl<N>
    extends EC2RootVolumeFluentImpl<MachinePoolFluent.RootVolumeNested<N>>
    implements MachinePoolFluent.RootVolumeNested<N>,
    Nested<N> {
        EC2RootVolumeBuilder builder;

        RootVolumeNestedImpl(EC2RootVolume item) {
            this.builder = new EC2RootVolumeBuilder(this, item);
        }

        RootVolumeNestedImpl() {
            this.builder = new EC2RootVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluentImpl.this.withRootVolume(this.builder.build());
        }

        @Override
        public N endRootVolume() {
            return this.and();
        }
    }
}

