/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ExternalIPConfig;
import io.fabric8.openshift.api.model.config.v1.ExternalIPConfigFluent;
import io.fabric8.openshift.api.model.config.v1.ExternalIPPolicy;
import io.fabric8.openshift.api.model.config.v1.ExternalIPPolicyBuilder;
import io.fabric8.openshift.api.model.config.v1.ExternalIPPolicyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ExternalIPConfigFluentImpl<A extends ExternalIPConfigFluent<A>>
extends BaseFluent<A>
implements ExternalIPConfigFluent<A> {
    private List<String> autoAssignCIDRs = new ArrayList<String>();
    private ExternalIPPolicyBuilder policy;
    private Map<String, Object> additionalProperties;

    public ExternalIPConfigFluentImpl() {
    }

    public ExternalIPConfigFluentImpl(ExternalIPConfig instance) {
        this.withAutoAssignCIDRs(instance.getAutoAssignCIDRs());
        this.withPolicy(instance.getPolicy());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAutoAssignCIDRs(Integer index, String item) {
        if (this.autoAssignCIDRs == null) {
            this.autoAssignCIDRs = new ArrayList<String>();
        }
        this.autoAssignCIDRs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAutoAssignCIDRs(Integer index, String item) {
        if (this.autoAssignCIDRs == null) {
            this.autoAssignCIDRs = new ArrayList<String>();
        }
        this.autoAssignCIDRs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAutoAssignCIDRs(String ... items) {
        if (this.autoAssignCIDRs == null) {
            this.autoAssignCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoAssignCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAutoAssignCIDRs(Collection<String> items) {
        if (this.autoAssignCIDRs == null) {
            this.autoAssignCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.autoAssignCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAutoAssignCIDRs(String ... items) {
        for (String item : items) {
            if (this.autoAssignCIDRs == null) continue;
            this.autoAssignCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAutoAssignCIDRs(Collection<String> items) {
        for (String item : items) {
            if (this.autoAssignCIDRs == null) continue;
            this.autoAssignCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAutoAssignCIDRs() {
        return this.autoAssignCIDRs;
    }

    @Override
    public String getAutoAssignCIDR(Integer index) {
        return this.autoAssignCIDRs.get(index);
    }

    @Override
    public String getFirstAutoAssignCIDR() {
        return this.autoAssignCIDRs.get(0);
    }

    @Override
    public String getLastAutoAssignCIDR() {
        return this.autoAssignCIDRs.get(this.autoAssignCIDRs.size() - 1);
    }

    @Override
    public String getMatchingAutoAssignCIDR(Predicate<String> predicate) {
        for (String item : this.autoAssignCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAutoAssignCIDR(Predicate<String> predicate) {
        for (String item : this.autoAssignCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAutoAssignCIDRs(List<String> autoAssignCIDRs) {
        if (autoAssignCIDRs != null) {
            this.autoAssignCIDRs = new ArrayList<String>();
            for (String item : autoAssignCIDRs) {
                this.addToAutoAssignCIDRs(item);
            }
        } else {
            this.autoAssignCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withAutoAssignCIDRs(String ... autoAssignCIDRs) {
        if (this.autoAssignCIDRs != null) {
            this.autoAssignCIDRs.clear();
        }
        if (autoAssignCIDRs != null) {
            for (String item : autoAssignCIDRs) {
                this.addToAutoAssignCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAutoAssignCIDRs() {
        return this.autoAssignCIDRs != null && !this.autoAssignCIDRs.isEmpty();
    }

    @Override
    @Deprecated
    public ExternalIPPolicy getPolicy() {
        return this.policy != null ? this.policy.build() : null;
    }

    @Override
    public ExternalIPPolicy buildPolicy() {
        return this.policy != null ? this.policy.build() : null;
    }

    @Override
    public A withPolicy(ExternalIPPolicy policy) {
        this._visitables.get("policy").remove(this.policy);
        if (policy != null) {
            this.policy = new ExternalIPPolicyBuilder(policy);
            this._visitables.get("policy").add(this.policy);
        } else {
            this.policy = null;
            this._visitables.get("policy").remove(this.policy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicy() {
        return this.policy != null;
    }

    @Override
    public ExternalIPConfigFluent.PolicyNested<A> withNewPolicy() {
        return new PolicyNestedImpl();
    }

    @Override
    public ExternalIPConfigFluent.PolicyNested<A> withNewPolicyLike(ExternalIPPolicy item) {
        return new PolicyNestedImpl(item);
    }

    @Override
    public ExternalIPConfigFluent.PolicyNested<A> editPolicy() {
        return this.withNewPolicyLike(this.getPolicy());
    }

    @Override
    public ExternalIPConfigFluent.PolicyNested<A> editOrNewPolicy() {
        return this.withNewPolicyLike(this.getPolicy() != null ? this.getPolicy() : new ExternalIPPolicyBuilder().build());
    }

    @Override
    public ExternalIPConfigFluent.PolicyNested<A> editOrNewPolicyLike(ExternalIPPolicy item) {
        return this.withNewPolicyLike(this.getPolicy() != null ? this.getPolicy() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalIPConfigFluentImpl that = (ExternalIPConfigFluentImpl)o;
        if (this.autoAssignCIDRs != null ? !this.autoAssignCIDRs.equals(that.autoAssignCIDRs) : that.autoAssignCIDRs != null) {
            return false;
        }
        if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.autoAssignCIDRs, this.policy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoAssignCIDRs != null && !this.autoAssignCIDRs.isEmpty()) {
            sb.append("autoAssignCIDRs:");
            sb.append(this.autoAssignCIDRs + ",");
        }
        if (this.policy != null) {
            sb.append("policy:");
            sb.append(this.policy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PolicyNestedImpl<N>
    extends ExternalIPPolicyFluentImpl<ExternalIPConfigFluent.PolicyNested<N>>
    implements ExternalIPConfigFluent.PolicyNested<N>,
    Nested<N> {
        ExternalIPPolicyBuilder builder;

        PolicyNestedImpl(ExternalIPPolicy item) {
            this.builder = new ExternalIPPolicyBuilder(this, item);
        }

        PolicyNestedImpl() {
            this.builder = new ExternalIPPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExternalIPConfigFluentImpl.this.withPolicy(this.builder.build());
        }

        @Override
        public N endPolicy() {
            return this.and();
        }
    }
}

