/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ProjectSpec;
import io.fabric8.openshift.api.model.config.v1.ProjectSpecFluent;
import io.fabric8.openshift.api.model.config.v1.TemplateReference;
import io.fabric8.openshift.api.model.config.v1.TemplateReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.TemplateReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ProjectSpecFluentImpl<A extends ProjectSpecFluent<A>>
extends BaseFluent<A>
implements ProjectSpecFluent<A> {
    private String projectRequestMessage;
    private TemplateReferenceBuilder projectRequestTemplate;
    private Map<String, Object> additionalProperties;

    public ProjectSpecFluentImpl() {
    }

    public ProjectSpecFluentImpl(ProjectSpec instance) {
        this.withProjectRequestMessage(instance.getProjectRequestMessage());
        this.withProjectRequestTemplate(instance.getProjectRequestTemplate());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getProjectRequestMessage() {
        return this.projectRequestMessage;
    }

    @Override
    public A withProjectRequestMessage(String projectRequestMessage) {
        this.projectRequestMessage = projectRequestMessage;
        return (A)this;
    }

    @Override
    public Boolean hasProjectRequestMessage() {
        return this.projectRequestMessage != null;
    }

    @Override
    @Deprecated
    public TemplateReference getProjectRequestTemplate() {
        return this.projectRequestTemplate != null ? this.projectRequestTemplate.build() : null;
    }

    @Override
    public TemplateReference buildProjectRequestTemplate() {
        return this.projectRequestTemplate != null ? this.projectRequestTemplate.build() : null;
    }

    @Override
    public A withProjectRequestTemplate(TemplateReference projectRequestTemplate) {
        this._visitables.get("projectRequestTemplate").remove(this.projectRequestTemplate);
        if (projectRequestTemplate != null) {
            this.projectRequestTemplate = new TemplateReferenceBuilder(projectRequestTemplate);
            this._visitables.get("projectRequestTemplate").add(this.projectRequestTemplate);
        } else {
            this.projectRequestTemplate = null;
            this._visitables.get("projectRequestTemplate").remove(this.projectRequestTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProjectRequestTemplate() {
        return this.projectRequestTemplate != null;
    }

    @Override
    public A withNewProjectRequestTemplate(String name) {
        return this.withProjectRequestTemplate(new TemplateReference(name));
    }

    @Override
    public ProjectSpecFluent.ProjectRequestTemplateNested<A> withNewProjectRequestTemplate() {
        return new ProjectRequestTemplateNestedImpl();
    }

    @Override
    public ProjectSpecFluent.ProjectRequestTemplateNested<A> withNewProjectRequestTemplateLike(TemplateReference item) {
        return new ProjectRequestTemplateNestedImpl(item);
    }

    @Override
    public ProjectSpecFluent.ProjectRequestTemplateNested<A> editProjectRequestTemplate() {
        return this.withNewProjectRequestTemplateLike(this.getProjectRequestTemplate());
    }

    @Override
    public ProjectSpecFluent.ProjectRequestTemplateNested<A> editOrNewProjectRequestTemplate() {
        return this.withNewProjectRequestTemplateLike(this.getProjectRequestTemplate() != null ? this.getProjectRequestTemplate() : new TemplateReferenceBuilder().build());
    }

    @Override
    public ProjectSpecFluent.ProjectRequestTemplateNested<A> editOrNewProjectRequestTemplateLike(TemplateReference item) {
        return this.withNewProjectRequestTemplateLike(this.getProjectRequestTemplate() != null ? this.getProjectRequestTemplate() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSpecFluentImpl that = (ProjectSpecFluentImpl)o;
        if (this.projectRequestMessage != null ? !this.projectRequestMessage.equals(that.projectRequestMessage) : that.projectRequestMessage != null) {
            return false;
        }
        if (this.projectRequestTemplate != null ? !this.projectRequestTemplate.equals(that.projectRequestTemplate) : that.projectRequestTemplate != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.projectRequestMessage, this.projectRequestTemplate, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.projectRequestMessage != null) {
            sb.append("projectRequestMessage:");
            sb.append(this.projectRequestMessage + ",");
        }
        if (this.projectRequestTemplate != null) {
            sb.append("projectRequestTemplate:");
            sb.append(this.projectRequestTemplate + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ProjectRequestTemplateNestedImpl<N>
    extends TemplateReferenceFluentImpl<ProjectSpecFluent.ProjectRequestTemplateNested<N>>
    implements ProjectSpecFluent.ProjectRequestTemplateNested<N>,
    Nested<N> {
        TemplateReferenceBuilder builder;

        ProjectRequestTemplateNestedImpl(TemplateReference item) {
            this.builder = new TemplateReferenceBuilder(this, item);
        }

        ProjectRequestTemplateNestedImpl() {
            this.builder = new TemplateReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProjectSpecFluentImpl.this.withProjectRequestTemplate(this.builder.build());
        }

        @Override
        public N endProjectRequestTemplate() {
            return this.and();
        }
    }
}

