/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ReplicationControllerSpecFluent<A extends ReplicationControllerSpecFluent<A>>
extends BaseFluent<A> {
    private Integer minReadySeconds;
    private Integer replicas;
    private Map<String, String> selector;
    private PodTemplateSpecBuilder template;
    private Map<String, Object> additionalProperties;

    public ReplicationControllerSpecFluent() {
    }

    public ReplicationControllerSpecFluent(ReplicationControllerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ReplicationControllerSpec instance) {
        ReplicationControllerSpec replicationControllerSpec = instance = instance != null ? instance : new ReplicationControllerSpec();
        if (instance != null) {
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withReplicas(instance.getReplicas());
            this.withSelector(instance.getSelector());
            this.withTemplate(instance.getTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    public boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)this;
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public <K, V> A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove("template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerSpecFluent that = (ReplicationControllerSpecFluent)o;
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.replicas, this.selector, this.template, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.selector != null && !this.selector.isEmpty()) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ReplicationControllerSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

