/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanReference;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanReferenceBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanReferenceFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionCatalogHealth;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionCatalogHealthBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionCatalogHealthFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionCondition;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionConditionBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionConditionFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SubscriptionStatusFluent<A extends SubscriptionStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<SubscriptionCatalogHealthBuilder> catalogHealth = new ArrayList();
    private ArrayList<SubscriptionConditionBuilder> conditions = new ArrayList();
    private String currentCSV;
    private Integer installPlanGeneration;
    private ObjectReferenceBuilder installPlanRef;
    private String installedCSV;
    private InstallPlanReferenceBuilder installplan;
    private String lastUpdated;
    private String reason;
    private String state;
    private Map<String, Object> additionalProperties;

    public SubscriptionStatusFluent() {
    }

    public SubscriptionStatusFluent(SubscriptionStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SubscriptionStatus instance) {
        SubscriptionStatus subscriptionStatus = instance = instance != null ? instance : new SubscriptionStatus();
        if (instance != null) {
            this.withCatalogHealth(instance.getCatalogHealth());
            this.withConditions(instance.getConditions());
            this.withCurrentCSV(instance.getCurrentCSV());
            this.withInstallPlanGeneration(instance.getInstallPlanGeneration());
            this.withInstallPlanRef(instance.getInstallPlanRef());
            this.withInstalledCSV(instance.getInstalledCSV());
            this.withInstallplan(instance.getInstallplan());
            this.withLastUpdated(instance.getLastUpdated());
            this.withReason(instance.getReason());
            this.withState(instance.getState());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCatalogHealth(int index, SubscriptionCatalogHealth item) {
        if (this.catalogHealth == null) {
            this.catalogHealth = new ArrayList();
        }
        SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);
        if (index < 0 || index >= this.catalogHealth.size()) {
            this._visitables.get("catalogHealth").add(builder);
            this.catalogHealth.add(builder);
        } else {
            this._visitables.get("catalogHealth").add(index, builder);
            this.catalogHealth.add(index, builder);
        }
        return (A)this;
    }

    public A setToCatalogHealth(int index, SubscriptionCatalogHealth item) {
        if (this.catalogHealth == null) {
            this.catalogHealth = new ArrayList();
        }
        SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);
        if (index < 0 || index >= this.catalogHealth.size()) {
            this._visitables.get("catalogHealth").add(builder);
            this.catalogHealth.add(builder);
        } else {
            this._visitables.get("catalogHealth").set(index, builder);
            this.catalogHealth.set(index, builder);
        }
        return (A)this;
    }

    public A addToCatalogHealth(SubscriptionCatalogHealth ... items) {
        if (this.catalogHealth == null) {
            this.catalogHealth = new ArrayList();
        }
        for (SubscriptionCatalogHealth item : items) {
            SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);
            this._visitables.get("catalogHealth").add(builder);
            this.catalogHealth.add(builder);
        }
        return (A)this;
    }

    public A addAllToCatalogHealth(Collection<SubscriptionCatalogHealth> items) {
        if (this.catalogHealth == null) {
            this.catalogHealth = new ArrayList();
        }
        for (SubscriptionCatalogHealth item : items) {
            SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);
            this._visitables.get("catalogHealth").add(builder);
            this.catalogHealth.add(builder);
        }
        return (A)this;
    }

    public A removeFromCatalogHealth(SubscriptionCatalogHealth ... items) {
        if (this.catalogHealth == null) {
            return (A)this;
        }
        for (SubscriptionCatalogHealth item : items) {
            SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);
            this._visitables.get("catalogHealth").remove(builder);
            this.catalogHealth.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromCatalogHealth(Collection<SubscriptionCatalogHealth> items) {
        if (this.catalogHealth == null) {
            return (A)this;
        }
        for (SubscriptionCatalogHealth item : items) {
            SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);
            this._visitables.get("catalogHealth").remove(builder);
            this.catalogHealth.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
        if (this.catalogHealth == null) {
            return (A)this;
        }
        Iterator<SubscriptionCatalogHealthBuilder> each = this.catalogHealth.iterator();
        Object visitables = this._visitables.get("catalogHealth");
        while (each.hasNext()) {
            SubscriptionCatalogHealthBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SubscriptionCatalogHealth> buildCatalogHealth() {
        return this.catalogHealth != null ? SubscriptionStatusFluent.build(this.catalogHealth) : null;
    }

    public SubscriptionCatalogHealth buildCatalogHealth(int index) {
        return this.catalogHealth.get(index).build();
    }

    public SubscriptionCatalogHealth buildFirstCatalogHealth() {
        return this.catalogHealth.get(0).build();
    }

    public SubscriptionCatalogHealth buildLastCatalogHealth() {
        return this.catalogHealth.get(this.catalogHealth.size() - 1).build();
    }

    public SubscriptionCatalogHealth buildMatchingCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
        for (SubscriptionCatalogHealthBuilder item : this.catalogHealth) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
        for (SubscriptionCatalogHealthBuilder item : this.catalogHealth) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCatalogHealth(List<SubscriptionCatalogHealth> catalogHealth) {
        if (this.catalogHealth != null) {
            this._visitables.get("catalogHealth").clear();
        }
        if (catalogHealth != null) {
            this.catalogHealth = new ArrayList();
            for (SubscriptionCatalogHealth item : catalogHealth) {
                this.addToCatalogHealth(item);
            }
        } else {
            this.catalogHealth = null;
        }
        return (A)this;
    }

    public A withCatalogHealth(SubscriptionCatalogHealth ... catalogHealth) {
        if (this.catalogHealth != null) {
            this.catalogHealth.clear();
            this._visitables.remove("catalogHealth");
        }
        if (catalogHealth != null) {
            for (SubscriptionCatalogHealth item : catalogHealth) {
                this.addToCatalogHealth(item);
            }
        }
        return (A)this;
    }

    public boolean hasCatalogHealth() {
        return this.catalogHealth != null && !this.catalogHealth.isEmpty();
    }

    public CatalogHealthNested<A> addNewCatalogHealth() {
        return new CatalogHealthNested(-1, null);
    }

    public CatalogHealthNested<A> addNewCatalogHealthLike(SubscriptionCatalogHealth item) {
        return new CatalogHealthNested(-1, item);
    }

    public CatalogHealthNested<A> setNewCatalogHealthLike(int index, SubscriptionCatalogHealth item) {
        return new CatalogHealthNested(index, item);
    }

    public CatalogHealthNested<A> editCatalogHealth(int index) {
        if (this.catalogHealth.size() <= index) {
            throw new RuntimeException("Can't edit catalogHealth. Index exceeds size.");
        }
        return this.setNewCatalogHealthLike(index, this.buildCatalogHealth(index));
    }

    public CatalogHealthNested<A> editFirstCatalogHealth() {
        if (this.catalogHealth.size() == 0) {
            throw new RuntimeException("Can't edit first catalogHealth. The list is empty.");
        }
        return this.setNewCatalogHealthLike(0, this.buildCatalogHealth(0));
    }

    public CatalogHealthNested<A> editLastCatalogHealth() {
        int index = this.catalogHealth.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last catalogHealth. The list is empty.");
        }
        return this.setNewCatalogHealthLike(index, this.buildCatalogHealth(index));
    }

    public CatalogHealthNested<A> editMatchingCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.catalogHealth.size(); ++i) {
            if (!predicate.test(this.catalogHealth.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching catalogHealth. No match found.");
        }
        return this.setNewCatalogHealthLike(index, this.buildCatalogHealth(index));
    }

    public A addToConditions(int index, SubscriptionCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, SubscriptionCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(SubscriptionCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (SubscriptionCondition item : items) {
            SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<SubscriptionCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (SubscriptionCondition item : items) {
            SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(SubscriptionCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (SubscriptionCondition item : items) {
            SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<SubscriptionCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (SubscriptionCondition item : items) {
            SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<SubscriptionConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<SubscriptionConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            SubscriptionConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<SubscriptionCondition> buildConditions() {
        return this.conditions != null ? SubscriptionStatusFluent.build(this.conditions) : null;
    }

    public SubscriptionCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public SubscriptionCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public SubscriptionCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public SubscriptionCondition buildMatchingCondition(Predicate<SubscriptionConditionBuilder> predicate) {
        for (SubscriptionConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<SubscriptionConditionBuilder> predicate) {
        for (SubscriptionConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<SubscriptionCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (SubscriptionCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(SubscriptionCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (SubscriptionCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(SubscriptionCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, SubscriptionCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<SubscriptionConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getCurrentCSV() {
        return this.currentCSV;
    }

    public A withCurrentCSV(String currentCSV) {
        this.currentCSV = currentCSV;
        return (A)this;
    }

    public boolean hasCurrentCSV() {
        return this.currentCSV != null;
    }

    public Integer getInstallPlanGeneration() {
        return this.installPlanGeneration;
    }

    public A withInstallPlanGeneration(Integer installPlanGeneration) {
        this.installPlanGeneration = installPlanGeneration;
        return (A)this;
    }

    public boolean hasInstallPlanGeneration() {
        return this.installPlanGeneration != null;
    }

    public ObjectReference buildInstallPlanRef() {
        return this.installPlanRef != null ? this.installPlanRef.build() : null;
    }

    public A withInstallPlanRef(ObjectReference installPlanRef) {
        this._visitables.remove("installPlanRef");
        if (installPlanRef != null) {
            this.installPlanRef = new ObjectReferenceBuilder(installPlanRef);
            this._visitables.get("installPlanRef").add(this.installPlanRef);
        } else {
            this.installPlanRef = null;
            this._visitables.get("installPlanRef").remove(this.installPlanRef);
        }
        return (A)this;
    }

    public boolean hasInstallPlanRef() {
        return this.installPlanRef != null;
    }

    public InstallPlanRefNested<A> withNewInstallPlanRef() {
        return new InstallPlanRefNested(null);
    }

    public InstallPlanRefNested<A> withNewInstallPlanRefLike(ObjectReference item) {
        return new InstallPlanRefNested(item);
    }

    public InstallPlanRefNested<A> editInstallPlanRef() {
        return this.withNewInstallPlanRefLike(Optional.ofNullable(this.buildInstallPlanRef()).orElse(null));
    }

    public InstallPlanRefNested<A> editOrNewInstallPlanRef() {
        return this.withNewInstallPlanRefLike(Optional.ofNullable(this.buildInstallPlanRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public InstallPlanRefNested<A> editOrNewInstallPlanRefLike(ObjectReference item) {
        return this.withNewInstallPlanRefLike(Optional.ofNullable(this.buildInstallPlanRef()).orElse(item));
    }

    public String getInstalledCSV() {
        return this.installedCSV;
    }

    public A withInstalledCSV(String installedCSV) {
        this.installedCSV = installedCSV;
        return (A)this;
    }

    public boolean hasInstalledCSV() {
        return this.installedCSV != null;
    }

    public InstallPlanReference buildInstallplan() {
        return this.installplan != null ? this.installplan.build() : null;
    }

    public A withInstallplan(InstallPlanReference installplan) {
        this._visitables.remove("installplan");
        if (installplan != null) {
            this.installplan = new InstallPlanReferenceBuilder(installplan);
            this._visitables.get("installplan").add(this.installplan);
        } else {
            this.installplan = null;
            this._visitables.get("installplan").remove(this.installplan);
        }
        return (A)this;
    }

    public boolean hasInstallplan() {
        return this.installplan != null;
    }

    public A withNewInstallplan(String apiVersion, String kind, String name, String uuid) {
        return this.withInstallplan(new InstallPlanReference(apiVersion, kind, name, uuid));
    }

    public InstallplanNested<A> withNewInstallplan() {
        return new InstallplanNested(null);
    }

    public InstallplanNested<A> withNewInstallplanLike(InstallPlanReference item) {
        return new InstallplanNested(item);
    }

    public InstallplanNested<A> editInstallplan() {
        return this.withNewInstallplanLike(Optional.ofNullable(this.buildInstallplan()).orElse(null));
    }

    public InstallplanNested<A> editOrNewInstallplan() {
        return this.withNewInstallplanLike(Optional.ofNullable(this.buildInstallplan()).orElse(new InstallPlanReferenceBuilder().build()));
    }

    public InstallplanNested<A> editOrNewInstallplanLike(InstallPlanReference item) {
        return this.withNewInstallplanLike(Optional.ofNullable(this.buildInstallplan()).orElse(item));
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)this;
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getState() {
        return this.state;
    }

    public A withState(String state) {
        this.state = state;
        return (A)this;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubscriptionStatusFluent that = (SubscriptionStatusFluent)o;
        if (!Objects.equals(this.catalogHealth, that.catalogHealth)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentCSV, that.currentCSV)) {
            return false;
        }
        if (!Objects.equals(this.installPlanGeneration, that.installPlanGeneration)) {
            return false;
        }
        if (!Objects.equals(this.installPlanRef, that.installPlanRef)) {
            return false;
        }
        if (!Objects.equals(this.installedCSV, that.installedCSV)) {
            return false;
        }
        if (!Objects.equals(this.installplan, that.installplan)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdated, that.lastUpdated)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.state, that.state)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalogHealth, this.conditions, this.currentCSV, this.installPlanGeneration, this.installPlanRef, this.installedCSV, this.installplan, this.lastUpdated, this.reason, this.state, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.catalogHealth != null && !this.catalogHealth.isEmpty()) {
            sb.append("catalogHealth:");
            sb.append(this.catalogHealth + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentCSV != null) {
            sb.append("currentCSV:");
            sb.append(this.currentCSV + ",");
        }
        if (this.installPlanGeneration != null) {
            sb.append("installPlanGeneration:");
            sb.append(this.installPlanGeneration + ",");
        }
        if (this.installPlanRef != null) {
            sb.append("installPlanRef:");
            sb.append(this.installPlanRef + ",");
        }
        if (this.installedCSV != null) {
            sb.append("installedCSV:");
            sb.append(this.installedCSV + ",");
        }
        if (this.installplan != null) {
            sb.append("installplan:");
            sb.append(this.installplan + ",");
        }
        if (this.lastUpdated != null) {
            sb.append("lastUpdated:");
            sb.append(this.lastUpdated + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class InstallplanNested<N>
    extends InstallPlanReferenceFluent<InstallplanNested<N>>
    implements Nested<N> {
        InstallPlanReferenceBuilder builder;

        InstallplanNested(InstallPlanReference item) {
            this.builder = new InstallPlanReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubscriptionStatusFluent.this.withInstallplan(this.builder.build());
        }

        public N endInstallplan() {
            return this.and();
        }
    }

    public class InstallPlanRefNested<N>
    extends ObjectReferenceFluent<InstallPlanRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        InstallPlanRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubscriptionStatusFluent.this.withInstallPlanRef(this.builder.build());
        }

        public N endInstallPlanRef() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends SubscriptionConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        SubscriptionConditionBuilder builder;
        int index;

        ConditionsNested(int index, SubscriptionCondition item) {
            this.index = index;
            this.builder = new SubscriptionConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubscriptionStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class CatalogHealthNested<N>
    extends SubscriptionCatalogHealthFluent<CatalogHealthNested<N>>
    implements Nested<N> {
        SubscriptionCatalogHealthBuilder builder;
        int index;

        CatalogHealthNested(int index, SubscriptionCatalogHealth item) {
            this.index = index;
            this.builder = new SubscriptionCatalogHealthBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SubscriptionStatusFluent.this.setToCatalogHealth(this.index, this.builder.build());
        }

        public N endCatalogHealth() {
            return this.and();
        }
    }
}

