/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.Upstream;
import io.fabric8.openshift.api.model.operator.v1.UpstreamBuilder;
import io.fabric8.openshift.api.model.operator.v1.UpstreamFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.UpstreamResolvers;
import io.fabric8.openshift.api.model.operator.v1.UpstreamResolversFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class UpstreamResolversFluentImpl<A extends UpstreamResolversFluent<A>>
extends BaseFluent<A>
implements UpstreamResolversFluent<A> {
    private String policy;
    private ArrayList<UpstreamBuilder> upstreams = new ArrayList();
    private Map<String, Object> additionalProperties;

    public UpstreamResolversFluentImpl() {
    }

    public UpstreamResolversFluentImpl(UpstreamResolvers instance) {
        this.withPolicy(instance.getPolicy());
        this.withUpstreams(instance.getUpstreams());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getPolicy() {
        return this.policy;
    }

    @Override
    public A withPolicy(String policy) {
        this.policy = policy;
        return (A)this;
    }

    @Override
    public Boolean hasPolicy() {
        return this.policy != null;
    }

    @Override
    public A addToUpstreams(Integer index, Upstream item) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList();
        }
        UpstreamBuilder builder = new UpstreamBuilder(item);
        this._visitables.get("upstreams").add(index >= 0 ? index.intValue() : this._visitables.get("upstreams").size(), builder);
        this.upstreams.add(index >= 0 ? index.intValue() : this.upstreams.size(), builder);
        return (A)this;
    }

    @Override
    public A setToUpstreams(Integer index, Upstream item) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList();
        }
        UpstreamBuilder builder = new UpstreamBuilder(item);
        if (index < 0 || index >= this._visitables.get("upstreams").size()) {
            this._visitables.get("upstreams").add(builder);
        } else {
            this._visitables.get("upstreams").set(index, builder);
        }
        if (index < 0 || index >= this.upstreams.size()) {
            this.upstreams.add(builder);
        } else {
            this.upstreams.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToUpstreams(Upstream ... items) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList();
        }
        for (Upstream item : items) {
            UpstreamBuilder builder = new UpstreamBuilder(item);
            this._visitables.get("upstreams").add(builder);
            this.upstreams.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToUpstreams(Collection<Upstream> items) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList();
        }
        for (Upstream item : items) {
            UpstreamBuilder builder = new UpstreamBuilder(item);
            this._visitables.get("upstreams").add(builder);
            this.upstreams.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromUpstreams(Upstream ... items) {
        for (Upstream item : items) {
            UpstreamBuilder builder = new UpstreamBuilder(item);
            this._visitables.get("upstreams").remove(builder);
            if (this.upstreams == null) continue;
            this.upstreams.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUpstreams(Collection<Upstream> items) {
        for (Upstream item : items) {
            UpstreamBuilder builder = new UpstreamBuilder(item);
            this._visitables.get("upstreams").remove(builder);
            if (this.upstreams == null) continue;
            this.upstreams.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromUpstreams(Predicate<UpstreamBuilder> predicate) {
        if (this.upstreams == null) {
            return (A)this;
        }
        Iterator<UpstreamBuilder> each = this.upstreams.iterator();
        Object visitables = this._visitables.get("upstreams");
        while (each.hasNext()) {
            UpstreamBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Upstream> getUpstreams() {
        return this.upstreams != null ? UpstreamResolversFluentImpl.build(this.upstreams) : null;
    }

    @Override
    public List<Upstream> buildUpstreams() {
        return this.upstreams != null ? UpstreamResolversFluentImpl.build(this.upstreams) : null;
    }

    @Override
    public Upstream buildUpstream(Integer index) {
        return this.upstreams.get(index).build();
    }

    @Override
    public Upstream buildFirstUpstream() {
        return this.upstreams.get(0).build();
    }

    @Override
    public Upstream buildLastUpstream() {
        return this.upstreams.get(this.upstreams.size() - 1).build();
    }

    @Override
    public Upstream buildMatchingUpstream(Predicate<UpstreamBuilder> predicate) {
        for (UpstreamBuilder item : this.upstreams) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUpstream(Predicate<UpstreamBuilder> predicate) {
        for (UpstreamBuilder item : this.upstreams) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUpstreams(List<Upstream> upstreams) {
        if (this.upstreams != null) {
            this._visitables.get("upstreams").removeAll(this.upstreams);
        }
        if (upstreams != null) {
            this.upstreams = new ArrayList();
            for (Upstream item : upstreams) {
                this.addToUpstreams(item);
            }
        } else {
            this.upstreams = null;
        }
        return (A)this;
    }

    @Override
    public A withUpstreams(Upstream ... upstreams) {
        if (this.upstreams != null) {
            this.upstreams.clear();
        }
        if (upstreams != null) {
            for (Upstream item : upstreams) {
                this.addToUpstreams(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpstreams() {
        return this.upstreams != null && !this.upstreams.isEmpty();
    }

    @Override
    public A addNewUpstream(String address, Integer port, String type) {
        return this.addToUpstreams(new Upstream(address, port, type));
    }

    @Override
    public UpstreamResolversFluent.UpstreamsNested<A> addNewUpstream() {
        return new UpstreamsNestedImpl();
    }

    @Override
    public UpstreamResolversFluent.UpstreamsNested<A> addNewUpstreamLike(Upstream item) {
        return new UpstreamsNestedImpl(-1, item);
    }

    @Override
    public UpstreamResolversFluent.UpstreamsNested<A> setNewUpstreamLike(Integer index, Upstream item) {
        return new UpstreamsNestedImpl(index, item);
    }

    @Override
    public UpstreamResolversFluent.UpstreamsNested<A> editUpstream(Integer index) {
        if (this.upstreams.size() <= index) {
            throw new RuntimeException("Can't edit upstreams. Index exceeds size.");
        }
        return this.setNewUpstreamLike(index, this.buildUpstream(index));
    }

    @Override
    public UpstreamResolversFluent.UpstreamsNested<A> editFirstUpstream() {
        if (this.upstreams.size() == 0) {
            throw new RuntimeException("Can't edit first upstreams. The list is empty.");
        }
        return this.setNewUpstreamLike(0, this.buildUpstream(0));
    }

    @Override
    public UpstreamResolversFluent.UpstreamsNested<A> editLastUpstream() {
        int index = this.upstreams.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last upstreams. The list is empty.");
        }
        return this.setNewUpstreamLike(index, this.buildUpstream(index));
    }

    @Override
    public UpstreamResolversFluent.UpstreamsNested<A> editMatchingUpstream(Predicate<UpstreamBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.upstreams.size(); ++i) {
            if (!predicate.test(this.upstreams.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching upstreams. No match found.");
        }
        return this.setNewUpstreamLike(index, this.buildUpstream(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpstreamResolversFluentImpl that = (UpstreamResolversFluentImpl)o;
        if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) {
            return false;
        }
        if (this.upstreams != null ? !this.upstreams.equals(that.upstreams) : that.upstreams != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.policy, this.upstreams, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policy != null) {
            sb.append("policy:");
            sb.append(this.policy + ",");
        }
        if (this.upstreams != null && !this.upstreams.isEmpty()) {
            sb.append("upstreams:");
            sb.append(this.upstreams + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class UpstreamsNestedImpl<N>
    extends UpstreamFluentImpl<UpstreamResolversFluent.UpstreamsNested<N>>
    implements UpstreamResolversFluent.UpstreamsNested<N>,
    Nested<N> {
        UpstreamBuilder builder;
        Integer index;

        UpstreamsNestedImpl(Integer index, Upstream item) {
            this.index = index;
            this.builder = new UpstreamBuilder(this, item);
        }

        UpstreamsNestedImpl() {
            this.index = -1;
            this.builder = new UpstreamBuilder(this);
        }

        @Override
        public N and() {
            return (N)UpstreamResolversFluentImpl.this.setToUpstreams(this.index, this.builder.build());
        }

        @Override
        public N endUpstream() {
            return this.and();
        }
    }
}

