/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.ovirt.v1.Disk;
import io.fabric8.openshift.api.model.installer.ovirt.v1.DiskFluent;
import io.fabric8.openshift.api.model.installer.ovirt.v1.DiskFluentImpl;

public class DiskBuilder
extends DiskFluentImpl<DiskBuilder>
implements VisitableBuilder<Disk, DiskBuilder> {
    DiskFluent<?> fluent;
    Boolean validationEnabled;

    public DiskBuilder() {
        this(false);
    }

    public DiskBuilder(Boolean validationEnabled) {
        this(new Disk(), validationEnabled);
    }

    public DiskBuilder(DiskFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DiskBuilder(DiskFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Disk(), validationEnabled);
    }

    public DiskBuilder(DiskFluent<?> fluent, Disk instance) {
        this(fluent, instance, false);
    }

    public DiskBuilder(DiskFluent<?> fluent, Disk instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withSizeGB(instance.getSizeGB());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public DiskBuilder(Disk instance) {
        this(instance, (Boolean)false);
    }

    public DiskBuilder(Disk instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withSizeGB(instance.getSizeGB());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Disk build() {
        Disk buildable = new Disk(this.fluent.getSizeGB());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

