/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal.build;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.OperationInfo;
import io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.internal.PodOperationUtil;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.internal.BuildOperationContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildOperationsImpl
extends HasMetadataOperation<Build, BuildList, BuildResource>
implements BuildResource {
    public static final String OPENSHIFT_IO_BUILD_NAME = "openshift.io/build.name";
    private final boolean withTerminatedStatus;
    private final boolean withTimestamps;
    private final String sinceTimestamp;
    private final Integer sinceSeconds;
    private final Integer withTailingLines;
    private final boolean withPrettyOutput;
    private final String version;
    private final Integer limitBytes;
    private static final Integer DEFAULT_POD_LOG_WAIT_TIMEOUT = 5;
    private Integer podLogWaitTimeout;
    private final BuildOperationContext buildOperationContext;

    public BuildOperationsImpl(Client client) {
        this(new BuildOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public BuildOperationsImpl(BuildOperationContext context, OperationContext superContext) {
        super(superContext.withApiGroupName("build.openshift.io").withPlural("builds"), Build.class, BuildList.class);
        this.buildOperationContext = context;
        this.withTerminatedStatus = context.isTerminatedStatus();
        this.withTimestamps = context.isTimestamps();
        this.sinceTimestamp = context.getSinceTimestamp();
        this.sinceSeconds = context.getSinceSeconds();
        this.withTailingLines = context.getTailingLines();
        this.withPrettyOutput = context.isPrettyOutput();
        this.version = context.getVersion();
        this.limitBytes = context.getLimitBytes();
    }

    @Override
    public BuildOperationsImpl newInstance(OperationContext context) {
        return new BuildOperationsImpl(this.buildOperationContext, context);
    }

    BuildOperationContext getContext() {
        return this.buildOperationContext;
    }

    protected String getLogParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(this.withPrettyOutput);
        if (this.version != null && !this.version.isEmpty()) {
            sb.append("&version=").append(this.version);
        }
        if (this.withTerminatedStatus) {
            sb.append("&previous=true");
        }
        if (this.sinceSeconds != null) {
            sb.append("&sinceSeconds=").append(this.sinceSeconds);
        } else if (this.sinceTimestamp != null) {
            sb.append("&sinceTime=").append(this.sinceTimestamp);
        }
        if (this.withTailingLines != null) {
            sb.append("&tailLines=").append(this.withTailingLines);
        }
        if (this.limitBytes != null) {
            sb.append("&limitBytes=").append(this.limitBytes);
        }
        if (this.withTimestamps) {
            sb.append("&timestamps=true");
        }
        return sb.toString();
    }

    protected <T> T doGetLog(Class<T> type) {
        try {
            URL url = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.getLogParameters()}));
            return this.handleRawGet(url, type);
        }
        catch (IOException t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("doGetLog"), (Throwable)t);
        }
    }

    public String getLog() {
        return this.doGetLog(String.class);
    }

    public String getLog(boolean isPretty) {
        return new BuildOperationsImpl(this.getContext().withPrettyOutput(isPretty), this.context).getLog();
    }

    public Reader getLogReader() {
        return this.doGetLog(Reader.class);
    }

    public InputStream getLogInputStream() {
        return this.doGetLog(InputStream.class);
    }

    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    public LogWatch watchLog(OutputStream out) {
        try {
            this.waitUntilBuildPodBecomesReady((Build)this.fromServer().get());
            URL url = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), this.getLogParameters() + "&follow=true"}));
            LogWatchCallback callback = new LogWatchCallback(out, this.context.getExecutor());
            return callback.callAndWait(this.httpClient, url);
        }
        catch (IOException t) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("watchLog"), (Throwable)t);
        }
    }

    public Loggable withLogWaitTimeout(Integer logWaitTimeout) {
        BuildOperationsImpl result = this.newInstance(this.context);
        result.podLogWaitTimeout = logWaitTimeout;
        return result;
    }

    public Loggable withPrettyOutput() {
        return new BuildOperationsImpl(this.getContext().withPrettyOutput(true), this.context);
    }

    public PrettyLoggable tailingLines(int tailingLines) {
        return new BuildOperationsImpl(this.getContext().withTailingLines(tailingLines), this.context);
    }

    public TimeTailPrettyLoggable terminated() {
        return new BuildOperationsImpl(this.getContext().withTerminatedStatus(true), this.context);
    }

    public TailPrettyLoggable sinceTime(String sinceTimestamp) {
        return new BuildOperationsImpl(this.getContext().withSinceTimestamp(sinceTimestamp), this.context);
    }

    public TailPrettyLoggable sinceSeconds(int sinceSeconds) {
        return new BuildOperationsImpl(this.getContext().withSinceSeconds(sinceSeconds), this.context);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new BuildOperationsImpl(this.getContext().withLimitBytes(limitBytes), this.context);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new BuildOperationsImpl(this.getContext().withTimestamps(true), this.context);
    }

    private void waitUntilBuildPodBecomesReady(Build build) {
        List<PodResource> podOps = PodOperationUtil.getPodOperationsForController(this.context, build.getMetadata().getUid(), BuildOperationsImpl.getBuildPodLabels(build), this.withPrettyOutput, this.podLogWaitTimeout, null);
        BuildOperationsImpl.waitForBuildPodToBecomeReady(podOps, this.podLogWaitTimeout != null ? this.podLogWaitTimeout : DEFAULT_POD_LOG_WAIT_TIMEOUT);
    }

    private static void waitForBuildPodToBecomeReady(List<PodResource> podOps, Integer podLogWaitTimeout) {
        for (PodResource podOp : podOps) {
            PodOperationUtil.waitUntilReadyBeforeFetchingLogs(podOp, podLogWaitTimeout);
        }
    }

    static Map<String, String> getBuildPodLabels(Build build) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (build != null && build.getMetadata() != null) {
            labels.put(OPENSHIFT_IO_BUILD_NAME, build.getMetadata().getName());
        }
        return labels;
    }
}

