/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openshift.api.model.machineconfig.v1.ContainerRuntimeConfiguration;
import io.fabric8.openshift.api.model.machineconfig.v1.ContainerRuntimeConfigurationFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ContainerRuntimeConfigurationFluentImpl<A extends ContainerRuntimeConfigurationFluent<A>>
extends BaseFluent<A>
implements ContainerRuntimeConfigurationFluent<A> {
    private String logLevel;
    private Quantity logSizeMax;
    private Quantity overlaySize;
    private Long pidsLimit;
    private Map<String, Object> additionalProperties;

    public ContainerRuntimeConfigurationFluentImpl() {
    }

    public ContainerRuntimeConfigurationFluentImpl(ContainerRuntimeConfiguration instance) {
        this.withLogLevel(instance.getLogLevel());
        this.withLogSizeMax(instance.getLogSizeMax());
        this.withOverlaySize(instance.getOverlaySize());
        this.withPidsLimit(instance.getPidsLimit());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public Quantity getLogSizeMax() {
        return this.logSizeMax;
    }

    @Override
    public A withLogSizeMax(Quantity logSizeMax) {
        this.logSizeMax = logSizeMax;
        return (A)this;
    }

    @Override
    public Boolean hasLogSizeMax() {
        return this.logSizeMax != null;
    }

    @Override
    public A withNewLogSizeMax(String amount, String format) {
        return this.withLogSizeMax(new Quantity(amount, format));
    }

    @Override
    public A withNewLogSizeMax(String amount) {
        return this.withLogSizeMax(new Quantity(amount));
    }

    @Override
    public Quantity getOverlaySize() {
        return this.overlaySize;
    }

    @Override
    public A withOverlaySize(Quantity overlaySize) {
        this.overlaySize = overlaySize;
        return (A)this;
    }

    @Override
    public Boolean hasOverlaySize() {
        return this.overlaySize != null;
    }

    @Override
    public A withNewOverlaySize(String amount, String format) {
        return this.withOverlaySize(new Quantity(amount, format));
    }

    @Override
    public A withNewOverlaySize(String amount) {
        return this.withOverlaySize(new Quantity(amount));
    }

    @Override
    public Long getPidsLimit() {
        return this.pidsLimit;
    }

    @Override
    public A withPidsLimit(Long pidsLimit) {
        this.pidsLimit = pidsLimit;
        return (A)this;
    }

    @Override
    public Boolean hasPidsLimit() {
        return this.pidsLimit != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerRuntimeConfigurationFluentImpl that = (ContainerRuntimeConfigurationFluentImpl)o;
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.logSizeMax != null ? !this.logSizeMax.equals(that.logSizeMax) : that.logSizeMax != null) {
            return false;
        }
        if (this.overlaySize != null ? !this.overlaySize.equals(that.overlaySize) : that.overlaySize != null) {
            return false;
        }
        if (this.pidsLimit != null ? !this.pidsLimit.equals(that.pidsLimit) : that.pidsLimit != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.logLevel, this.logSizeMax, this.overlaySize, this.pidsLimit, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.logSizeMax != null) {
            sb.append("logSizeMax:");
            sb.append(this.logSizeMax + ",");
        }
        if (this.overlaySize != null) {
            sb.append("overlaySize:");
            sb.append(this.overlaySize + ",");
        }
        if (this.pidsLimit != null) {
            sb.append("pidsLimit:");
            sb.append(this.pidsLimit + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

